/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lcm;

import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Transaction;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class Dataset {
    private List<Transaction> transactions;
    private Integer[] transactionsItems;
    Set<Integer> uniqueItems = new HashSet<Integer>();
    private int maxItem = 0;

    public Dataset(String datasetPath) throws IOException {
        String items;
        this.transactions = new ArrayList<Transaction>();
        BufferedReader br = new BufferedReader(new FileReader(datasetPath));
        while ((items = br.readLine()) != null) {
            if (items.isEmpty() || items.charAt(0) == '#' || items.charAt(0) == '%' || items.charAt(0) == '@') continue;
            this.getTransactions().add(this.createTransaction(items));
        }
        br.close();
        Collections.sort(this.transactions, new Comparator<Transaction>(){

            @Override
            public int compare(Transaction arg0, Transaction arg1) {
                return arg0.getItems()[arg0.getItems().length - 1] - arg1.getItems()[arg1.getItems().length - 1];
            }
        });
        this.transactionsItems = new Integer[this.uniqueItems.size()];
        int i = 0;
        for (Integer item : this.uniqueItems) {
            this.transactionsItems[i++] = item;
        }
        Arrays.sort((Object[])this.transactionsItems);
    }

    private Transaction createTransaction(String line) {
        Pattern splitPattern = Pattern.compile(" ");
        String[] items = splitPattern.split(line);
        Integer[] itemsSorted = new Integer[items.length];
        for (int i = 0; i < items.length; ++i) {
            Integer item;
            itemsSorted[i] = item = Integer.valueOf(items[i]);
            this.uniqueItems.add(item);
        }
        int lastItem = itemsSorted[itemsSorted.length - 1];
        if (lastItem > this.maxItem) {
            this.maxItem = lastItem;
        }
        return new Transaction(itemsSorted);
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getUniqueItems() {
        return this.uniqueItems;
    }

    public int getMaxItem() {
        return this.maxItem;
    }

    public String toString() {
        StringBuilder datasetContent = new StringBuilder();
        for (Transaction transaction : this.transactions) {
            datasetContent.append(transaction);
            datasetContent.append("\n");
        }
        return datasetContent.toString();
    }
}

