/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.estNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class estTree {
    double N;
    double d;
    int k;
    int patternCount = 0;
    Hashtable<List<Integer>, Double> patterns;
    BufferedWriter writer;
    double minsup;
    double minsig;
    estNode root;

    estTree(double mins) {
        this.setDecayRate(2.0, 10000.0);
        this.N = 0.0;
        this.k = 0;
        this.minsup = mins / 100.0;
        this.minsig = 0.1 * this.minsup;
        this.root = new estNode();
    }

    void setDecayRate(double b, double h) {
        this.d = Math.pow(b, -1.0 / h);
    }

    void updateParams(int[] transaction) {
        this.N = this.N * this.d + 1.0;
        ++this.k;
        this.updateNodes(this.root, transaction, 0);
    }

    void updateNodes(estNode currentNode, int[] transaction, int ind) {
        if (ind >= transaction.length) {
            return;
        }
        Integer item = transaction[ind];
        estNode child = currentNode.getChildWithID(item);
        if (child != null) {
            child.update(this.k, 1, this.d);
            if (child.computeSupport(this.N) >= this.minsig) {
                this.updateNodes(child, transaction, ind + 1);
            }
        }
        this.updateNodes(currentNode, transaction, ind + 1);
    }

    void insertItem(Integer it) {
        double c = 0.0;
        this.root.children.add(new estNode(it, c, this.k));
    }

    void insertItemset(int[] transaction) {
        ArrayList<Integer> transaction2 = new ArrayList<Integer>();
        for (int it : transaction) {
            estNode child = this.root.getChildWithID(it);
            if (child == null) {
                this.insertItem(it);
                continue;
            }
            if (!(child.computeSupport(this.N) >= this.minsig)) continue;
            transaction2.add(it);
        }
        this.insert_n_itemsets(this.root, transaction2, 0, new int[0]);
    }

    double getN(int k) {
        return (1.0 - Math.pow(this.d, k)) / (1.0 - this.d);
    }

    double getCountOfItemsetWithoutItemAtPosition(int[] itemset, int pos) {
        estNode currentNode = this.root;
        for (int i = 0; i < itemset.length; ++i) {
            if (i == pos) continue;
            int item = itemset[i];
            estNode child = currentNode.getChildWithID(item);
            if (child == null) {
                return 0.0;
            }
            currentNode = child;
        }
        return currentNode.counter;
    }

    double estimateCount(int[] itemset) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < itemset.length; ++i) {
            double c = this.getCountOfItemsetWithoutItemAtPosition(itemset, i);
            if (!(c < min)) continue;
            min = c;
        }
        int n = itemset.length;
        double C_upper = this.minsig * this.getN(this.k - (n - 1)) * Math.pow(this.d, n - 1) + (1.0 - Math.pow(this.d, n - 1)) / (1.0 - this.d);
        if (min > C_upper) {
            min = C_upper;
        }
        return min;
    }

    public void insert_n_itemsets(estNode currentNode, List<Integer> transaction, int ind, int[] itemset) {
        if (ind >= transaction.size()) {
            return;
        }
        Integer item = transaction.get(ind);
        estNode child = currentNode.getChildWithID(item);
        int[] itemset2 = new int[itemset.length + 1];
        System.arraycopy(itemset, 0, itemset2, 0, itemset.length);
        itemset2[itemset2.length - 1] = item;
        if (child == null) {
            double c = this.estimateCount(itemset2);
            if (c / this.N >= this.minsig) {
                child = new estNode(item, c, this.k);
                currentNode.children.add(child);
            }
        } else if (child.counter / this.N < this.minsig) {
            if (currentNode.itemID != -1) {
                currentNode.children.remove(currentNode.getChildIndexWithID(item));
            }
        } else {
            this.insert_n_itemsets(child, transaction, ind + 1, itemset2);
        }
        this.insert_n_itemsets(currentNode, transaction, ind + 1, itemset);
    }

    void forcePruning(estNode root) {
        for (int i = 0; i < root.children.size(); ++i) {
            estNode node = root.children.get(i);
            node.update(this.k, 0, this.d);
            if (node.computeSupport(this.N) < this.minsig && root.itemID != -1) {
                root.children.remove(i--);
                continue;
            }
            this.forcePruning(node);
        }
    }

    void patternMining(estNode root, List<Integer> pattern) throws IOException {
        for (estNode node : root.children) {
            ArrayList<Integer> patt2 = new ArrayList<Integer>(pattern);
            patt2.add(node.itemID);
            node.update(this.k, 0, this.d);
            double s = node.computeSupport(this.N);
            if (!(s > this.minsup)) continue;
            ++this.patternCount;
            if (this.patterns == null) {
                this.writeItemset(patt2, s);
            } else {
                this.patterns.put(new ArrayList<Integer>(patt2), s);
            }
            this.patternMining(node, patt2);
        }
    }

    Hashtable<List<Integer>, Double> patternMining_saveToMemory() throws IOException {
        this.patterns = new Hashtable();
        this.patternCount = 0;
        this.patternMining(this.root, new ArrayList<Integer>());
        return this.patterns;
    }

    void patternMining_saveToFile(String outputPath) throws IOException {
        this.patterns = null;
        this.writer = new BufferedWriter(new FileWriter(outputPath));
        this.patternCount = 0;
        this.patternMining(this.root, new ArrayList<Integer>());
        this.writer.close();
    }

    void writeItemset(List<Integer> itemset, double support) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (Integer item : itemset) {
            buffer.append(item);
            buffer.append(" ");
        }
        buffer.append("#SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    int getK() {
        return this.k;
    }
}

