/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized;

import ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized.BitMatrix;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AlgoDCI_Closed_Optimized {
    int closedCount = 0;
    int tidsCount = 0;
    int maxItemId = 1;
    private int minSuppRelative;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, int minsup) throws IOException {
        long startTimestamp = System.currentTimeMillis();
        this.closedCount = 0;
        System.out.println("Running the DCI-Closed algorithm");
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minSuppRelative = minsup;
        this.firstScan(input);
        final BitMatrix matrix = new BitMatrix(this.maxItemId, this.tidsCount);
        this.createVerticalDatabase(input, matrix);
        ArrayList<Integer> closedset = new ArrayList<Integer>();
        BitSet closedsetTIDs = null;
        ArrayList<Integer> preset = new ArrayList<Integer>();
        ArrayList<Integer> postset = new ArrayList<Integer>(this.maxItemId);
        for (int i = 1; i <= this.maxItemId; ++i) {
            if (matrix.getSupportOfItemFirstTime(i) < this.minSuppRelative) continue;
            postset.add(i);
        }
        Collections.sort(postset, new Comparator<Integer>(){

            @Override
            public int compare(Integer item1, Integer item2) {
                if (matrix.getSupportOfItem(item1) == matrix.getSupportOfItem(item2)) {
                    return item1 < item2 ? -1 : 1;
                }
                return matrix.getSupportOfItem(item1) - matrix.getSupportOfItem(item2);
            }
        });
        this.dci_closed(true, closedset, closedsetTIDs, postset, preset, matrix, matrix);
        System.out.println("========== DCI_CLOSED - STATS ============");
        System.out.println(" Number of transactions: " + this.tidsCount);
        System.out.println(" Number of frequent closed itemsets: " + this.closedCount);
        System.out.println(" Total time ~: " + (System.currentTimeMillis() - startTimestamp) + " ms");
        this.writer.close();
    }

    private void firstScan(String input) throws NumberFormatException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.maxItemId = 0;
        this.tidsCount = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer item = Integer.parseInt(itemString);
                if (item <= this.maxItemId) continue;
                this.maxItemId = item;
            }
            ++this.tidsCount;
        }
        reader.close();
    }

    private void dci_closed(boolean firstTime, List<Integer> closedset, BitSet bitset, List<Integer> postset, List<Integer> preset, BitMatrix matrix, BitMatrix originalMatrix) throws IOException {
        for (Integer i : postset) {
            BitSet newgenTIDs;
            if (firstTime) {
                newgenTIDs = matrix.getBitSetOf(i);
            } else {
                newgenTIDs = (BitSet)bitset.clone();
                newgenTIDs.and(matrix.getBitSetOf(i));
            }
            if (newgenTIDs.cardinality() < this.minSuppRelative) continue;
            ArrayList<Integer> newgen = new ArrayList<Integer>(closedset.size() + 1);
            newgen.addAll(closedset);
            newgen.add(i);
            if (this.is_dup(newgenTIDs, preset, matrix)) continue;
            ArrayList<Integer> closedsetNew = new ArrayList<Integer>();
            closedsetNew.addAll(newgen);
            BitSet closedsetNewTIDs = null;
            closedsetNewTIDs = firstTime ? (BitSet)matrix.getBitSetOf(i).clone() : (BitSet)newgenTIDs.clone();
            ArrayList<Integer> postsetNew = new ArrayList<Integer>();
            for (Integer j : postset) {
                if (!this.smallerAccordingToTotalOrder(i, j, originalMatrix)) continue;
                if (this.isAllContainedIn(newgenTIDs, matrix.getBitSetOf(j))) {
                    closedsetNew.add(j);
                    closedsetNewTIDs.and(matrix.getBitSetOf(j));
                    continue;
                }
                postsetNew.add(j);
            }
            int support = closedsetNewTIDs.cardinality();
            this.writeOut(closedsetNew, support);
            ArrayList<Integer> presetNew = new ArrayList<Integer>(preset);
            if (firstTime) {
                BitMatrix projectedMatrix = this.projectMatrix(matrix, closedsetNewTIDs, support);
                BitSet replacement = new BitSet(support);
                replacement.set(0, support, true);
                this.dci_closed(false, closedsetNew, replacement, postsetNew, presetNew, projectedMatrix, matrix);
            } else {
                this.dci_closed(false, closedsetNew, closedsetNewTIDs, postsetNew, presetNew, matrix, originalMatrix);
            }
            preset.add(i);
        }
    }

    private boolean smallerAccordingToTotalOrder(Integer i, Integer j, BitMatrix matrix) {
        if (matrix.getSupportOfItem(i) == matrix.getSupportOfItem(j)) {
            return i < j;
        }
        return matrix.getSupportOfItem(j) - matrix.getSupportOfItem(i) > 0;
    }

    private void writeOut(List<Integer> closedset, int support) throws IOException {
        ++this.closedCount;
        StringBuffer buffer = new StringBuffer();
        Iterator<Integer> iterItem = closedset.iterator();
        while (iterItem.hasNext()) {
            buffer.append(iterItem.next());
            if (!iterItem.hasNext()) break;
            buffer.append(' ');
        }
        buffer.append(" #SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private boolean is_dup(BitSet newgenTIDs, List<Integer> preset, BitMatrix matrix) {
        for (Integer j : preset) {
            if (!this.isAllContainedIn(newgenTIDs, matrix.getBitSetOf(j))) continue;
            return true;
        }
        return false;
    }

    private BitMatrix projectMatrix(BitMatrix matrix, BitSet bitset, int projectedsize) {
        BitMatrix newMatrix = new BitMatrix(this.maxItemId, projectedsize);
        int newBit = 0;
        int bit = bitset.nextSetBit(0);
        while (bit >= 0) {
            for (int item = 1; item <= this.maxItemId; ++item) {
                if (!matrix.getBitSetOf(item).get(bit)) continue;
                newMatrix.addTidForItem(item, newBit);
            }
            ++newBit;
            bit = bitset.nextSetBit(bit + 1);
        }
        return newMatrix;
    }

    private void createVerticalDatabase(String input, BitMatrix matrix) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        int tidCount = 0;
        while ((line = reader.readLine()) != null) {
            for (String itemString : line.split(" ")) {
                matrix.addTidForItem(Integer.parseInt(itemString), tidCount);
            }
            ++tidCount;
        }
        reader.close();
    }

    private boolean isAllContainedIn(BitSet bs1, BitSet bs2) {
        int i = bs1.nextSetBit(0);
        while (i >= 0) {
            if (!bs2.get(i)) {
                return false;
            }
            i = bs1.nextSetBit(i + 1);
        }
        return true;
    }
}

