/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.apriori_HT;

import ca.pfv.spmf.algorithms.frequentpatterns.apriori_HT.ItemsetHashTree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoAprioriHT {
    protected int k;
    protected int totalCandidateCount = 0;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    private int hash_tree_branch_count;
    private int minsupRelative;
    private List<int[]> database = null;
    BufferedWriter writer = null;

    public void runAlgorithm(double minsup, String input, String output, int hash_tree_branch_count) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.itemsetCount = 0;
        this.totalCandidateCount = 0;
        MemoryLogger.getInstance().reset();
        int transactionCount = 0;
        this.hash_tree_branch_count = hash_tree_branch_count;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        this.database = new ArrayList<int[]>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            for (int i = 0; i < lineSplited.length; ++i) {
                Integer item = Integer.parseInt(lineSplited[i]);
                transaction[i] = item;
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item, count);
            }
            this.database.add(transaction);
            ++transactionCount;
        }
        reader.close();
        this.minsupRelative = (int)Math.ceil(minsup * (double)transactionCount);
        this.k = 1;
        ArrayList<Integer> frequent1 = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minsupRelative) continue;
            frequent1.add((Integer)entry.getKey());
            this.saveItemsetToFile((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        mapItemCount = null;
        Collections.sort(frequent1, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        if (frequent1.size() == 0) {
            return;
        }
        this.totalCandidateCount += frequent1.size();
        this.k = 2;
        int previousItemsetCount = this.itemsetCount;
        ItemsetHashTree candidatesK = null;
        do {
            MemoryLogger.getInstance().checkMemory();
            candidatesK = this.k == 2 ? this.generateCandidate2(frequent1) : this.generateCandidateSizeK(candidatesK, this.k);
            if (candidatesK.candidateCount == 0) break;
            this.totalCandidateCount += candidatesK.candidateCount;
            for (int[] transaction : this.database) {
                if (transaction.length < this.k) continue;
                candidatesK.updateSupportCount(transaction);
            }
            ItemsetHashTree.LeafNode node = candidatesK.lastInsertedNode;
            while (node != null) {
                for (List<Itemset> listCandidate : node.candidates) {
                    if (listCandidate == null) continue;
                    for (int i = 0; i < listCandidate.size(); ++i) {
                        Itemset candidate = listCandidate.get(i);
                        if (candidate.getAbsoluteSupport() >= this.minsupRelative) {
                            this.saveItemsetToFile(candidate);
                            continue;
                        }
                        listCandidate.remove(i);
                    }
                }
                node = node.nextLeafNode;
            }
            ++this.k;
        } while (previousItemsetCount != this.itemsetCount);
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
    }

    private ItemsetHashTree generateCandidateSizeK(ItemsetHashTree candidatesK_1, int k) {
        ItemsetHashTree newCandidates = new ItemsetHashTree(k, this.hash_tree_branch_count);
        ItemsetHashTree.LeafNode node = candidatesK_1.lastInsertedNode;
        while (node != null) {
            List<Itemset>[] subgroups = node.candidates;
            for (int i = 0; i < subgroups.length; ++i) {
                if (subgroups[i] == null) continue;
                for (int j = i; j < subgroups.length; ++j) {
                    if (subgroups[j] == null) continue;
                    this.generate(subgroups[i], subgroups[j], candidatesK_1, newCandidates);
                }
            }
            node = node.nextLeafNode;
        }
        return newCandidates;
    }

    private void generate(List<Itemset> list1, List<Itemset> list2, ItemsetHashTree candidatesK_1, ItemsetHashTree newCandidates) {
        block0: for (int i = 0; i < list1.size(); ++i) {
            int j;
            int[] itemset1 = list1.get((int)i).itemset;
            int n = j = list1 == list2 ? i + 1 : 0;
            while (j < list2.size()) {
                block7: {
                    int[] itemset2 = list2.get((int)j).itemset;
                    for (int k = 0; k < itemset1.length; ++k) {
                        if (k == itemset1.length - 1) continue;
                        if (itemset2[k] > itemset1[k]) continue block0;
                        if (itemset1[k] <= itemset2[k]) {
                            continue;
                        }
                        break block7;
                    }
                    int[] newItemset = new int[itemset1.length + 1];
                    if (itemset2[itemset2.length - 1] < itemset1[itemset1.length - 1]) {
                        System.arraycopy(itemset2, 0, newItemset, 0, itemset2.length);
                        newItemset[itemset1.length] = itemset1[itemset1.length - 1];
                    } else {
                        System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                        newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                    }
                    if (this.allSubsetsOfSizeK_1AreFrequent(newItemset, candidatesK_1)) {
                        newCandidates.insertCandidateItemset(new Itemset(newItemset));
                    }
                }
                ++j;
            }
        }
    }

    private ItemsetHashTree generateCandidate2(List<Integer> frequent1) {
        ItemsetHashTree candidates = new ItemsetHashTree(2, this.hash_tree_branch_count);
        for (int i = 0; i < frequent1.size(); ++i) {
            Integer item1 = frequent1.get(i);
            for (int j = i + 1; j < frequent1.size(); ++j) {
                Integer item2 = frequent1.get(j);
                candidates.insertCandidateItemset(new Itemset(new int[]{item1, item2}));
            }
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(int[] itemset, ItemsetHashTree hashtreeCandidatesK_1) {
        for (int posRemoved = 0; posRemoved < itemset.length; ++posRemoved) {
            if (hashtreeCandidatesK_1.isInTheTree(itemset, posRemoved)) continue;
            return false;
        }
        return true;
    }

    void saveItemsetToFile(Itemset itemset) throws IOException {
        this.writer.write(itemset.toString() + " #SUP: " + itemset.getAbsoluteSupport());
        this.writer.newLine();
        ++this.itemsetCount;
    }

    void saveItemsetToFile(Integer item, Integer support) throws IOException {
        this.writer.write(item + " #SUP: " + support);
        this.writer.newLine();
        ++this.itemsetCount;
    }

    public void printStats() {
        System.out.println("=============  APRIORI-HT - STATS =============");
        System.out.println(" Candidates count : " + this.totalCandidateCount);
        System.out.println(" The algorithm stopped at size " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

