/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.RuleG;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Transaction;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AlgoTNR {
    long timeStart = 0L;
    long timeEnd = 0L;
    int maxCandidateCount = 0;
    int notAdded = 0;
    int totalremovedCount = 0;
    long totalCandidatesConsideredFromR = 0L;
    long totalRules11considered = 0L;
    double minConfidence;
    int initialK = 0;
    Database database;
    int delta = 0;
    RedBlackTree<RuleG> kRules;
    RedBlackTree<RuleG> candidates;
    int k = 0;
    int minsuppRelative;
    BitSet[] tableItemTids;
    int[] tableItemCount;

    public RedBlackTree<RuleG> runAlgorithm(int k, double minConfidence, Database database, int delta) {
        this.totalremovedCount = 0;
        this.notAdded = 0;
        MemoryLogger.getInstance().reset();
        this.maxCandidateCount = 0;
        this.totalCandidatesConsideredFromR = 0L;
        this.totalRules11considered = 0L;
        this.delta = delta;
        this.minConfidence = minConfidence;
        this.database = database;
        this.initialK = k;
        this.k = k + delta;
        this.minsuppRelative = 1;
        this.tableItemTids = new BitSet[database.maxItem + 1];
        this.tableItemCount = new int[database.maxItem + 1];
        this.kRules = new RedBlackTree();
        this.candidates = new RedBlackTree();
        this.timeStart = System.currentTimeMillis();
        this.scanDatabase(database);
        this.start();
        this.timeEnd = System.currentTimeMillis();
        this.cleanResult();
        return this.kRules;
    }

    private void start() {
        RuleG rule;
        for (int itemI = 0; itemI <= this.database.maxItem; ++itemI) {
            if (this.tableItemCount[itemI] < this.minsuppRelative) continue;
            BitSet tidsI = this.tableItemTids[itemI];
            for (int itemJ = itemI + 1; itemJ <= this.database.maxItem; ++itemJ) {
                if (this.tableItemCount[itemJ] < this.minsuppRelative) continue;
                BitSet tidsJ = this.tableItemTids[itemJ];
                BitSet commonTids = (BitSet)tidsI.clone();
                commonTids.and(tidsJ);
                int support = commonTids.cardinality();
                ++this.totalRules11considered;
                if (support < this.minsuppRelative) continue;
                this.generateRuleSize11(itemI, tidsI, itemJ, tidsJ, commonTids, support);
            }
        }
        while (this.candidates.size() > 0 && (rule = this.candidates.popMaximum()).getAbsoluteSupport() >= this.minsuppRelative) {
            ++this.totalCandidatesConsideredFromR;
            if (rule.expandLR) {
                this.expandLR(rule);
                continue;
            }
            this.expandR(rule);
        }
    }

    private void generateRuleSize11(Integer itemI, BitSet tidI, Integer itemJ, BitSet tidJ, BitSet commonTids, int cardinality) {
        Integer[] itemsetI = new Integer[]{itemI};
        Integer[] itemsetJ = new Integer[]{itemJ};
        RuleG ruleLR = new RuleG(itemsetI, itemsetJ, cardinality, tidI, commonTids, itemI, itemJ);
        double confidenceIJ = (double)cardinality / (double)this.tableItemCount[itemI];
        if (confidenceIJ >= this.minConfidence) {
            this.save(ruleLR, cardinality);
        }
        this.registerAsCandidate(true, ruleLR);
        double confidenceJI = (double)cardinality / (double)this.tableItemCount[itemJ];
        RuleG ruleRL = new RuleG(itemsetJ, itemsetI, cardinality, tidJ, commonTids, itemJ, itemI);
        if (confidenceJI >= this.minConfidence) {
            this.save(ruleRL, cardinality);
        }
        this.registerAsCandidate(true, ruleRL);
    }

    private void registerAsCandidate(boolean expandLR, RuleG rule) {
        rule.expandLR = expandLR;
        this.candidates.add(rule);
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandLR(RuleG ruleG) {
        Integer itemC;
        BitSet tidsRule;
        HashMap<Integer, BitSet> mapCountLeft = new HashMap<Integer, BitSet>();
        HashMap<Integer, BitSet> mapCountRight = new HashMap<Integer, BitSet>();
        int tid = ruleG.common.nextSetBit(0);
        while (tid >= 0) {
            Integer item;
            Iterator<Integer> iter = this.database.getTransactions().get(tid).getItems().iterator();
            while (iter.hasNext() && ((item = iter.next()) >= ruleG.maxLeft || item >= ruleG.maxRight)) {
                BitSet tidsItem;
                if (this.tableItemCount[item] < this.minsuppRelative) {
                    iter.remove();
                    continue;
                }
                if (item > ruleG.maxLeft && !ArraysAlgos.containsLEX(ruleG.getItemset2(), item, ruleG.maxRight)) {
                    tidsItem = (BitSet)mapCountLeft.get(item);
                    if (tidsItem == null) {
                        tidsItem = new BitSet();
                        mapCountLeft.put(item, tidsItem);
                    }
                    tidsItem.set(tid);
                }
                if (item <= ruleG.maxRight || ArraysAlgos.containsLEX(ruleG.getItemset1(), item, ruleG.maxLeft)) continue;
                tidsItem = (BitSet)mapCountRight.get(item);
                if (tidsItem == null) {
                    tidsItem = new BitSet();
                    mapCountRight.put(item, tidsItem);
                }
                tidsItem.set(tid);
            }
            tid = ruleG.common.nextSetBit(tid + 1);
        }
        for (Map.Entry entry : mapCountRight.entrySet()) {
            tidsRule = (BitSet)entry.getValue();
            int ruleSupport = tidsRule.cardinality();
            if (ruleSupport < this.minsuppRelative) continue;
            itemC = (Integer)entry.getKey();
            Integer[] newRightItemset = new Integer[ruleG.getItemset2().length + 1];
            System.arraycopy(ruleG.getItemset2(), 0, newRightItemset, 0, ruleG.getItemset2().length);
            newRightItemset[ruleG.getItemset2().length] = itemC;
            int maxRight = itemC >= ruleG.maxRight ? itemC : ruleG.maxRight;
            double confidence = (double)ruleSupport / (double)ruleG.tids1.cardinality();
            RuleG candidate = new RuleG(ruleG.getItemset1(), newRightItemset, ruleSupport, ruleG.tids1, tidsRule, ruleG.maxLeft, maxRight);
            if (confidence >= this.minConfidence) {
                this.save(candidate, ruleSupport);
            }
            this.registerAsCandidate(false, candidate);
        }
        for (Map.Entry entry : mapCountLeft.entrySet()) {
            tidsRule = (BitSet)entry.getValue();
            int ruleSupport = tidsRule.cardinality();
            if (ruleSupport < this.minsuppRelative) continue;
            itemC = (Integer)entry.getKey();
            BitSet tidsLeft = (BitSet)ruleG.tids1.clone();
            tidsLeft.and(this.tableItemTids[itemC]);
            Integer[] newLeftItemset = new Integer[ruleG.getItemset1().length + 1];
            System.arraycopy(ruleG.getItemset1(), 0, newLeftItemset, 0, ruleG.getItemset1().length);
            newLeftItemset[ruleG.getItemset1().length] = itemC;
            int maxLeft = itemC >= ruleG.maxLeft ? itemC : ruleG.maxLeft;
            double confidence = (double)ruleSupport / (double)tidsLeft.cardinality();
            RuleG candidate = new RuleG(newLeftItemset, ruleG.getItemset2(), ruleSupport, tidsLeft, tidsRule, maxLeft, ruleG.maxRight);
            if (confidence >= this.minConfidence) {
                this.save(candidate, ruleSupport);
            }
            this.registerAsCandidate(true, candidate);
        }
    }

    private void expandR(RuleG ruleG) {
        HashMap<Integer, BitSet> mapCountRight = new HashMap<Integer, BitSet>();
        int tid = ruleG.common.nextSetBit(0);
        while (tid >= 0) {
            Iterator<Integer> iter = this.database.getTransactions().get(tid).getItems().iterator();
            while (iter.hasNext()) {
                Integer item = iter.next();
                if (this.tableItemCount[item] < this.minsuppRelative) {
                    iter.remove();
                    continue;
                }
                if (item < ruleG.maxRight) break;
                if (item <= ruleG.maxRight || ArraysAlgos.containsLEX(ruleG.getItemset1(), item, ruleG.maxLeft)) continue;
                BitSet tidsItem = (BitSet)mapCountRight.get(item);
                if (tidsItem == null) {
                    tidsItem = new BitSet();
                    mapCountRight.put(item, tidsItem);
                }
                tidsItem.set(tid);
            }
            tid = ruleG.common.nextSetBit(tid + 1);
        }
        for (Map.Entry entry : mapCountRight.entrySet()) {
            BitSet tidsRule = (BitSet)entry.getValue();
            int ruleSupport = tidsRule.cardinality();
            if (ruleSupport < this.minsuppRelative) continue;
            Integer itemC = (Integer)entry.getKey();
            Integer[] newRightItemset = new Integer[ruleG.getItemset2().length + 1];
            System.arraycopy(ruleG.getItemset2(), 0, newRightItemset, 0, ruleG.getItemset2().length);
            newRightItemset[ruleG.getItemset2().length] = itemC;
            int maxRight = itemC >= ruleG.maxRight ? itemC : ruleG.maxRight;
            double confidence = (double)ruleSupport / (double)ruleG.tids1.cardinality();
            RuleG candidate = new RuleG(ruleG.getItemset1(), newRightItemset, ruleSupport, ruleG.tids1, tidsRule, ruleG.maxLeft, maxRight);
            if (confidence >= this.minConfidence) {
                this.save(candidate, ruleSupport);
            }
            this.registerAsCandidate(false, candidate);
        }
    }

    private void save(RuleG rule, int support) {
        RedBlackTree.Node lowerRuleNode = this.kRules.lowerNode(new RuleG(null, null, support + 1, null, null, 0, 0));
        HashSet rulesToDelete = new HashSet();
        while (lowerRuleNode != null && lowerRuleNode.key != null && ((RuleG)lowerRuleNode.key).getAbsoluteSupport() == support) {
            if (rule.getConfidence() == ((RuleG)lowerRuleNode.key).getConfidence() && this.subsume((RuleG)lowerRuleNode.key, rule)) {
                ++this.notAdded;
                return;
            }
            if (rule.getConfidence() == ((RuleG)lowerRuleNode.key).getConfidence() && this.subsume(rule, (RuleG)lowerRuleNode.key)) {
                rulesToDelete.add(lowerRuleNode.key);
                ++this.totalremovedCount;
            }
            lowerRuleNode = this.kRules.lowerNode((RuleG)lowerRuleNode.key);
        }
        for (RuleG ruleX : rulesToDelete) {
            this.kRules.remove(ruleX);
        }
        this.kRules.add(rule);
        if (this.kRules.size() > this.k) {
            if (support > this.minsuppRelative) {
                RuleG lower;
                while ((lower = this.kRules.lower(new RuleG(null, null, this.minsuppRelative + 1, null, null, 0, 0))) != null) {
                    this.kRules.remove(lower);
                    if (this.kRules.size() > this.k) continue;
                }
            }
            this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
        }
    }

    private boolean subsume(RuleG rule1, RuleG rule2) {
        if (rule1.getItemset1().length <= rule2.getItemset1().length && rule1.getItemset2().length >= rule2.getItemset2().length) {
            boolean cond1 = ArraysAlgos.containsOrEquals(rule2.getItemset1(), rule1.getItemset1());
            boolean cond2 = ArraysAlgos.containsOrEquals(rule1.getItemset2(), rule2.getItemset2());
            if (cond1 && cond2) {
                return true;
            }
        }
        return false;
    }

    private void cleanResult() {
        while (this.kRules.size() > this.initialK) {
            this.kRules.popMinimum();
        }
        this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
    }

    private void scanDatabase(Database database) {
        for (int j = 0; j < database.getTransactions().size(); ++j) {
            Transaction transaction = database.getTransactions().get(j);
            for (Integer item : transaction.getItems()) {
                BitSet ids = this.tableItemTids[item];
                if (ids == null) {
                    this.tableItemTids[item.intValue()] = new BitSet(database.tidsCount);
                }
                this.tableItemTids[item].set(j);
                this.tableItemCount[item.intValue()] = this.tableItemCount[item] + 1;
            }
        }
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (RuleG rule : this.kRules) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(rule.toString());
            buffer.append(" #SUP: ");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append(" #CONF: ");
            buffer.append(rule.getConfidence());
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }

    public void printStats() {
        System.out.println("=============  NR-TOP-K RULES - STATS =============");
        System.out.println("Minsup : " + this.minsuppRelative);
        System.out.println("Rules count: " + this.kRules.size());
        System.out.println("Total time : " + (this.timeEnd - this.timeStart) / 1000L + " s");
        System.out.println("Memory : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("Rules eliminated by strategy 1: " + this.notAdded);
        System.out.println("Rules eliminated by strategy 2: " + this.totalremovedCount);
        System.out.println("--------------------------------");
        System.out.println("===================================================");
    }
}

