/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.generate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netlib.generate.JNIGenerator;
import org.netlib.util.StringW;
import org.netlib.util.booleanW;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

class JavaGenerator {
    private static final Map<Type, String> classDefs = new HashMap<Type, String>();
    private final String COPYRIGHT = "/*\n * Copyright 2003-2007 Keith Seymour.\n * Copyright 1992-2007 The University of Tennessee. All rights reserved.\n * \n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n * \n * - Redistributions of source code must retain the above copyright\n *   notice, this list of conditions and the following disclaimer.\n * \n * - Redistributions in binary form must reproduce the above copyright\n *   notice, this list of conditions and the following disclaimer listed\n *   in this license in the documentation and/or other materials\n *   provided with the distribution.\n * \n * - Neither the name of the copyright holders nor the names of its\n *   contributors may be used to endorse or promote products derived from\n *   this software without specific prior written permission.\n * \n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n * \n * This file was auto-generated by the " + JavaGenerator.class.getCanonicalName() + "\n * program, a part of netlib-java.\n * \n" + " * @see http://code.google.com/p/netlib-java/\n" + " */\n";
    private final String javadocs;
    private final String javaWrapper;
    private final String jniC;
    private final String jniWrapper;
    private final String pkg;
    private String post;
    private String pre;
    private final String topWrapper;
    private final String wrapperName;
    private final Set<String> dontUseJNI = new HashSet<String>();
    static final Set<String> notSupportedByJNI;
    static final List<String> incompatibleWithJni;

    public static void main(String[] args) throws Exception {
        JavaGenerator blas = new JavaGenerator("org.netlib.blas", "BLAS", "lib/f2j/jlapack-0.8-javadoc.zip");
        JavaGenerator.writeToFile(blas.getAbstractWrapper(), "src/org/netlib/blas/BLAS.java");
        JavaGenerator.writeToFile(blas.getJavaWrapper(), "src/org/netlib/blas/JBLAS.java");
        JavaGenerator.writeToFile(blas.getJNIWrapper(), "src/org/netlib/blas/NativeBLAS.java");
        JavaGenerator.writeToFile(blas.getJNIC(), "jni/org_netlib_blas_NativeBLAS.c");
        JavaGenerator lapack = new JavaGenerator("org.netlib.lapack", "LAPACK", "lib/f2j/jlapack-0.8-javadoc.zip");
        JavaGenerator.writeToFile(lapack.getAbstractWrapper(), "src/org/netlib/lapack/LAPACK.java");
        JavaGenerator.writeToFile(lapack.getJavaWrapper(), "src/org/netlib/lapack/JLAPACK.java");
        JavaGenerator.writeToFile(lapack.getJNIWrapper(), "src/org/netlib/lapack/NativeLAPACK.java");
        JavaGenerator.writeToFile(lapack.getJNIC(), "jni/org_netlib_lapack_NativeLAPACK.c");
        JavaGenerator arpack = new JavaGenerator("org.netlib.arpack", "ARPACK", "");
        JavaGenerator.writeToFile(arpack.getAbstractWrapper(), "src/org/netlib/arpack/ARPACK.java");
        JavaGenerator.writeToFile(arpack.getJavaWrapper(), "src/org/netlib/arpack/JARPACK.java");
        JavaGenerator.writeToFile(arpack.getJNIWrapper(), "src/org/netlib/arpack/NativeARPACK.java");
        JavaGenerator.writeToFile(arpack.getJNIC(), "jni/org_netlib_arpack_NativeARPACK.c");
    }

    static void writeToFile(String string, String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        writer.write(string);
        writer.close();
    }

    JavaGenerator(String packageName, String wrapperName, String javadocs) throws IOException {
        this.pkg = packageName;
        this.javadocs = javadocs;
        this.wrapperName = wrapperName;
        if (wrapperName.equals("BLAS")) {
            this.pre = "cblas_";
            this.post = "";
        } else {
            this.pre = "";
            this.post = "_";
        }
        List<Class<?>> classes = this.getClasses(this.pkg, new IClassFilter(){

            @Override
            public boolean isValid(String className) {
                assert (className != null);
                assert (className.startsWith(JavaGenerator.this.pkg));
                String shortName = className.substring(JavaGenerator.this.pkg.length() + 1);
                if (shortName.toUpperCase().equals(shortName)) {
                    return false;
                }
                if (shortName.startsWith("Native")) {
                    return false;
                }
                if (shortName.contains("$")) {
                    return false;
                }
                return !shortName.endsWith("Test");
            }
        });
        ArrayList<Method> methods = new ArrayList<Method>();
        block0: for (Class<?> clazz : classes) {
            Method[] ms;
            for (Method m : ms = clazz.getDeclaredMethods()) {
                String className;
                String name = m.getName();
                if (!name.equals((className = clazz.getSimpleName()).toLowerCase())) continue;
                methods.add(m);
                continue block0;
            }
        }
        StringBuilder topWrapper = new StringBuilder();
        StringBuilder javaWrapper = new StringBuilder();
        StringBuilder jniWrapper = new StringBuilder();
        StringBuilder jniC = new StringBuilder();
        topWrapper.append(this.COPYRIGHT);
        javaWrapper.append(this.COPYRIGHT);
        jniWrapper.append(this.COPYRIGHT);
        jniC.append(this.COPYRIGHT);
        topWrapper.append("package " + this.pkg + ";\n\n");
        topWrapper.append("import java.util.logging.Logger;\n");
        topWrapper.append("import org.netlib.util.StringW;\n");
        topWrapper.append("import org.netlib.util.booleanW;\n");
        topWrapper.append("import org.netlib.util.doubleW;\n");
        topWrapper.append("import org.netlib.util.floatW;\n");
        topWrapper.append("import org.netlib.util.intW;\n\n");
        topWrapper.append("/**\n");
        topWrapper.append(" * " + wrapperName + " provider which will attempt to access a native implementation\n");
        topWrapper.append(" * and falling back to use F2J if none is available.\n *\n");
        topWrapper.append(" * @see http://sourceforge.net/projects/f2j\n");
        topWrapper.append(" * @see http://www.netlib.org/" + wrapperName.toLowerCase() + "/\n");
        topWrapper.append(" * @author Samuel Halliday\n");
        topWrapper.append(" */\n");
        topWrapper.append("public abstract class " + wrapperName + " {\n\n");
        topWrapper.append(this.topWrapperLoader(wrapperName));
        javaWrapper.append("package " + this.pkg + ";\n\n");
        javaWrapper.append("import java.util.logging.Logger;\n");
        javaWrapper.append("import org.netlib.util.StringW;\n");
        javaWrapper.append("import org.netlib.util.booleanW;\n");
        javaWrapper.append("import org.netlib.util.doubleW;\n");
        javaWrapper.append("import org.netlib.util.floatW;\n");
        javaWrapper.append("import org.netlib.util.intW;\n\n");
        javaWrapper.append("/**\n");
        javaWrapper.append(" * " + wrapperName + " provider implementation which uses F2J.\n *\n");
        javaWrapper.append(" * @see http://sourceforge.net/projects/f2j\n");
        javaWrapper.append(" * @author Samuel Halliday\n");
        javaWrapper.append(" */\n");
        javaWrapper.append("final class J" + wrapperName + " extends " + wrapperName + " {\n\n");
        javaWrapper.append("\tstatic final " + wrapperName + " INSTANCE = new J" + wrapperName + "();\n\n");
        javaWrapper.append("\tprivate J" + wrapperName + "() {\n");
        javaWrapper.append("\t}\n\n");
        jniWrapper.append("package " + this.pkg + ";\n\n");
        jniWrapper.append("import java.util.logging.Logger;\n");
        jniWrapper.append("import org.netlib.util.StringW;\n");
        jniWrapper.append("import org.netlib.util.booleanW;\n");
        jniWrapper.append("import org.netlib.util.doubleW;\n");
        jniWrapper.append("import org.netlib.util.floatW;\n");
        jniWrapper.append("import org.netlib.util.intW;\n");
        jniWrapper.append("import org.netlib.utils.JNIMethods;\n\n");
        jniWrapper.append("/**\n");
        jniWrapper.append(" * " + wrapperName + " provider implementation which uses the Java Native Interface to access\n");
        jniWrapper.append(" * system netlib libraries.\n *\n");
        jniWrapper.append(" * @see http://www.netlib.org/\n");
        jniWrapper.append(" * @author Samuel Halliday\n");
        jniWrapper.append(" */\n");
        jniWrapper.append("final class Native" + wrapperName + " extends " + wrapperName + " {\n\n");
        jniWrapper.append(this.jniWrapperLoader(wrapperName));
        jniC.append("\n#include \"f2j_jni.h\"\n");
        jniC.append("#include \"" + this.pkg.toLowerCase().replace(".", "_") + "_Native" + wrapperName + ".h\"\n\n");
        for (Method method : methods) {
            Type[] params;
            System.out.println("Generating " + method.getName());
            for (Type param : params = method.getGenericParameterTypes()) {
                if (classDefs.containsKey(param)) continue;
                System.err.println(method.getName() + " has a " + param + " parameter, so we'll not generate a JNI");
                this.dontUseJNI.add(method.getName());
            }
            String[] wrapper = this.createWrapper(method);
            topWrapper.append(wrapper[0]);
            javaWrapper.append(wrapper[1]);
            jniWrapper.append(wrapper[2]);
            jniC.append(wrapper[3]);
        }
        topWrapper.append("}\n");
        javaWrapper.append("}\n");
        jniWrapper.append("}\n");
        this.topWrapper = topWrapper.toString();
        this.javaWrapper = javaWrapper.toString();
        this.jniWrapper = jniWrapper.toString();
        this.jniC = jniC.toString();
    }

    public String getAbstractWrapper() {
        return this.topWrapper;
    }

    public String getJavaWrapper() {
        return this.javaWrapper;
    }

    public String getJNIC() {
        return this.jniC;
    }

    public String getJNIWrapper() {
        return this.jniWrapper;
    }

    private String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    private String createJavaWrapper(Method method, List<Doublet<String, String>> typeAndName) {
        StringBuilder builder = new StringBuilder();
        builder.append("\t@Override\n");
        builder.append("\tpublic " + method.getReturnType().getName().toLowerCase() + " " + method.getName() + "(");
        for (int i = 0; i < typeAndName.size(); ++i) {
            Doublet<String, String> tm = typeAndName.get(i);
            String type = (String)tm.a;
            String name = (String)tm.b;
            builder.append(type + " " + name);
            if (i == typeAndName.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(") {\n\t\t");
        if (!method.getReturnType().equals(Void.TYPE)) {
            builder.append("return ");
        }
        String n = method.getName();
        builder.append(this.pkg + "." + this.capitalize(n) + "." + n + "(");
        for (int i = 0; i < typeAndName.size(); ++i) {
            Doublet<String, String> tm = typeAndName.get(i);
            String type = (String)tm.a;
            String name = (String)tm.b;
            builder.append(name);
            if (type.contains("[]")) {
                builder.append(", 0");
            }
            if (i == typeAndName.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(");\n\t}\n\n");
        return builder.toString();
    }

    private String createJNICode(Method method, List<Doublet<String, String>> typeAndName) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        for (Doublet<String, String> tn : typeAndName) {
            types.add((String)tn.a);
            names.add((String)tn.b);
        }
        String name = this.pkg + ".Native" + this.wrapperName + "." + method.getName();
        String rtn = method.getReturnType().getName().toLowerCase();
        String pre = this.pre;
        String post = this.post;
        if (this.wrapperName.equals("BLAS") && method.getName().equals("lsame")) {
            pre = "";
            post = "_";
        }
        JNIGenerator jni = new JNIGenerator(pre, post, name, types, names, rtn, this.wrapperName.equals("BLAS"));
        return jni.getTemplate() + "\n";
    }

    private String createJNIWrapper(Method method, List<Doublet<String, String>> typeAndName) {
        StringBuilder builder = new StringBuilder();
        builder.append("\t@Override\n");
        builder.append("\tpublic native " + method.getReturnType().getName().toLowerCase() + " " + method.getName() + "(");
        for (int i = 0; i < typeAndName.size(); ++i) {
            Doublet<String, String> tm = typeAndName.get(i);
            String type = (String)tm.a;
            String name = (String)tm.b;
            builder.append(type + " " + name);
            if (i == typeAndName.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(");\n\n");
        return builder.toString();
    }

    private String createTopJavaDocs(String javadocs, List<Doublet<String, String>> typeAndName) {
        StringBuilder builder = new StringBuilder();
        builder.append("\t/**\n");
        builder.append(javadocs);
        for (int i = 0; i < typeAndName.size(); ++i) {
            builder.append("\t * @param " + (String)typeAndName.get((int)i).b + "\n");
        }
        builder.append("\t */\n");
        return builder.toString();
    }

    private String createTopWrapper(Method method, List<Doublet<String, String>> typeAndName, String javadocs) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.createTopJavaDocs(javadocs, typeAndName));
        builder.append("\tpublic abstract " + method.getReturnType().toString().toLowerCase() + " " + method.getName() + "(");
        for (int i = 0; i < typeAndName.size(); ++i) {
            builder.append((String)typeAndName.get((int)i).a + " " + (String)typeAndName.get((int)i).b);
            if (i == typeAndName.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(");\n\n");
        return builder.toString();
    }

    private String[] createWrapper(Method method) throws IOException {
        String name = method.getName();
        String[] parts = new String[4];
        Map<String, String[]> fromDocs = this.getParameterNames(method);
        String javadocs = fromDocs.keySet().iterator().next();
        String[] names = fromDocs.values().iterator().next();
        Class<?>[] paramTypes = method.getParameterTypes();
        List<Doublet<String, String>> typeAndName = this.typeAndName(paramTypes, names);
        if (notSupportedByJNI.contains(name) || incompatibleWithJni.contains(name) || this.dontUseJNI.contains(name)) {
            String javaWrapper = this.createJavaWrapper(method, typeAndName);
            String javaDocs = this.createTopJavaDocs(javadocs, typeAndName);
            parts[0] = javaWrapper.replace("@Override\n", javaDocs);
            System.err.println("Forcing F2J for " + name);
            parts[1] = "";
            parts[2] = "";
            parts[3] = "";
            return parts;
        }
        parts[0] = this.createTopWrapper(method, typeAndName, javadocs);
        parts[1] = this.createJavaWrapper(method, typeAndName);
        parts[2] = this.createJNIWrapper(method, typeAndName);
        parts[3] = this.createJNICode(method, typeAndName);
        return parts;
    }

    private List<Class<?>> getClasses(String packageName, IClassFilter filter) {
        String packagePath = packageName.replace('.', '/');
        Object[] classpath = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        ArrayList result = new ArrayList();
        System.out.println(Arrays.toString(classpath));
        for (Object url : classpath) {
            File file;
            try {
                file = new File(((URL)url).toURI());
            }
            catch (URISyntaxException e1) {
                continue;
            }
            if (file.getPath().endsWith(".jar")) {
                JarFile jarFile;
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException e) {
                    continue;
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    Class<?> clazz;
                    String entryName = entries.nextElement().getName();
                    if (!entryName.matches(packagePath + "/\\w*\\.class")) continue;
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
                    String className = entryName.replace('/', '.').substring(0, entryName.lastIndexOf(46));
                    if (!filter.isValid(className)) continue;
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    result.add(clazz);
                }
                continue;
            }
            File packageDirectory = new File(file.getPath() + "/" + packagePath);
            for (File f : packageDirectory.listFiles()) {
                Class<?> clazz;
                String className;
                if (!f.getPath().endsWith(".class") || !filter.isValid(className = packageName + "." + f.getName().substring(0, f.getName().lastIndexOf(46)))) continue;
                URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
                try {
                    clazz = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                result.add(clazz);
            }
        }
        return result;
    }

    private Map<String, String[]> getParameterNames(Method method) throws IOException {
        ZipInputStream in;
        try {
            in = new ZipInputStream(new FileInputStream(this.javadocs));
        }
        catch (FileNotFoundException e) {
            int size = method.getGenericParameterTypes().length;
            String[] names = new String[size];
            for (int i = 0; i < size; ++i) {
                names[i] = "arg" + (i + 1);
            }
            String docs = "\t * No documentation was available when generating this method.\n\t * \n";
            return Collections.singletonMap(docs, names);
        }
        String m = method.getName();
        String p = this.pkg.replace(".", "/") + "/" + m.substring(0, 1).toUpperCase() + m.substring(1) + ".html";
        try {
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String name = entry.getName();
                if (!name.endsWith(p)) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                String javadoc = new String(out.toByteArray());
                out.close();
                String[] names = this.parseParameterNames(method, javadoc);
                String documentation = this.parseJavadocDescription(method, javadoc);
                Map<String, String[]> map = Collections.singletonMap(documentation, names);
                return map;
            }
            throw new RuntimeException("getParameterNames failed");
        }
        finally {
            in.close();
        }
    }

    private String jniWrapperLoader(String wrapperName) {
        StringBuilder b = new StringBuilder();
        b.append("\t// singleton\n");
        b.append("\tprotected static final Native" + wrapperName + " INSTANCE = new Native" + wrapperName + "();\n\n");
        b.append("\t// indicates if the JNI loaded OK. If this is false, calls to the native\n");
        b.append("\t// methods will fail with UnsatisfiedLinkError\n");
        b.append("\tprotected final boolean isLoaded;\n\n");
        b.append("\tprivate Native" + wrapperName + "() {\n");
        b.append("\t\tString libname = JNIMethods.getPortableLibraryName(\"jni" + wrapperName.toLowerCase() + "\");\n");
        b.append("\t\ttry {\n");
        b.append("\t\t\tSystem.loadLibrary(libname);\n");
        b.append("\t\t} catch (UnsatisfiedLinkError e) {\n");
        b.append("\t\t\tisLoaded = false;\n");
        b.append("\t\t\treturn;\n");
        b.append("\t\t}\n");
        b.append("\t\tisLoaded = true;\n");
        b.append("\t}\n\n");
        return b.toString();
    }

    private String parseJavadocDescription(Method method, String javadoc) {
        Pattern pattern = Pattern.compile("seymour@cs.utk.edu</a> with any questions.\n<p>");
        Matcher matcher = pattern.matcher(javadoc);
        boolean matched = matcher.find();
        assert (matched);
        int start = matcher.end();
        int end = javadoc.indexOf("</pre>", start);
        javadoc = javadoc.substring(start, end).replaceAll("\n \\*", "\n").replaceAll("\n c", "\n");
        return "<pre>" + javadoc + "</pre>\n";
    }

    private String[] parseParameterNames(Method method, String javadoc) {
        int n = method.getParameterTypes().length;
        String[] names = new String[n];
        int begin = javadoc.indexOf("METHOD SUMMARY");
        Pattern pattern = Pattern.compile("\\Q>" + method.getName() + "</A></B>(\\E");
        Matcher matcher = pattern.matcher(javadoc);
        boolean matched = matcher.find(begin);
        assert (matched);
        begin = matcher.end();
        pattern = Pattern.compile("\\Q)</CODE>\\E");
        matcher = pattern.matcher(javadoc);
        matched = matcher.find(begin);
        assert (matched);
        int end = matcher.start();
        pattern = Pattern.compile("&nbsp;([^,]*)(,|$)");
        matcher = pattern.matcher(javadoc);
        matcher.region(begin, end);
        int cnt = 0;
        while (matcher.find()) {
            String name;
            names[cnt] = name = matcher.group(1);
            ++cnt;
        }
        assert (cnt == n);
        return names;
    }

    private String topWrapperLoader(String wrapperName) {
        StringBuilder builder = new StringBuilder();
        builder.append("\tstatic private final " + wrapperName + " current;\n");
        builder.append("\tstatic {\n");
        builder.append("\t\tLogger logger = Logger.getLogger(\"org.netlib\");\n");
        builder.append("\t\tif (Native" + wrapperName + ".INSTANCE.isLoaded) {\n");
        builder.append("\t\t\tcurrent = Native" + wrapperName + ".INSTANCE;\n");
        builder.append("\t\t\tlogger.config(\"Using JNI for " + wrapperName + "\");\n");
        builder.append("\t\t} else {\n");
        builder.append("\t\t\tcurrent = J" + wrapperName + ".INSTANCE;\n");
        builder.append("\t\t\tlogger.config(\"Using F2J as JNI failed for " + wrapperName + "\");\n");
        builder.append("\t\t}\n");
        builder.append("\t}\n\n");
        builder.append("\tpublic static " + wrapperName + " getInstance() {\n");
        builder.append("\t\treturn current;\n");
        builder.append("\t}\n\n");
        return builder.toString();
    }

    private List<Doublet<String, String>> typeAndName(Class<?>[] paramTypes, String[] names) {
        assert (names.length == paramTypes.length);
        ArrayList<Doublet<String, String>> l = new ArrayList<Doublet<String, String>>();
        Class<Void> lastType = Void.TYPE;
        for (int i = 0; i < names.length; ++i) {
            Class<?> type = paramTypes[i];
            if (type.equals(Integer.TYPE) && (lastType.equals(double[].class) || lastType.equals(int[].class) || lastType.equals(boolean[].class) || lastType.equals(float[].class))) {
                lastType = type;
                continue;
            }
            String t = classDefs.get(type);
            if (t == null) {
                t = "Object";
            }
            l.add(new Doublet<String, String>(t, names[i]));
            lastType = type;
        }
        return l;
    }

    static {
        classDefs.put((Type)((Object)String.class), "String");
        classDefs.put(Integer.TYPE, "int");
        classDefs.put(Double.TYPE, "double");
        classDefs.put(Boolean.TYPE, "boolean");
        classDefs.put(Float.TYPE, "float");
        classDefs.put((Type)((Object)intW.class), "intW");
        classDefs.put((Type)((Object)doubleW.class), "doubleW");
        classDefs.put((Type)((Object)booleanW.class), "booleanW");
        classDefs.put((Type)((Object)floatW.class), "floatW");
        classDefs.put((Type)((Object)StringW.class), "StringW");
        classDefs.put((Type)((Object)int[].class), "int[]");
        classDefs.put((Type)((Object)double[].class), "double[]");
        classDefs.put((Type)((Object)boolean[].class), "boolean[]");
        classDefs.put((Type)((Object)float[].class), "float[]");
        notSupportedByJNI = new HashSet<String>(Arrays.asList("disnan", "dlacn2", "dlag2s", "dlahr2", "dlaisnan", "dlaneg", "dlaqr0", "dlaqr1", "dlaqr2", "dlaqr3", "dlaqr4", "dlaqr5", "dlarra", "dlarrc", "dlarrd", "dlarrj", "dlarrk", "dlarrr", "dlazq3", "dlazq4", "dsgesv", "dstemr", "ilaver", "iparmq", "sisnan", "slag2d", "slahr2", "slaisnan", "slaneg", "slaqr0", "slaqr1", "slaqr2", "slaqr3", "slaqr4", "slaqr5", "slarra", "slarrc", "slarrj", "slarrr", "sstemr", "slacn2", "slarrd", "slarrk", "slazq3", "slazq4", "lsame", "dlangb", "dlange", "dlangt", "dlanhs", "dlansb", "dlansp", "dlanst", "dlansy", "dlantb", "dlantp", "dlantr", "dlapy2", "dlapy3", "lsamen", "slangb", "slange", "slangt", "slanhs", "slansb", "slansp", "slanst", "slansy", "slantb", "slantp", "slantr", "slapy2", "slapy3", "dlamc3", "dsecnd", "second", "slamch", "slamc3", "dmout", "dvout", "icnteq", "icopy", "iset", "iswap", "ivout", "smout", "svout", "dgetv0", "dlaqrb", "dnaitr", "dnapps", "dnaup2", "dnconv", "dneigh", "dngets", "dsaitr", "dsapps", "dsaup2", "dsconv", "dseigt", "dsesrt", "dsgets", "dsortc", "dsortr", "dstatn", "dstats", "dstqrb", "sgetv0", "slaqrb", "snaitr", "snapps", "snaup2", "snconv", "sneigh", "sngets", "ssaitr", "ssapps", "ssaup2", "ssconv", "sseigt", "ssesrt", "ssgets", "ssortc", "ssortr", "sstatn", "sstats", "sstqrb"));
        incompatibleWithJni = Arrays.asList("dlar1v", "dlarrb", "dlarre", "dlarrf", "dlarrv", "slar1v", "slarrb", "slarre", "slarrf", "slarrv");
    }

    static interface IClassFilter {
        public boolean isValid(String var1);
    }

    class Doublet<A, B> {
        public A a;
        public B b;

        public Doublet(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return this.a + " " + this.b;
        }
    }
}

