/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.timeseries.HistoricalSimulationModel;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.CMAESOptimizer;

public class DisplacedLognormal
implements HistoricalSimulationModel {
    private double[] values;
    private double lowerBoundDisplacement;
    private double upperBoundDisplacement = 1.0E7;
    private int windowIndexStart;
    private int windowIndexEnd;
    private int maxIterations = 1000000;

    public DisplacedLognormal(double[] dArray) {
        this.values = dArray;
        this.windowIndexStart = 0;
        this.windowIndexEnd = dArray.length - 1;
        double d = Double.MAX_VALUE;
        for (int i = this.windowIndexStart; i <= this.windowIndexEnd; ++i) {
            d = Math.min(dArray[i], d);
        }
        this.lowerBoundDisplacement = -d + 1.0;
    }

    public DisplacedLognormal(double[] dArray, double d) {
        this.values = dArray;
        this.windowIndexStart = 0;
        this.windowIndexEnd = dArray.length - 1;
        double d2 = Double.MAX_VALUE;
        for (int i = this.windowIndexStart; i <= this.windowIndexEnd; ++i) {
            d2 = Math.min(dArray[i], d2);
        }
        this.lowerBoundDisplacement = Math.max(-d2 + 1.0, d);
    }

    public DisplacedLognormal(double[] dArray, int n, int n2) {
        this.values = dArray;
        this.windowIndexStart = n;
        this.windowIndexEnd = n2;
        double d = Double.MAX_VALUE;
        for (int i = n; i <= n2; ++i) {
            d = Math.min(dArray[i], d);
        }
        this.lowerBoundDisplacement = -d + 1.0;
    }

    public DisplacedLognormal(double[] dArray, double d, int n, int n2) {
        this.values = dArray;
        this.windowIndexStart = n;
        this.windowIndexEnd = n2;
        double d2 = Double.MAX_VALUE;
        for (int i = n; i <= n2; ++i) {
            d2 = Math.min(dArray[i], d2);
        }
        this.lowerBoundDisplacement = Math.max(-d2 + 1.0, d);
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int n, int n2) {
        return new DisplacedLognormal(this.values, n, n2);
    }

    public HistoricalSimulationModel getCloneWithWindow(double d, int n, int n2) {
        return new DisplacedLognormal(this.values, d, n, n2);
    }

    public double getLogLikelihoodForParameters(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = 1.0 + Math.abs(d4);
        double d7 = 0.0;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double d8 = d6 * Math.log((this.values[i] + d4) / (this.values[i - 1] + d4));
            d7 += d8 * d8;
        }
        d7 /= (double)(this.windowIndexEnd - this.windowIndexStart);
        double d9 = d6 * Math.log((this.values[this.windowIndexStart + 1] + d4) / (this.values[this.windowIndexStart + 1 - 1] + d4));
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double d10 = d6 * Math.log((this.values[i + 1] + d4) / (this.values[i] + d4));
            double d11 = d7 / d6 * d6;
            d5 += -Math.log(d7) - 2.0 * Math.log((this.values[i + 1] + d4) / d6) - d10 * d10 / d7;
            d9 = d10;
        }
        d5 += -Math.log(Math.PI * 2) * (double)(this.windowIndexEnd - this.windowIndexStart);
        return d5 *= 0.5;
    }

    public double getLastResidualForParameters(double d, double d2, double d3, double d4) {
        double d5 = 1.0 + Math.abs(d4);
        double d6 = d / (1.0 - d2 - d3);
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double d7 = d5 * Math.log((this.values[i] + d4) / (this.values[i - 1] + d4));
            d6 = d + d2 * d7 * d7 + d3 * d6;
        }
        return d6;
    }

    public double[] getQuantilPredictionsForParameters(double d, double d2, double d3, double d4, double[] dArray) {
        double[] dArray2 = new double[this.windowIndexEnd - this.windowIndexStart + 1 - 1];
        double d5 = 1.0 + Math.abs(d4);
        double d6 = 0.0;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double d7 = d5 * Math.log((this.values[i] + d4) / (this.values[i - 1] + d4));
            d6 += d7 * d7;
        }
        double d8 = Math.sqrt(d6 /= (double)(this.windowIndexEnd - this.windowIndexStart)) / d5;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double d9 = Math.log((this.values[i] + d4) / (this.values[i - 1] + d4));
            dArray2[i - this.windowIndexStart - 1] = d9 / d8;
            double d10 = d5 * d9;
            d8 = Math.sqrt(d6) / d5;
        }
        Arrays.sort(dArray2);
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d11;
            double d12 = dArray[i];
            double d13 = (double)dArray2.length * d12 - 1.0;
            int n = (int)d13;
            int n2 = n + 1;
            double d14 = ((double)n2 - d13) * Math.exp(dArray2[Math.max(n, 0)] * d8) + (d13 - (double)n) * Math.exp(dArray2[Math.min(n2, dArray2.length)] * d8);
            dArray3[i] = d11 = (this.values[this.windowIndexEnd] + d4) * d14 - d4;
        }
        return dArray3;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> map) {
        class GARCHMaxLikelihoodFunction
        implements MultivariateFunction,
        Serializable {
            private static final long serialVersionUID = 7072187082052755854L;

            GARCHMaxLikelihoodFunction() {
            }

            public double value(double[] dArray) {
                double d = Math.exp(dArray[0]);
                double d2 = Math.exp(-Math.exp(-dArray[1]));
                double d3 = Math.exp(-Math.exp(-dArray[2]));
                double d4 = d2 * d3;
                double d5 = d2 - d4;
                double d6 = 1.0 / (1.0 + Math.exp(-dArray[3]));
                double d7 = (DisplacedLognormal.this.upperBoundDisplacement - DisplacedLognormal.this.lowerBoundDisplacement) * d6 + DisplacedLognormal.this.lowerBoundDisplacement;
                double d8 = DisplacedLognormal.this.getLogLikelihoodForParameters(d, d5, d4, d7);
                d8 -= Math.max(1.0E-30 - d, 0.0) / 1.0E-30;
                d8 -= Math.max(1.0E-30 - d5, 0.0) / 1.0E-30;
                d8 -= Math.max(d5 - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                d8 -= Math.max(1.0E-30 - d4, 0.0) / 1.0E-30;
                d8 -= Math.max(d4 - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                d8 -= Math.max(1.0E-30 - d6, 0.0) / 1.0E-30;
                return d8 -= Math.max(d6 - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
            }
        }
        GARCHMaxLikelihoodFunction gARCHMaxLikelihoodFunction = new GARCHMaxLikelihoodFunction();
        double d = 1.0;
        double d2 = 0.2;
        double d3 = 0.2;
        double d4 = (this.lowerBoundDisplacement + this.upperBoundDisplacement) / 2.0;
        if (map != null) {
            d = (Double)map.get("Omega");
            d2 = (Double)map.get("Alpha");
            d3 = (Double)map.get("Beta");
            d4 = (Double)map.get("Displacement");
        }
        d = DisplacedLognormal.restrictToOpenSet(d, 0.0, Double.MAX_VALUE);
        d2 = DisplacedLognormal.restrictToOpenSet(d2, 0.0, 1.0);
        d3 = DisplacedLognormal.restrictToOpenSet(d3, 0.0, 1.0 - d2);
        d4 = DisplacedLognormal.restrictToOpenSet(d4, this.lowerBoundDisplacement, this.upperBoundDisplacement);
        double d5 = d2 + d3;
        double d6 = d3 / (d2 + d3);
        double[] dArray = new double[]{Math.log(d), -Math.log(-Math.log(d5)), -Math.log(-Math.log(d6)), -Math.log(1.0 / ((d4 - this.lowerBoundDisplacement) / (this.upperBoundDisplacement - this.lowerBoundDisplacement)) - 1.0)};
        CMAESOptimizer cMAESOptimizer = new CMAESOptimizer();
        double[] dArray2 = null;
        try {
            PointValuePair pointValuePair = cMAESOptimizer.optimize(this.maxIterations, (MultivariateFunction)gARCHMaxLikelihoodFunction, GoalType.MAXIMIZE, dArray);
            dArray2 = pointValuePair.getPoint();
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            double[] dArray3 = new double[]{0.0, 0.0, 0.0, 10.0};
            System.out.println("Solver failed");
            dArray2 = dArray3;
        }
        double d7 = Math.exp(dArray2[0]);
        double d8 = Math.exp(-Math.exp(-dArray2[1]));
        double d9 = Math.exp(-Math.exp(-dArray2[2]));
        double d10 = d8 * d9;
        double d11 = d8 - d10;
        double d12 = 1.0 / (1.0 + Math.exp(-dArray2[3]));
        double d13 = (this.upperBoundDisplacement - this.lowerBoundDisplacement) * d12 + this.lowerBoundDisplacement;
        double[] dArray4 = new double[]{0.01, 0.05, 0.5};
        double[] dArray5 = this.getQuantilPredictionsForParameters(d7, d11, d10, d13, dArray4);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Omega", d7);
        hashMap.put("Alpha", d11);
        hashMap.put("Beta", d10);
        hashMap.put("Displacement", d13);
        hashMap.put("Likelihood", this.getLogLikelihoodForParameters(d7, d11, d10, d13));
        hashMap.put("Vol", Math.sqrt(this.getLastResidualForParameters(d7, d11, d10, d13)));
        hashMap.put("Quantile=1%", dArray5[0]);
        hashMap.put("Quantile=5%", dArray5[1]);
        hashMap.put("Quantile=50%", dArray5[2]);
        return hashMap;
    }

    private static double restrictToOpenSet(double d, double d2, double d3) {
        d = Math.max(d, d2 * (1.0 + Math.signum(d2) * 1.0E-15) + 1.0E-15);
        d = Math.min(d, d3 * (1.0 - Math.signum(d3) * 1.0E-15) - 1.0E-15);
        return d;
    }
}

