/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.util.Calendar;
import net.finmath.time.daycount.DayCountConventionInterface;

public class DayCountConvention_30E_360_ISDA
implements DayCountConventionInterface {
    private final boolean isTreatEndDateAsTerminationDate;

    public DayCountConvention_30E_360_ISDA(boolean bl) {
        this.isTreatEndDateAsTerminationDate = bl;
    }

    public DayCountConvention_30E_360_ISDA() {
        this(false);
    }

    @Override
    public double getDaycount(Calendar calendar, Calendar calendar2) {
        boolean bl;
        if (calendar.after(calendar2)) {
            return -this.getDaycount(calendar2, calendar);
        }
        double d = calendar.get(5);
        double d2 = calendar.get(2);
        double d3 = calendar.get(1);
        double d4 = calendar2.get(5);
        double d5 = calendar2.get(2);
        double d6 = calendar2.get(1);
        boolean bl2 = d2 == 1.0 && d == (double)calendar.getActualMaximum(5);
        boolean bl3 = bl = d5 == 1.0 && d4 == (double)calendar2.getActualMaximum(5);
        if (bl2 || d == 31.0) {
            d = 30.0;
        }
        if (bl && !this.isTreatEndDateAsTerminationDate || d4 == 31.0) {
            d4 = 30.0;
        }
        return (d6 - d3) * 360.0 + (d5 - d2) * 30.0 + (d4 - Math.min(d, 30.0));
    }

    @Override
    public double getDaycountFraction(Calendar calendar, Calendar calendar2) {
        return this.getDaycount(calendar, calendar2) / 360.0;
    }
}

