/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public abstract class BusinessdayCalendar
implements BusinessdayCalendarInterface {
    @Override
    public Calendar getAdjustedDate(Calendar calendar, BusinessdayCalendarInterface.DateRollConvention dateRollConvention) {
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.UNADJUSTED) {
            return (Calendar)calendar.clone();
        }
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.MODIFIED_FOLLOWING) {
            Calendar calendar2 = this.getAdjustedDate(calendar, BusinessdayCalendarInterface.DateRollConvention.FOLLOWING);
            if (calendar2.get(2) != calendar.get(2)) {
                return this.getAdjustedDate(calendar, BusinessdayCalendarInterface.DateRollConvention.PRECEDING);
            }
            return calendar2;
        }
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.MODIFIED_PRECEDING) {
            Calendar calendar3 = this.getAdjustedDate(calendar, BusinessdayCalendarInterface.DateRollConvention.PRECEDING);
            if (calendar3.get(2) != calendar.get(2)) {
                return this.getAdjustedDate(calendar, BusinessdayCalendarInterface.DateRollConvention.FOLLOWING);
            }
            return calendar3;
        }
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.FOLLOWING || dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.PRECEDING) {
            int n = dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.FOLLOWING ? 1 : -1;
            Calendar calendar4 = (Calendar)calendar.clone();
            while (!this.isBusinessday(calendar4)) {
                calendar4.add(6, n);
            }
            return calendar4;
        }
        throw new IllegalArgumentException("Unknown date roll convention.");
    }

    @Override
    public Calendar getAdjustedDate(Calendar calendar, String string, BusinessdayCalendarInterface.DateRollConvention dateRollConvention) {
        return this.getAdjustedDate(BusinessdayCalendar.createDateFromDateAndOffsetCode(calendar, string), dateRollConvention);
    }

    @Override
    public Calendar getRolledDate(Calendar calendar, int n) {
        BusinessdayCalendarInterface.DateRollConvention dateRollConvention;
        Calendar calendar2 = (Calendar)calendar.clone();
        int n2 = n >= 0 ? 1 : -1;
        BusinessdayCalendarInterface.DateRollConvention dateRollConvention2 = dateRollConvention = n2 > 0 ? BusinessdayCalendarInterface.DateRollConvention.FOLLOWING : BusinessdayCalendarInterface.DateRollConvention.PRECEDING;
        while (n != 0) {
            calendar2.add(6, n2);
            calendar2 = this.getAdjustedDate(calendar2, dateRollConvention);
            n -= n2;
        }
        return calendar2;
    }

    public Date getAdjustedDate(Date date, String string, BusinessdayCalendarInterface.DateRollConvention dateRollConvention) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return this.getAdjustedDate(BusinessdayCalendar.createDateFromDateAndOffsetCode(calendar, string), dateRollConvention).getTime();
    }

    public static Calendar createDateFromDateAndOffsetCode(Calendar calendar, String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Calendar calendar2 = (Calendar)calendar.clone();
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            char c = string2.toLowerCase().charAt(string2.length() - 1);
            switch (c) {
                case 'd': {
                    n = 6;
                    break;
                }
                case 'w': {
                    n = 3;
                    break;
                }
                case 'm': {
                    n = 2;
                    break;
                }
                case 'y': {
                    n = 1;
                    break;
                }
                default: {
                    n = 17;
                }
            }
            if (n != 17) {
                int n2 = Integer.valueOf(string2.substring(0, string2.length() - 1));
                calendar2.add(n, n2);
                continue;
            }
            double d = Double.valueOf(string2);
            calendar2.add(6, (int)Math.round(d * 365.0));
        }
        return calendar2;
    }
}

