/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarAny;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import net.finmath.time.daycount.DayCountConventionInterface;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_30E_360_ISDA;
import net.finmath.time.daycount.DayCountConvention_30U_360;
import net.finmath.time.daycount.DayCountConvention_ACT_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ISDA;

public class ScheduleGenerator {
    private ScheduleGenerator() {
    }

    public static ScheduleInterface createScheduleFromConventions(Calendar calendar, Calendar calendar2, Calendar calendar3, Frequency frequency, DaycountConvention daycountConvention, ShortPeriodConvention shortPeriodConvention, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, BusinessdayCalendarInterface businessdayCalendarInterface, int n, int n2) {
        ArrayList<Period> arrayList = new ArrayList<Period>();
        DayCountConventionInterface dayCountConventionInterface = null;
        switch (daycountConvention) {
            case E30_360_ISDA: {
                dayCountConventionInterface = new DayCountConvention_30E_360_ISDA();
                break;
            }
            case E30_360: {
                dayCountConventionInterface = new DayCountConvention_30E_360();
                break;
            }
            case U30_360: {
                dayCountConventionInterface = new DayCountConvention_30U_360();
                break;
            }
            case ACT_360: {
                dayCountConventionInterface = new DayCountConvention_ACT_360();
                break;
            }
            case ACT_365: {
                dayCountConventionInterface = new DayCountConvention_ACT_365();
                break;
            }
            default: {
                dayCountConventionInterface = new DayCountConvention_ACT_ACT_ISDA();
            }
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        switch (frequency) {
            case DAILY: {
                n3 = 1;
                break;
            }
            case WEEKLY: {
                n4 = 1;
                break;
            }
            case MONTHLY: {
                n5 = 1;
                break;
            }
            case QUARTERLY: {
                n5 = 3;
                break;
            }
            case SEMIANNUAL: {
                n5 = 6;
                break;
            }
            default: {
                n5 = 12;
                break;
            }
            case TENOR: {
                n5 = 100000;
            }
        }
        if (shortPeriodConvention == ShortPeriodConvention.LAST) {
            Calendar calendar4 = (Calendar)calendar2.clone();
            Calendar calendar5 = (Calendar)calendar2.clone();
            Calendar calendar6 = businessdayCalendarInterface.getAdjustedDate(calendar4, dateRollConvention);
            while (calendar4.before(calendar3)) {
                calendar5.add(6, n3);
                calendar5.add(3, n4);
                calendar5.add(2, n5);
                if (calendar5.after(calendar3)) {
                    calendar5 = (Calendar)calendar3.clone();
                    calendar4 = calendar3;
                }
                ScheduleGenerator.roundToSame(calendar5, calendar2, 11);
                Calendar calendar7 = businessdayCalendarInterface.getAdjustedDate(calendar5, dateRollConvention);
                ScheduleGenerator.roundToSame(calendar7, calendar2, 11);
                if (calendar6.compareTo(calendar7) == 0) continue;
                Calendar calendar8 = (Calendar)calendar6.clone();
                calendar8.add(6, n);
                calendar8 = businessdayCalendarInterface.getAdjustedDate(calendar8, dateRollConvention);
                Calendar calendar9 = (Calendar)calendar7.clone();
                calendar9.add(6, n2);
                calendar9 = businessdayCalendarInterface.getAdjustedDate(calendar9, dateRollConvention);
                arrayList.add(new Period(calendar8, calendar9, calendar6, calendar7));
                calendar6 = (Calendar)calendar7.clone();
                calendar4 = (Calendar)calendar5.clone();
            }
        } else {
            Calendar calendar10 = (Calendar)calendar3.clone();
            Calendar calendar11 = (Calendar)calendar3.clone();
            Calendar calendar12 = businessdayCalendarInterface.getAdjustedDate(calendar11, dateRollConvention);
            while (calendar11.after(calendar2)) {
                calendar10.add(6, -n3);
                calendar10.add(3, -n4);
                calendar10.add(2, -n5);
                if (calendar10.before(calendar2)) {
                    calendar10 = (Calendar)calendar2.clone();
                    calendar11 = calendar2;
                }
                ScheduleGenerator.roundToSame(calendar10, calendar3, 11);
                Calendar calendar13 = businessdayCalendarInterface.getAdjustedDate(calendar10, dateRollConvention);
                ScheduleGenerator.roundToSame(calendar13, calendar3, 11);
                if (calendar13.compareTo(calendar12) == 0) continue;
                Calendar calendar14 = (Calendar)calendar13.clone();
                calendar14 = businessdayCalendarInterface.getRolledDate(calendar14, n);
                Calendar calendar15 = (Calendar)calendar12.clone();
                calendar15 = businessdayCalendarInterface.getRolledDate(calendar15, n2);
                arrayList.add(0, new Period(calendar14, calendar15, calendar13, calendar12));
                calendar12 = (Calendar)calendar13.clone();
                calendar11 = (Calendar)calendar10.clone();
            }
        }
        return new Schedule(calendar, arrayList, dayCountConventionInterface);
    }

    public static ScheduleInterface createScheduleFromConventions(Date date, Date date2, Date date3, String string, String string2, String string3, String string4, BusinessdayCalendarInterface businessdayCalendarInterface, int n, int n2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = GregorianCalendar.getInstance();
        calendar2.setTime(date2);
        Calendar calendar3 = GregorianCalendar.getInstance();
        calendar3.setTime(date3);
        return ScheduleGenerator.createScheduleFromConventions(calendar, calendar2, calendar3, Frequency.valueOf(string.replace("/", "_").toUpperCase()), DaycountConvention.getEnum(string2), ShortPeriodConvention.valueOf(string3.replace("/", "_").toUpperCase()), BusinessdayCalendarInterface.DateRollConvention.getEnum(string4), businessdayCalendarInterface, n, n2);
    }

    public static ScheduleInterface createScheduleFromConventions(Date date, Date date2, int n, String string, String string2, String string3, String string4, String string5, String string6, BusinessdayCalendarInterface businessdayCalendarInterface, int n2, int n3) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = GregorianCalendar.getInstance();
        calendar2.setTime(date2);
        Calendar calendar3 = businessdayCalendarInterface.getRolledDate(calendar2, n);
        Calendar calendar4 = BusinessdayCalendar.createDateFromDateAndOffsetCode(calendar3, string);
        Calendar calendar5 = BusinessdayCalendar.createDateFromDateAndOffsetCode(calendar4, string2);
        return ScheduleGenerator.createScheduleFromConventions(calendar, calendar4, calendar5, Frequency.valueOf(string3.replace("/", "_").toUpperCase()), DaycountConvention.getEnum(string4), ShortPeriodConvention.valueOf(string5.replace("/", "_").toUpperCase()), BusinessdayCalendarInterface.DateRollConvention.getEnum(string6), businessdayCalendarInterface, n2, n3);
    }

    public static ScheduleInterface createScheduleFromConventions(Date date, int n, String string, String string2, String string3, String string4, String string5, String string6, BusinessdayCalendarInterface businessdayCalendarInterface, int n2, int n3) {
        return ScheduleGenerator.createScheduleFromConventions(date, date, n, string, string2, string3, string4, string5, string6, businessdayCalendarInterface, n2, n3);
    }

    public static ScheduleInterface createScheduleFromConventions(Date date, String string, String string2, String string3, String string4, String string5, String string6, BusinessdayCalendarInterface businessdayCalendarInterface, int n, int n2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = BusinessdayCalendar.createDateFromDateAndOffsetCode(calendar, string);
        Calendar calendar3 = BusinessdayCalendar.createDateFromDateAndOffsetCode(calendar2, string2);
        return ScheduleGenerator.createScheduleFromConventions(calendar, calendar2, calendar3, Frequency.valueOf(string3.replace("/", "_").toUpperCase()), DaycountConvention.getEnum(string4), ShortPeriodConvention.valueOf(string5.replace("/", "_").toUpperCase()), BusinessdayCalendarInterface.DateRollConvention.getEnum(string6), businessdayCalendarInterface, n, n2);
    }

    public static ScheduleInterface createScheduleFromConventions(Date date, Date date2, String string, double d, String string2, String string3, String string4, BusinessdayCalendarInterface businessdayCalendarInterface, int n, int n2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = GregorianCalendar.getInstance();
        calendar2.setTime(date2);
        Calendar calendar3 = ScheduleGenerator.createDateFromDateAndOffset(calendar2, d);
        return ScheduleGenerator.createScheduleFromConventions(calendar, calendar2, calendar3, Frequency.valueOf(string.toUpperCase()), DaycountConvention.getEnum(string2), ShortPeriodConvention.valueOf(string3.toUpperCase()), BusinessdayCalendarInterface.DateRollConvention.getEnum(string4), businessdayCalendarInterface, n, n2);
    }

    public static ScheduleInterface createScheduleFromConventions(Date date, Date date2, String string, double d, String string2, String string3) {
        return ScheduleGenerator.createScheduleFromConventions(date, date2, string, d, string2, string3, "UNADJUSTED", (BusinessdayCalendarInterface)new BusinessdayCalendarAny(), 0, 0);
    }

    private static Calendar createDateFromDateAndOffset(Calendar calendar, double d) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, (int)d);
        d = (d - (double)((int)d)) * 12.0;
        calendar2.add(2, (int)d);
        d = (d - (double)((int)d)) * 30.0;
        calendar2.add(6, (int)Math.round(d));
        ScheduleGenerator.roundToSame(calendar2, calendar, 11);
        return calendar2;
    }

    private static void roundToSame(Calendar calendar, Calendar calendar2, int n) {
        int n2 = calendar.get(n) - calendar2.get(n);
        int n3 = calendar.getActualMaximum(n) / 2;
        if (n2 > 0 && n2 <= n3 || n2 < 0 && n2 >= n3) {
            calendar.add(n, -Math.abs(n2));
        } else {
            calendar.add(n, Math.abs(n2));
        }
    }

    public static enum ShortPeriodConvention {
        FIRST,
        LAST;

    }

    public static enum DaycountConvention {
        E30_360_ISDA,
        E30_360,
        U30_360,
        ACT_360,
        ACT_365,
        ACT_ACT_ISDA,
        ACT_ACT;


        public static DaycountConvention getEnum(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (string.equalsIgnoreCase("30e/360 isda")) {
                return E30_360_ISDA;
            }
            if (string.equalsIgnoreCase("e30/360 isda")) {
                return E30_360_ISDA;
            }
            if (string.equalsIgnoreCase("30e/360")) {
                return E30_360;
            }
            if (string.equalsIgnoreCase("e30/360")) {
                return E30_360;
            }
            if (string.equalsIgnoreCase("30/360")) {
                return E30_360;
            }
            if (string.equalsIgnoreCase("30u/360")) {
                return U30_360;
            }
            if (string.equalsIgnoreCase("u30/360")) {
                return U30_360;
            }
            if (string.equalsIgnoreCase("act/360")) {
                return ACT_360;
            }
            if (string.equalsIgnoreCase("act/365")) {
                return ACT_365;
            }
            if (string.equalsIgnoreCase("act/act isda")) {
                return ACT_ACT_ISDA;
            }
            if (string.equalsIgnoreCase("act/act")) {
                return ACT_ACT;
            }
            return DaycountConvention.valueOf(string.toUpperCase());
        }
    }

    public static enum Frequency {
        DAILY,
        WEEKLY,
        MONTHLY,
        QUARTERLY,
        SEMIANNUAL,
        ANNUAL,
        TENOR;

    }
}

