/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo;

import java.text.DecimalFormat;
import net.finmath.functions.JarqueBeraTest;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import org.junit.Assert;
import org.junit.Test;

public class BrownianMotionTests {
    static final DecimalFormat formatterReal2 = new DecimalFormat(" 0.00");
    static final DecimalFormat formatterSci4 = new DecimalFormat(" 0.0000E00;-0.0000E00");
    static final DecimalFormat formatterSci1 = new DecimalFormat(" 0E00;-0.E00");

    @Test
    public void testScalarValuedBrownianMotionTerminalDistribution() {
        int n = 53252;
        double d = 1.0;
        double d2 = 1.0;
        System.out.println("Test of mean and variance of a single Brownian increment.");
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d / d2), d2);
        for (int i = 1000; i <= 100000000; i *= 10) {
            BrownianMotion brownianMotion = new BrownianMotion(timeDiscretization, 1, i, n);
            System.out.print("\tNumber of path = " + formatterSci1.format(i) + "\t ");
            RandomVariableInterface randomVariableInterface = brownianMotion.getBrownianIncrement(0, 0);
            double d3 = randomVariableInterface.getAverage();
            double d4 = randomVariableInterface.getVariance();
            System.out.print("error of mean = " + formatterSci4.format(d3) + "\t error of variance = " + formatterSci4.format(d4 - d2));
            Assert.assertTrue((Math.abs(d3) < 3.0 * Math.pow(d2, 0.5) / Math.pow(i, 0.5) ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(d4 - d2) < 3.0 * Math.pow(d2, 1.0) / Math.pow(i, 0.5) ? 1 : 0) != 0);
            System.out.println(" - OK");
        }
        System.out.println("");
    }

    @Test
    public void testScalarValuedBrownianMotionWithJarqueBeraTest() {
        int n = 100000;
        int n2 = 31415;
        double d = 60.0;
        double d2 = 0.25;
        System.out.println("Jarque-Bera test of subsequent Brownian increments.");
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d / d2), d2);
        BrownianMotion brownianMotion = new BrownianMotion(timeDiscretization, 1, n, n2);
        JarqueBeraTest jarqueBeraTest = new JarqueBeraTest();
        int n3 = 0;
        for (int i = 0; i < timeDiscretization.getNumberOfTimeSteps(); ++i) {
            RandomVariableInterface randomVariableInterface = brownianMotion.getBrownianIncrement(i, 0);
            double d3 = jarqueBeraTest.test(randomVariableInterface);
            System.out.print(i + ":\t" + d3);
            if (d3 > 4.6) {
                ++n3;
                System.out.println(" - fail");
                continue;
            }
            System.out.println(" - OK");
        }
        System.out.println(n3 + " out of " + timeDiscretization.getNumberOfTimeSteps() + " failed.");
        Assert.assertTrue((String)"Test on normal distribution.", (10.0 * (double)n3 < (double)timeDiscretization.getNumberOfTimeSteps() ? 1 : 0) != 0);
        System.out.println("");
    }

    @Test
    public void testBrownianIncrementSquaredDrift() {
        int n = 10000;
        int n2 = 53252;
        double d = 4.0;
        double d2 = 0.001;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d / d2), d2);
        BrownianMotion brownianMotion = new BrownianMotion(timeDiscretization, 2, n, n2);
        System.out.println("Test of average and variance of the integral of (Delta W)^2.");
        System.out.println("Time step size: " + d2 + "  Number of path: " + n);
        RandomVariableInterface randomVariableInterface = brownianMotion.getRandomVariableForConstant(0.0);
        RandomVariableInterface randomVariableInterface2 = brownianMotion.getRandomVariableForConstant(0.0);
        for (int i = 0; i < timeDiscretization.getNumberOfTimeSteps(); ++i) {
            RandomVariableInterface randomVariableInterface3 = brownianMotion.getBrownianIncrement(i, 0);
            RandomVariableInterface randomVariableInterface4 = brownianMotion.getBrownianIncrement(i, 1);
            RandomVariableInterface randomVariableInterface5 = randomVariableInterface3.squared();
            randomVariableInterface = randomVariableInterface.add(randomVariableInterface5);
            RandomVariableInterface randomVariableInterface6 = randomVariableInterface3.mult(randomVariableInterface4);
            randomVariableInterface2 = randomVariableInterface2.add(randomVariableInterface6);
        }
        double d3 = timeDiscretization.getTime(timeDiscretization.getNumberOfTimeSteps());
        double d4 = randomVariableInterface.getAverage();
        double d5 = randomVariableInterface.getVariance();
        double d6 = randomVariableInterface2.getAverage();
        double d7 = randomVariableInterface2.getVariance();
        Assert.assertTrue((Math.abs(d4 - d3) < 0.001 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(d5) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(d6) < 0.001 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(d7) < 0.01 ? 1 : 0) != 0);
        System.out.println("\t              t = " + formatterReal2.format(d3));
        System.out.println("\tint_0^t dW1 dW1 = " + formatterSci4.format(d4) + "\t (Monte-Carlo variance: " + formatterSci4.format(d5) + ")");
        System.out.println("\tint_0^t dW1 dW2 = " + formatterSci4.format(d6) + "\t (Monte-Carlo variance: " + formatterSci4.format(d7) + ")");
        System.out.println("");
    }
}

