/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.RootFinder;

public class RiddersMethod
implements RootFinder {
    private final double[] points = new double[3];
    private final double[] values = new double[3];
    private double nextPoint;
    private int solverState = 0;
    private int numberOfIterations = 0;
    private double bestPoint;
    private double accuracy = Double.MAX_VALUE;
    private boolean isDone = false;

    public static void main(String[] stringArray) {
        RiddersMethod riddersMethod = new RiddersMethod(-1.0, 5.0);
        while (riddersMethod.getAccuracy() > 1.0E-13 && !riddersMethod.isDone()) {
            double d = riddersMethod.getNextPoint();
            double d2 = d - 0.656;
            riddersMethod.setValue(d2);
            System.out.println(riddersMethod.getAccuracy());
        }
        System.out.println(riddersMethod.getNumberOfIterations() + " " + riddersMethod.getBestPoint());
    }

    public RiddersMethod(double d, double d2) {
        this.points[0] = d;
        this.points[2] = d2;
        this.points[1] = (this.points[0] + this.points[2]) / 2.0;
        this.nextPoint = this.points[0];
        this.bestPoint = this.points[1];
        this.accuracy = this.points[2] - this.points[0];
    }

    @Override
    public double getBestPoint() {
        return this.bestPoint;
    }

    @Override
    public double getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValue(double d) {
        switch (this.solverState) {
            default: {
                this.values[0] = d;
                this.nextPoint = this.points[2];
                ++this.solverState;
                break;
            }
            case 1: {
                this.values[2] = d;
                this.points[1] = 0.5 * (this.points[0] + this.points[2]);
                this.nextPoint = this.points[1];
                ++this.solverState;
                break;
            }
            case 2: {
                this.values[1] = d;
                double d2 = Math.sqrt(this.values[1] * this.values[1] - this.values[0] * this.values[2]);
                if (d2 == 0.0) {
                    this.isDone = true;
                }
                this.nextPoint = this.points[1] + (this.points[1] - this.points[0]) * (this.values[0] >= this.values[2] ? 1.0 : -1.0) * this.values[1] / d2;
                ++this.solverState;
                break;
            }
            case 3: {
                if (d == 0.0) {
                    this.isDone = true;
                }
                if (RiddersMethod.sign(this.values[1], d) != this.values[1]) {
                    this.points[0] = this.points[1];
                    this.values[0] = this.values[1];
                    this.points[2] = this.nextPoint;
                    this.values[2] = d;
                } else if (RiddersMethod.sign(this.values[0], d) != this.values[0]) {
                    this.points[2] = this.nextPoint;
                    this.values[2] = d;
                } else if (RiddersMethod.sign(this.values[2], d) != this.values[2]) {
                    this.points[0] = this.nextPoint;
                    this.values[0] = d;
                } else {
                    System.err.println(this.getClass().getName() + ": Error: Never get here.");
                    this.isDone = true;
                    return;
                }
                this.points[1] = 0.5 * (this.points[0] + this.points[2]);
                this.nextPoint = this.points[1];
                this.solverState = 2;
            }
        }
        this.accuracy = Math.abs(this.points[2] - this.points[0]);
        this.bestPoint = this.points[1];
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    private static final double sign(double d, double d2) {
        return d2 >= 0.0 ? (d >= 0.0 ? d : -d) : (d > 0.0 ? -d : d);
    }
}

