/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.OptimizerFactoryCMAES;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;
import org.junit.Assert;
import org.junit.Test;

public class OptimizerFactoryTest {
    @Test
    public void testRosenbrockFunctionWithCMAES() throws SolverException {
        OptimizerFactoryCMAES optimizerFactoryCMAES = new OptimizerFactoryCMAES(0.0, 200);
        this.testOptimizerWithRosenbrockFunction(optimizerFactoryCMAES);
    }

    @Test
    public void testRosenbrockFunctionWithLevenbergMarquard() throws SolverException {
        OptimizerFactoryLevenbergMarquardt optimizerFactoryLevenbergMarquardt = new OptimizerFactoryLevenbergMarquardt(200, 2);
        this.testOptimizerWithRosenbrockFunction(optimizerFactoryLevenbergMarquardt);
    }

    public void testOptimizerWithRosenbrockFunction(OptimizerFactoryInterface optimizerFactoryInterface) throws SolverException {
        OptimizerInterface.ObjectiveFunction objectiveFunction = new OptimizerInterface.ObjectiveFunction(){

            @Override
            public void setValues(double[] dArray, double[] dArray2) {
                dArray2[0] = 10.0 * (dArray[1] - dArray[0] * dArray[0]);
                dArray2[1] = 1.0 - dArray[0];
            }
        };
        OptimizerInterface optimizerInterface = optimizerFactoryInterface.getOptimizer(objectiveFunction, new double[]{0.5, 0.5}, new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY}, new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, new double[]{0.5, 0.5}, new double[]{0.0, 0.0});
        optimizerInterface.run();
        double[] dArray = optimizerInterface.getBestFitParameters();
        System.out.println("The solver " + optimizerInterface.getClass() + " for problem 'Rosebrock' required " + optimizerInterface.getIterations() + " iterations. Accuracy is " + optimizerInterface.getRootMeanSquaredError() + ". The best fit parameters are:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("\tparameter[" + i + "]: " + dArray[i]);
        }
        System.out.println();
        Assert.assertTrue((Math.abs(dArray[0] - 1.0) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dArray[1] - 1.0) < 1.0E-10 ? 1 : 0) != 0);
    }
}

