/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.templatemethoddesign.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.templatemethoddesign.LogNormalProcess;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloBlackScholesModel2
extends LogNormalProcess
implements AssetModelMonteCarloSimulationInterface {
    private double initialValue;
    private double riskFreeRate;
    private double volatility;
    private RandomVariableInterface[] initialValueVector = new RandomVariableInterface[1];
    private RandomVariableInterface drift;
    private RandomVariableInterface volatilityOnPaths;

    public MonteCarloBlackScholesModel2(TimeDiscretizationInterface timeDiscretizationInterface, int n, double d, double d2, double d3) {
        super(timeDiscretizationInterface, 1, 1, n, 3141);
        this.initialValue = d;
        this.riskFreeRate = d2;
        this.volatility = d3;
        this.initialValueVector[0] = new RandomVariable(0.0, d);
        this.drift = new RandomVariable(0.0, d2);
        this.volatilityOnPaths = new RandomVariable(0.0, d3);
    }

    public MonteCarloBlackScholesModel2(TimeDiscretizationInterface timeDiscretizationInterface, int n, double d, double d2, double d3, int n2) {
        super(timeDiscretizationInterface, 1, 1, n, n2);
        this.initialValue = d;
        this.riskFreeRate = d2;
        this.volatility = d3;
        this.initialValueVector[0] = new RandomVariable(0.0, d);
        this.drift = new RandomVariable(0.0, d2);
        this.volatilityOnPaths = new RandomVariable(0.0, d3);
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public RandomVariableInterface[] getInitialValue() {
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface getDrift(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        return this.drift;
    }

    @Override
    public RandomVariableInterface getFactorLoading(int n, int n2, int n3, RandomVariableInterface[] randomVariableInterfaceArray) {
        return this.volatilityOnPaths;
    }

    @Override
    public RandomVariableInterface getAssetValue(int n, int n2) {
        return this.getProcessValue(n, n2);
    }

    @Override
    public RandomVariableInterface getAssetValue(double d, int n) {
        return this.getAssetValue(this.getTimeIndex(d), n);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double d) {
        return this.getMonteCarloWeights(this.getTimeIndex(d));
    }

    @Override
    public RandomVariableInterface getNumeraire(int n) {
        double d = this.getTime(n);
        return this.getNumeraire(d);
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) {
        double d2 = Math.exp(this.riskFreeRate * d);
        return new RandomVariable(d, d2);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.getBrownianMotion().getRandomVariableForConstant(d);
    }

    public String toString() {
        return super.toString() + "\n" + "MonteCarloBlackScholesModelByInheritance:\n" + "  initial value...:" + this.initialValue + "\n" + "  risk free rate..:" + this.riskFreeRate + "\n" + "  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int n) {
        return new MonteCarloBlackScholesModel2(this.getTimeDiscretization(), this.getNumberOfPaths(), this.getInitialValue()[0].get(0), this.getRiskFreeRate(), this.getVolatility(), n);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }
}

