/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.process.ProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;
import org.apache.commons.math3.analysis.UnivariateFunction;

public class LinearInterpolatedTimeDiscreteProcess
implements ProcessInterface {
    private TimeDiscretizationInterface timeDiscretization;
    private Map<Double, RandomVariableInterface> realizations;

    public LinearInterpolatedTimeDiscreteProcess(Map<Double, RandomVariableInterface> map) {
        this.timeDiscretization = new TimeDiscretization(map.keySet());
        this.realizations = new HashMap<Double, RandomVariableInterface>();
        this.realizations.putAll(map);
    }

    private LinearInterpolatedTimeDiscreteProcess(TimeDiscretizationInterface timeDiscretizationInterface, Map<Double, RandomVariableInterface> map) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.realizations = map;
    }

    public LinearInterpolatedTimeDiscreteProcess add(LinearInterpolatedTimeDiscreteProcess linearInterpolatedTimeDiscreteProcess) throws CalculationException {
        HashMap<Double, RandomVariableInterface> hashMap = new HashMap<Double, RandomVariableInterface>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            hashMap.put(d, this.realizations.get(d).add(linearInterpolatedTimeDiscreteProcess.getProcessValue(d, 0)));
        }
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, hashMap);
    }

    public LinearInterpolatedTimeDiscreteProcess apply(UnivariateFunction univariateFunction) {
        HashMap<Double, RandomVariableInterface> hashMap = new HashMap<Double, RandomVariableInterface>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            hashMap.put(d, this.realizations.get(d).apply(univariateFunction));
        }
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, hashMap);
    }

    public RandomVariableInterface getProcessValue(double d, int n) throws CalculationException {
        double d2;
        double d3 = this.timeDiscretization.getTimeIndexNearestLessOrEqual(d);
        if (d3 == (d2 = (double)this.timeDiscretization.getTimeIndexNearestGreaterOrEqual(d))) {
            return this.realizations.get(d3);
        }
        RandomVariableInterface randomVariableInterface = this.realizations.get(d3);
        RandomVariableInterface randomVariableInterface2 = this.realizations.get(d2);
        return randomVariableInterface2.mult((d - d3) / (d2 - d3)).add(randomVariableInterface.mult((d2 - d) / (d2 - d3)));
    }

    @Override
    public RandomVariableInterface getProcessValue(int n, int n2) throws CalculationException {
        return this.realizations.get(this.timeDiscretization.getTime(n));
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int n) throws CalculationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public double getTime(int n) {
        return this.timeDiscretization.getTime(n);
    }

    @Override
    public int getTimeIndex(double d) {
        return this.timeDiscretization.getTimeIndex(d);
    }

    @Override
    public ProcessInterface clone() {
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, this.realizations);
    }
}

