/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractProcess
implements AbstractProcessInterface,
Cloneable {
    private AbstractModelInterface model;
    private TimeDiscretizationInterface timeDiscretization;

    public AbstractProcess(TimeDiscretizationInterface timeDiscretizationInterface) {
        this.timeDiscretization = timeDiscretizationInterface;
    }

    public abstract Object getCloneWithModifiedSeed(int var1);

    public void setModel(AbstractModelInterface abstractModelInterface) {
        if (this.model != null) {
            throw new RuntimeException("Attemp to reuse process with a different model. This process is already associated with a model.");
        }
        this.model = abstractModelInterface;
    }

    @Override
    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    public RandomVariableInterface[] getInitialState() {
        return this.model.getInitialState();
    }

    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        return this.model.getDrift(n, randomVariableInterfaceArray, randomVariableInterfaceArray2);
    }

    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        return this.model.getFactorLoading(n, n2, randomVariableInterfaceArray);
    }

    public RandomVariableInterface applyStateSpaceTransform(int n, RandomVariableInterface randomVariableInterface) {
        return this.model.applyStateSpaceTransform(n, randomVariableInterface);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public double getTime(int n) {
        if (n >= this.timeDiscretization.getNumberOfTimes()) {
            throw new ArrayIndexOutOfBoundsException("Index for process time discretization out of bounds.");
        }
        return this.timeDiscretization.getTime(n);
    }

    @Override
    public int getTimeIndex(double d) {
        return this.timeDiscretization.getTimeIndex(d);
    }

    @Override
    public abstract AbstractProcess clone();
}

