/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public abstract class AbstractPeriod
extends AbstractProductComponent {
    private static final long serialVersionUID = 8035860121112226049L;
    private final double periodStart;
    private final double periodEnd;
    private final double fixingDate;
    private final double paymentDate;
    private final AbstractNotional notional;
    private final AbstractProductComponent index;
    private final double daycountFraction;

    @Override
    public abstract RandomVariableInterface getValue(double var1, LIBORModelMonteCarloSimulationInterface var3) throws CalculationException;

    public abstract RandomVariableInterface getCoupon(LIBORModelMonteCarloSimulationInterface var1) throws CalculationException;

    public AbstractPeriod(double d, double d2, double d3, double d4, AbstractNotional abstractNotional, AbstractProductComponent abstractProductComponent, double d5) {
        this.periodStart = d;
        this.periodEnd = d2;
        this.fixingDate = d3;
        this.paymentDate = d4;
        this.notional = abstractNotional;
        this.index = abstractProductComponent;
        this.daycountFraction = d5;
    }

    public AbstractPeriod(double d, double d2, double d3, double d4, AbstractNotional abstractNotional, AbstractProductComponent abstractProductComponent) {
        this(d, d2, d3, d4, abstractNotional, abstractProductComponent, d2 - d);
    }

    @Override
    public String getCurrency() {
        return this.notional.getCurrency();
    }

    public double getPeriodStart() {
        return this.periodStart;
    }

    public double getPeriodEnd() {
        return this.periodEnd;
    }

    public double getFixingDate() {
        return this.fixingDate;
    }

    public double getPaymentDate() {
        return this.paymentDate;
    }

    public AbstractNotional getNotional() {
        return this.notional;
    }

    public AbstractProductComponent getIndex() {
        return this.index;
    }

    public double getDaycountFraction() {
        return this.daycountFraction;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.getIndex().queryUnderlyings();
    }

    @Override
    public String toString() {
        return "AbstractPeriod [periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", fixingDate=" + this.fixingDate + ", paymentDate=" + this.paymentDate + ", notional=" + this.notional + ", index=" + this.index + ", daycountFraction=" + this.daycountFraction + "]";
    }
}

