/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.Period;
import net.finmath.montecarlo.interestrate.products.components.ProductCollection;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.FixedCoupon;
import net.finmath.montecarlo.interestrate.products.indices.LinearCombinationIndex;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.ScheduleInterface;

public class SwapLeg
extends AbstractLIBORMonteCarloProduct {
    private final ScheduleInterface legSchedule;
    private final AbstractNotional notional;
    private final AbstractIndex index;
    private final double spread;
    private boolean isNotionalExchanged;
    private final ProductCollection components;

    public SwapLeg(ScheduleInterface scheduleInterface, AbstractNotional abstractNotional, AbstractIndex abstractIndex, double d, boolean bl) {
        this.legSchedule = scheduleInterface;
        this.notional = abstractNotional;
        this.index = abstractIndex;
        this.spread = d;
        this.isNotionalExchanged = bl;
        ArrayList<AbstractProductComponent> arrayList = new ArrayList<AbstractProductComponent>();
        for (int i = 0; i < scheduleInterface.getNumberOfPeriods(); ++i) {
            double d2 = scheduleInterface.getFixing(i);
            double d3 = scheduleInterface.getPayment(i);
            double d4 = scheduleInterface.getPeriodLength(i);
            if (d4 == 0.0) continue;
            AbstractIndex abstractIndex2 = abstractIndex != null ? (d != 0.0 ? new LinearCombinationIndex(1.0, abstractIndex, 1.0, new FixedCoupon(d)) : abstractIndex) : new FixedCoupon(d);
            Period period = new Period(d2, d3, d2, d3, abstractNotional, abstractIndex2, d4, true, bl, false);
            arrayList.add(period);
        }
        this.components = new ProductCollection(arrayList);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        return this.components.getValue(d, lIBORModelMonteCarloSimulationInterface);
    }
}

