/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class CMSOption
extends AbstractLIBORMonteCarloProduct {
    private final double exerciseDate;
    private final double[] fixingDates;
    private double[] paymentDates;
    private double[] periodLengths;
    private double strike;

    public CMSOption(double d, double[] dArray, double[] dArray2, double[] dArray3, double d2) {
        this.exerciseDate = d;
        this.fixingDates = dArray;
        this.paymentDates = dArray2;
        this.periodLengths = dArray3;
        this.strike = d2;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = new RandomVariable(this.fixingDates[this.fixingDates.length - 1], 0.0);
        RandomVariableInterface randomVariableInterface2 = new RandomVariable(this.paymentDates[this.paymentDates.length - 1], -1.0);
        for (int i = this.fixingDates.length - 1; i >= 0; --i) {
            double d2 = this.fixingDates[i];
            double d3 = this.paymentDates[i];
            double d4 = this.periodLengths != null ? this.periodLengths[i] : d3 - d2;
            RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getLIBOR(this.exerciseDate, d2, d3);
            RandomVariable randomVariable = new RandomVariable(d3, 1.0 * d4);
            randomVariableInterface = randomVariableInterface.add(randomVariable);
            randomVariableInterface2 = randomVariableInterface2.discount(randomVariableInterface3, d4);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface3, d4);
        }
        randomVariableInterface2 = randomVariableInterface2.add(1.0);
        RandomVariableInterface randomVariableInterface4 = randomVariableInterface2.div(randomVariableInterface);
        RandomVariableInterface randomVariableInterface5 = new RandomVariable(this.paymentDates[0], this.periodLengths[0]);
        randomVariableInterface5 = randomVariableInterface5.discount(lIBORModelMonteCarloSimulationInterface.getLIBOR(this.exerciseDate, this.fixingDates[0], this.paymentDates[0]), this.paymentDates[0] - this.fixingDates[0]);
        RandomVariableInterface randomVariableInterface6 = randomVariableInterface4.sub(this.strike).floor(0.0).mult(randomVariableInterface5);
        if (this.fixingDates[0] != this.exerciseDate) {
            RandomVariableInterface randomVariableInterface7 = lIBORModelMonteCarloSimulationInterface.getLIBOR(this.exerciseDate, this.exerciseDate, this.fixingDates[0]);
            double d5 = this.fixingDates[0] - this.exerciseDate;
            randomVariableInterface6 = randomVariableInterface6.discount(randomVariableInterface7, d5);
        }
        RandomVariableInterface randomVariableInterface8 = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.exerciseDate);
        RandomVariableInterface randomVariableInterface9 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(lIBORModelMonteCarloSimulationInterface.getTimeIndex(this.exerciseDate));
        randomVariableInterface6 = randomVariableInterface6.div(randomVariableInterface8).mult(randomVariableInterface9);
        RandomVariableInterface randomVariableInterface10 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface11 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface6 = randomVariableInterface6.mult(randomVariableInterface10).div(randomVariableInterface11);
        return randomVariableInterface6;
    }

    public double getValue(ForwardCurveInterface forwardCurveInterface, double d) {
        double[] dArray = new double[this.fixingDates.length + 1];
        System.arraycopy(this.fixingDates, 0, dArray, 0, this.fixingDates.length);
        dArray[dArray.length - 1] = this.paymentDates[this.paymentDates.length - 1];
        TimeDiscretization timeDiscretization = new TimeDiscretization(dArray);
        TimeDiscretization timeDiscretization2 = new TimeDiscretization(dArray);
        double d2 = Swap.getForwardSwapRate(timeDiscretization, timeDiscretization2, forwardCurveInterface);
        double d3 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)timeDiscretization, forwardCurveInterface);
        double d4 = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(dArray[0], dArray[1]), forwardCurveInterface) / (dArray[1] - dArray[0]);
        return AnalyticFormulas.huntKennedyCMSOptionValue(d2, d, d3, this.exerciseDate, dArray[dArray.length - 1] - dArray[0], d4, this.strike) * (dArray[1] - dArray[0]);
    }
}

