/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectation;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class BermudanSwaption
extends AbstractLIBORMonteCarloProduct {
    private final boolean[] isPeriodStartDateExerciseDate;
    private final double[] fixingDates;
    private final double[] periodLengths;
    private final double[] paymentDates;
    private final double[] periodNotionals;
    private final double[] swaprates;

    public BermudanSwaption(boolean[] blArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.isPeriodStartDateExerciseDate = blArray;
        this.fixingDates = dArray;
        this.periodLengths = dArray2;
        this.paymentDates = dArray3;
        this.periodNotionals = dArray4;
        this.swaprates = dArray5;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = new RandomVariable(this.fixingDates[this.fixingDates.length - 1], 0.0);
        RandomVariableInterface randomVariableInterface2 = new RandomVariable(this.fixingDates[this.fixingDates.length - 1], 0.0);
        for (int i = this.fixingDates.length - 1; i >= 0; --i) {
            double d2 = this.fixingDates[i];
            double d3 = this.periodLengths[i];
            double d4 = this.paymentDates[i];
            double d5 = this.periodNotionals[i];
            double d6 = this.swaprates[i];
            RandomVariableInterface randomVariableInterface3 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d2, d2, d2 + d3);
            RandomVariableInterface randomVariableInterface4 = randomVariableInterface3.sub(d6).mult(d3).mult(d5);
            RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d4);
            RandomVariableInterface randomVariableInterface6 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d4);
            randomVariableInterface4 = randomVariableInterface4.div(randomVariableInterface5).mult(randomVariableInterface6);
            randomVariableInterface2 = randomVariableInterface2.add(randomVariableInterface4);
            if (!this.isPeriodStartDateExerciseDate[i]) continue;
            RandomVariableInterface randomVariableInterface7 = randomVariableInterface.sub(randomVariableInterface2);
            MonteCarloConditionalExpectation monteCarloConditionalExpectation = this.getConditionalExpectationEstimator(i, lIBORModelMonteCarloSimulationInterface);
            RandomVariableInterface randomVariableInterface8 = monteCarloConditionalExpectation.getConditionalExpectation(randomVariableInterface7);
            randomVariableInterface = randomVariableInterface.barrier(randomVariableInterface8, randomVariableInterface, randomVariableInterface2);
        }
        RandomVariableInterface randomVariableInterface9 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface10 = lIBORModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface = randomVariableInterface.mult(randomVariableInterface9).div(randomVariableInterface10);
        return randomVariableInterface;
    }

    private MonteCarloConditionalExpectation getConditionalExpectationEstimator(int n, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        MonteCarloConditionalExpectationRegression monteCarloConditionalExpectationRegression = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(n, lIBORModelMonteCarloSimulationInterface));
        return monteCarloConditionalExpectationRegression;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(int n, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d = this.fixingDates[n];
        ArrayList<RandomVariable> arrayList = new ArrayList<RandomVariable>();
        RandomVariableInterface randomVariableInterface = new RandomVariable(d, 1.0);
        arrayList.add((RandomVariable)randomVariableInterface);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, this.fixingDates[0], this.paymentDates[this.paymentDates.length - 1]);
        double d2 = this.paymentDates[this.paymentDates.length - 1] - this.fixingDates[0];
        randomVariableInterface = ((RandomVariableInterface)arrayList.get(0)).discount(randomVariableInterface2, d2);
        arrayList.add((RandomVariable)randomVariableInterface);
        randomVariableInterface = ((RandomVariableInterface)arrayList.get(1)).discount(randomVariableInterface2, d2);
        arrayList.add((RandomVariable)randomVariableInterface);
        return arrayList.toArray(new RandomVariableInterface[arrayList.size()]);
    }
}

