/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.Arrays;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelMaturityDependentFourParameterExponentialForm
extends LIBORVolatilityModel {
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double d, double d2, double d3, double d4) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.a = new double[timeDiscretizationInterface2.getNumberOfTimeSteps()];
        Arrays.fill(this.a, d);
        this.b = new double[timeDiscretizationInterface2.getNumberOfTimeSteps()];
        Arrays.fill(this.b, d2);
        this.c = new double[timeDiscretizationInterface2.getNumberOfTimeSteps()];
        Arrays.fill(this.c, d3);
        this.d = new double[timeDiscretizationInterface2.getNumberOfTimeSteps()];
        Arrays.fill(this.d, d4);
    }

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.a = dArray;
        this.b = dArray2;
        this.c = dArray3;
        this.d = dArray4;
    }

    @Override
    public double[] getParameter() {
        double[] dArray = new double[]{this.a[0], this.b[0], this.c[0], this.d[0]};
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        Arrays.fill(this.a, dArray[0]);
        Arrays.fill(this.b, dArray[1]);
        Arrays.fill(this.c, dArray[2]);
        Arrays.fill(this.d, dArray[3]);
    }

    @Override
    public RandomVariableInterface getVolatility(int n, int n2) {
        double d = this.getTimeDiscretization().getTime(n);
        double d2 = this.getLiborPeriodDiscretization().getTime(n2);
        double d3 = d2 - d;
        double d4 = d3 <= 0.0 ? 0.0 : (this.a[n2] + this.b[n2] * d3) * Math.exp(-this.c[n2] * d3) + this.d[n2];
        if (d4 < 0.0) {
            d4 = Math.max(d4, 0.0);
        }
        return new RandomVariable(this.getTimeDiscretization().getTime(n), d4);
    }

    public void setParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.a = dArray;
        this.b = dArray2;
        this.c = dArray3;
        this.d = dArray4;
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d);
    }
}

