/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.ArrayList;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelFromGivenMatrix
extends LIBORVolatilityModel {
    private final double[][] volatility;
    private transient double[] parameter = null;

    public LIBORVolatilityModelFromGivenMatrix(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double[][] dArray) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.volatility = dArray;
    }

    @Override
    public RandomVariableInterface getVolatility(int n, int n2) {
        return new RandomVariable(this.getTimeDiscretization().getTime(n), this.volatility[n][n2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getParameter() {
        LIBORVolatilityModelFromGivenMatrix lIBORVolatilityModelFromGivenMatrix = this;
        synchronized (lIBORVolatilityModelFromGivenMatrix) {
            if (this.parameter == null) {
                int n;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (n = 0; n < this.getTimeDiscretization().getNumberOfTimeSteps(); ++n) {
                    for (int i = 0; i < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++i) {
                        if (!(this.getTimeDiscretization().getTime(n) < this.getLiborPeriodDiscretization().getTime(i))) continue;
                        arrayList.add(this.volatility[n][i]);
                    }
                }
                this.parameter = new double[arrayList.size()];
                for (n = 0; n < this.parameter.length; ++n) {
                    this.parameter[n] = (Double)arrayList.get(n);
                }
            }
        }
        return this.parameter;
    }

    @Override
    public void setParameter(double[] dArray) {
        this.parameter = null;
        int n = 0;
        for (int i = 0; i < this.getTimeDiscretization().getNumberOfTimeSteps(); ++i) {
            for (int j = 0; j < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++j) {
                if (!(this.getTimeDiscretization().getTime(i) < this.getLiborPeriodDiscretization().getTime(j))) continue;
                this.volatility[i][j] = Math.max(dArray[n++], 0.0);
            }
        }
    }

    @Override
    public Object clone() {
        double[][] dArray = (double[][])this.volatility.clone();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double[])dArray[i].clone();
        }
        return new LIBORVolatilityModelFromGivenMatrix(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), dArray);
    }
}

