/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.Arrays;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCovarianceModelFromVolatilityAndCorrelation
extends AbstractLIBORCovarianceModelParametric {
    private final LIBORVolatilityModel volatilityModel;
    private final LIBORCorrelationModel correlationModel;

    public LIBORCovarianceModelFromVolatilityAndCorrelation(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, LIBORVolatilityModel lIBORVolatilityModel, LIBORCorrelationModel lIBORCorrelationModel) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2, lIBORCorrelationModel.getNumberOfFactors());
        this.volatilityModel = lIBORVolatilityModel;
        this.correlationModel = lIBORCorrelationModel;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[this.correlationModel.getNumberOfFactors()];
        RandomVariableInterface randomVariableInterface = this.volatilityModel.getVolatility(n, n2);
        for (int i = 0; i < randomVariableInterfaceArray2.length; ++i) {
            randomVariableInterfaceArray2[i] = randomVariableInterface.mult(this.correlationModel.getFactorLoading(n, i, n2));
        }
        return randomVariableInterfaceArray2;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int n, int n2, int n3, RandomVariableInterface[] randomVariableInterfaceArray) {
        RandomVariableInterface randomVariableInterface = this.volatilityModel.getVolatility(n, n2).invert().mult(this.correlationModel.getFactorLoading(n, n3, n2));
        int n4 = this.getLiborPeriodDiscretization().getNumberOfTimeSteps();
        double d = 0.0;
        for (int i = 0; i < n4; ++i) {
            double d2 = this.correlationModel.getFactorLoading(n, n3, i);
            d += d2 * d2;
        }
        randomVariableInterface = randomVariableInterface.mult(1.0 / d);
        return randomVariableInterface;
    }

    @Override
    public RandomVariableInterface getCovariance(int n, int n2, int n3, RandomVariableInterface[] randomVariableInterfaceArray) {
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0, this.correlationModel.getCorrelation(n, n2, n3));
        randomVariableInterface = randomVariableInterface.mult(this.volatilityModel.getVolatility(n, n2)).mult(this.volatilityModel.getVolatility(n, n3));
        return randomVariableInterface;
    }

    @Override
    public double[] getParameter() {
        double[] dArray = this.volatilityModel.getParameter();
        double[] dArray2 = this.correlationModel.getParameter();
        int n = 0;
        n += dArray != null ? dArray.length : 0;
        double[] dArray3 = new double[n += dArray2 != null ? dArray2.length : 0];
        int n2 = 0;
        if (dArray != null) {
            System.arraycopy(dArray, 0, dArray3, n2, dArray.length);
            n2 += dArray.length;
        }
        if (dArray2 != null) {
            System.arraycopy(dArray2, 0, dArray3, n2, dArray2.length);
            n2 += dArray2.length;
        }
        return dArray3;
    }

    @Override
    public void setParameter(double[] dArray) {
        double[] dArray2;
        double[] dArray3 = this.volatilityModel.getParameter();
        double[] dArray4 = this.correlationModel.getParameter();
        int n = 0;
        if (dArray3 != null) {
            dArray2 = new double[dArray3.length];
            System.arraycopy(dArray, n, dArray2, 0, dArray2.length);
            n += dArray2.length;
            if (!Arrays.equals(dArray2, this.volatilityModel.getParameter())) {
                this.volatilityModel.setParameter(dArray2);
            }
        }
        if (dArray4 != null) {
            dArray2 = new double[dArray4.length];
            System.arraycopy(dArray, n, dArray2, 0, dArray2.length);
            n += dArray2.length;
            if (!Arrays.equals(dArray2, this.correlationModel.getParameter())) {
                this.correlationModel.setParameter(dArray2);
            }
        }
    }

    @Override
    public Object clone() {
        return new LIBORCovarianceModelFromVolatilityAndCorrelation(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), (LIBORVolatilityModel)this.volatilityModel.clone(), (LIBORCorrelationModel)this.correlationModel.clone());
    }

    public LIBORVolatilityModel getVolatilityModel() {
        return this.volatilityModel;
    }

    public LIBORCorrelationModel getCorrelationModel() {
        return this.correlationModel;
    }
}

