/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractLIBORCovarianceModel {
    private TimeDiscretizationInterface timeDiscretization;
    private TimeDiscretizationInterface liborPeriodDiscretization;
    private int numberOfFactors;

    public AbstractLIBORCovarianceModel(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, int n) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.liborPeriodDiscretization = timeDiscretizationInterface2;
        this.numberOfFactors = n;
    }

    public RandomVariableInterface[] getFactorLoading(double d, double d2, RandomVariableInterface[] randomVariableInterfaceArray) {
        int n = this.liborPeriodDiscretization.getTimeIndex(d2);
        if (n < 0) {
            n = -n - 2;
        }
        return this.getFactorLoading(d, n, randomVariableInterfaceArray);
    }

    public RandomVariableInterface[] getFactorLoading(double d, int n, RandomVariableInterface[] randomVariableInterfaceArray) {
        int n2 = this.timeDiscretization.getTimeIndex(d);
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return this.getFactorLoading(n2, n, randomVariableInterfaceArray);
    }

    public abstract RandomVariableInterface[] getFactorLoading(int var1, int var2, RandomVariableInterface[] var3);

    public abstract RandomVariableInterface getFactorLoadingPseudoInverse(int var1, int var2, int var3, RandomVariableInterface[] var4);

    public RandomVariableInterface getCovariance(double d, int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        int n3 = this.timeDiscretization.getTimeIndex(d);
        if (n3 < 0) {
            n3 = Math.abs(n3) - 2;
        }
        return this.getCovariance(n3, n, n2, randomVariableInterfaceArray);
    }

    public RandomVariableInterface getCovariance(int n, int n2, int n3, RandomVariableInterface[] randomVariableInterfaceArray) {
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0, 0.0);
        RandomVariableInterface[] randomVariableInterfaceArray2 = this.getFactorLoading(n, n2, randomVariableInterfaceArray);
        RandomVariableInterface[] randomVariableInterfaceArray3 = this.getFactorLoading(n, n3, randomVariableInterfaceArray);
        for (int i = 0; i < this.getNumberOfFactors(); ++i) {
            randomVariableInterface = randomVariableInterface.addProduct(randomVariableInterfaceArray2[i], randomVariableInterfaceArray3[i]);
        }
        return randomVariableInterface;
    }

    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }
}

