/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractSwaptionMarketData;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORMarketModel
extends AbstractModel
implements LIBORMarketModelInterface {
    private final TimeDiscretizationInterface liborPeriodDiscretization;
    private String forwardCurveName;
    private AnalyticModelInterface curveModel;
    private ForwardCurveInterface forwardRateCurve;
    private DiscountCurveInterface discountCurve;
    private AbstractLIBORCovarianceModel covarianceModel;
    private AbstractSwaptionMarketData swaptionMarketData;
    private Driftapproximation driftApproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;
    private StateSpace stateSpace = StateSpace.LOGNORMAL;
    private double liborCap = 100000.0;
    private double[][][] integratedLIBORCovariance;
    private final Object integratedLIBORCovarianceLazyInitLock = new Object();

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, AnalyticModelInterface analyticModelInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, CalibrationItem[] calibrationItemArray, Map<String, ?> map) throws CalculationException {
        if (map != null && map.containsKey("measure")) {
            this.measure = Measure.valueOf(((String)map.get("measure")).toUpperCase());
        }
        if (map != null && map.containsKey("stateSpace")) {
            this.stateSpace = StateSpace.valueOf(((String)map.get("stateSpace")).toUpperCase());
        }
        if (map != null && map.containsKey("liborCap")) {
            this.liborCap = (Double)map.get("liborCap");
        }
        Map map2 = null;
        if (map != null && map.containsKey("calibrationParameters")) {
            map2 = (Map)map.get("calibrationParameters");
        }
        this.liborPeriodDiscretization = timeDiscretizationInterface;
        this.curveModel = analyticModelInterface;
        this.forwardRateCurve = forwardCurveInterface;
        this.discountCurve = discountCurveInterface;
        this.covarianceModel = abstractLIBORCovarianceModel;
        double[] dArray = new double[timeDiscretizationInterface.getNumberOfTimeSteps()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = timeDiscretizationInterface.getTime(i);
        }
        if (calibrationItemArray != null && calibrationItemArray.length > 0) {
            AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric = null;
            try {
                abstractLIBORCovarianceModelParametric = (AbstractLIBORCovarianceModelParametric)abstractLIBORCovarianceModel;
            }
            catch (Exception exception) {
                throw new ClassCastException("Calibration is currently restricted to parametric covariance models (AbstractLIBORCovarianceModelParametric).");
            }
            AbstractLIBORMonteCarloProduct[] abstractLIBORMonteCarloProductArray = new AbstractLIBORMonteCarloProduct[calibrationItemArray.length];
            double[] dArray2 = new double[calibrationItemArray.length];
            double[] dArray3 = new double[calibrationItemArray.length];
            for (int i = 0; i < dArray2.length; ++i) {
                abstractLIBORMonteCarloProductArray[i] = calibrationItemArray[i].calibrationProduct;
                dArray2[i] = calibrationItemArray[i].calibrationTargetValue;
                dArray3[i] = calibrationItemArray[i].calibrationWeight;
            }
            this.covarianceModel = abstractLIBORCovarianceModelParametric.getCloneCalibrated(this, abstractLIBORMonteCarloProductArray, dArray2, dArray3, map2);
        }
    }

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, null, abstractLIBORCovarianceModel, new CalibrationItem[0], null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, discountCurveInterface, abstractLIBORCovarianceModel, new CalibrationItem[0], null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, AbstractSwaptionMarketData abstractSwaptionMarketData) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, null, abstractLIBORCovarianceModel, abstractSwaptionMarketData, null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, AbstractSwaptionMarketData abstractSwaptionMarketData) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, discountCurveInterface, abstractLIBORCovarianceModel, abstractSwaptionMarketData, null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, AbstractSwaptionMarketData abstractSwaptionMarketData, Map<String, ?> map) throws CalculationException {
        this(timeDiscretizationInterface, forwardCurveInterface, discountCurveInterface, abstractLIBORCovarianceModel, LIBORMarketModel.getCalibrationItems(timeDiscretizationInterface, forwardCurveInterface, abstractSwaptionMarketData, (map == null || map.get("stateSpace") == null || ((String)map.get("stateSpace")).toUpperCase().equals(StateSpace.LOGNORMAL.name())) && AbstractLIBORCovarianceModelParametric.class.isAssignableFrom(abstractLIBORCovarianceModel.getClass())), map);
    }

    public LIBORMarketModel(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface, AbstractLIBORCovarianceModel abstractLIBORCovarianceModel, CalibrationItem[] calibrationItemArray, Map<String, ?> map) throws CalculationException {
        this(timeDiscretizationInterface, null, forwardCurveInterface, discountCurveInterface, abstractLIBORCovarianceModel, calibrationItemArray, map);
    }

    private static CalibrationItem[] getCalibrationItems(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface, AbstractSwaptionMarketData abstractSwaptionMarketData, boolean bl) {
        if (abstractSwaptionMarketData == null) {
            return null;
        }
        TimeDiscretizationInterface timeDiscretizationInterface2 = abstractSwaptionMarketData.getOptionMaturities();
        TimeDiscretizationInterface timeDiscretizationInterface3 = abstractSwaptionMarketData.getTenor();
        double d = abstractSwaptionMarketData.getSwapPeriodLength();
        ArrayList<CalibrationItem> arrayList = new ArrayList<CalibrationItem>();
        for (int i = 0; i <= timeDiscretizationInterface2.getNumberOfTimeSteps(); ++i) {
            for (int j = 0; j <= timeDiscretizationInterface3.getNumberOfTimeSteps() - i; ++j) {
                double d2;
                AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct;
                double d3 = timeDiscretizationInterface2.getTime(i);
                double d4 = timeDiscretizationInterface3.getTime(j);
                if (timeDiscretizationInterface.getTimeIndex(d3) < 0 || timeDiscretizationInterface.getTimeIndex(d3 + d4) <= timeDiscretizationInterface.getTimeIndex(d3)) continue;
                int n = (int)(d4 / d);
                double[] dArray = new double[n];
                double[] dArray2 = new double[n];
                double[] dArray3 = new double[n + 1];
                for (int k = 0; k < n; ++k) {
                    dArray[k] = d3 + (double)k * d;
                    dArray2[k] = d3 + (double)(k + 1) * d;
                    dArray3[k] = d3 + (double)k * d;
                }
                dArray3[n] = d3 + (double)n * d;
                RegularSchedule regularSchedule = new RegularSchedule(new TimeDiscretization(dArray3));
                double d5 = Swap.getForwardSwapRate(regularSchedule, regularSchedule, forwardCurveInterface, null);
                double[] dArray4 = new double[n];
                for (int k = 0; k < n; ++k) {
                    dArray4[k] = d5;
                }
                if (bl) {
                    abstractLIBORMonteCarloProduct = new SwaptionAnalyticApproximation(d5, dArray3, SwaptionAnalyticApproximation.ValueUnit.VOLATILITY);
                    d2 = abstractSwaptionMarketData.getVolatility(d3, d4, abstractSwaptionMarketData.getSwapPeriodLength(), d5);
                    arrayList.add(new CalibrationItem(abstractLIBORMonteCarloProduct, d2, 1.0));
                    continue;
                }
                abstractLIBORMonteCarloProduct = new SwaptionSimple(d5, dArray3, SwaptionSimple.ValueUnit.VALUE);
                d2 = Swap.getForwardSwapRate(regularSchedule, regularSchedule, forwardCurveInterface);
                double d6 = SwapAnnuity.getSwapAnnuity((ScheduleInterface)regularSchedule, forwardCurveInterface);
                double d7 = abstractSwaptionMarketData.getVolatility(d3, d4, abstractSwaptionMarketData.getSwapPeriodLength(), d5);
                double d8 = AnalyticFormulas.blackModelSwaptionValue(d2, d7, d3, d5, d6);
                arrayList.add(new CalibrationItem(abstractLIBORMonteCarloProduct, d8, 1.0));
            }
        }
        return arrayList.toArray(new CalibrationItem[arrayList.size()]);
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) throws CalculationException {
        int n;
        int n2;
        int n3 = this.getLiborPeriodIndex(d);
        if (n3 < 0) {
            int n4 = -n3 - 1;
            int n5 = n4 - 1;
            if (n5 < 0) {
                throw new IllegalArgumentException("Numeraire requested for time " + d + ". Unsupported");
            }
            double d2 = (d - this.getLiborPeriod(n5)) / (this.getLiborPeriod(n4) - this.getLiborPeriod(n5));
            RandomVariableInterface randomVariableInterface = this.getNumeraire(this.getLiborPeriod(n4)).log().mult(d2).add(this.getNumeraire(this.getLiborPeriod(n5)).log().mult(1.0 - d2)).exp();
            if (this.discountCurve != null) {
                double d3 = randomVariableInterface.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, d);
                randomVariableInterface = randomVariableInterface.mult(d3);
            }
            return randomVariableInterface;
        }
        if (this.measure == Measure.TERMINAL) {
            n2 = this.getLiborPeriodIndex(d);
            if (n2 < 0) {
                throw new CalculationException("Simulation time discretization not part of forward rate tenor discretization.");
            }
            n = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
        } else if (this.measure == Measure.SPOT) {
            n2 = 0;
            n = this.getLiborPeriodIndex(d) - 1;
        } else {
            throw new CalculationException("Numeraire not implemented for specified measure.");
        }
        RandomVariableInterface randomVariableInterface = this.getProcess().getBrownianMotion().getRandomVariableForConstant(1.0);
        for (int i = n2; i <= n; ++i) {
            RandomVariableInterface randomVariableInterface2 = this.getLIBOR(this.getTimeIndex(Math.min(d, this.liborPeriodDiscretization.getTime(i))), i);
            double d4 = this.liborPeriodDiscretization.getTimeStep(i);
            randomVariableInterface = this.measure == Measure.SPOT ? randomVariableInterface.accrue(randomVariableInterface2, d4) : randomVariableInterface.discount(randomVariableInterface2, d4);
        }
        if (this.discountCurve != null) {
            double d5 = randomVariableInterface.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, d);
            randomVariableInterface = randomVariableInterface.mult(d5);
        }
        return randomVariableInterface;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        double[] dArray = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < this.liborPeriodDiscretization.getNumberOfTimeSteps(); ++i) {
            double d = this.forwardRateCurve.getForward(this.curveModel, this.liborPeriodDiscretization.getTime(i));
            dArray[i] = this.stateSpace == StateSpace.LOGNORMAL ? Math.log(Math.max(d, 0.0)) : d;
        }
        RandomVariableInterface[] randomVariableInterfaceArray = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            randomVariableInterfaceArray[i] = this.getProcess().getBrownianMotion().getRandomVariableForConstant(dArray[i]);
        }
        return randomVariableInterfaceArray;
    }

    @Override
    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        int n2;
        RandomVariableInterface[] randomVariableInterfaceArray3;
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2;
        double d;
        int n3;
        double d2 = this.getTime(n);
        int n4 = this.getLiborPeriodIndex(d2) + 1;
        if (n4 < 0) {
            n4 = -n4 - 1 + 1;
        }
        RandomVariableInterface randomVariableInterface3 = this.getProcess().getBrownianMotion().getRandomVariableForConstant(0.0);
        RandomVariableInterface[] randomVariableInterfaceArray4 = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int i = n4; i < this.getNumberOfComponents(); ++i) {
            randomVariableInterfaceArray4[i] = randomVariableInterface3;
        }
        RandomVariableInterface[] randomVariableInterfaceArray5 = new RandomVariableInterface[this.getNumberOfFactors()];
        for (n3 = 0; n3 < this.getNumberOfFactors(); ++n3) {
            randomVariableInterfaceArray5[n3] = randomVariableInterface3;
        }
        if (this.measure == Measure.SPOT) {
            for (n3 = n4; n3 < this.getNumberOfComponents(); ++n3) {
                d = this.liborPeriodDiscretization.getTimeStep(n3);
                randomVariableInterface2 = randomVariableInterfaceArray[n3];
                randomVariableInterface = this.getProcess().getBrownianMotion().getRandomVariableForConstant(d).discount(randomVariableInterface2, d);
                if (this.stateSpace == StateSpace.LOGNORMAL) {
                    randomVariableInterface = randomVariableInterface.mult(randomVariableInterface2);
                }
                randomVariableInterfaceArray3 = this.getFactorLoading(n, n3, randomVariableInterfaceArray);
                for (n2 = 0; n2 < this.getNumberOfFactors(); ++n2) {
                    randomVariableInterfaceArray5[n2] = randomVariableInterfaceArray5[n2].add(randomVariableInterface.mult(randomVariableInterfaceArray3[n2]));
                    randomVariableInterfaceArray4[n3] = randomVariableInterfaceArray4[n3].addProduct(randomVariableInterfaceArray5[n2], randomVariableInterfaceArray3[n2]);
                }
            }
        } else if (this.measure == Measure.TERMINAL) {
            for (n3 = this.getNumberOfComponents() - 1; n3 >= n4; --n3) {
                d = this.liborPeriodDiscretization.getTimeStep(n3);
                randomVariableInterface2 = randomVariableInterfaceArray[n3];
                randomVariableInterface = this.getProcess().getBrownianMotion().getRandomVariableForConstant(d).discount(randomVariableInterface2, d);
                if (this.stateSpace == StateSpace.LOGNORMAL) {
                    randomVariableInterface = randomVariableInterface.mult(randomVariableInterface2);
                }
                randomVariableInterfaceArray3 = this.getFactorLoading(n, n3, randomVariableInterfaceArray);
                for (n2 = 0; n2 < this.getNumberOfFactors(); ++n2) {
                    randomVariableInterfaceArray4[n3] = randomVariableInterfaceArray4[n3].addProduct(randomVariableInterfaceArray5[n2], randomVariableInterfaceArray3[n2]);
                    randomVariableInterfaceArray5[n2] = randomVariableInterfaceArray5[n2].sub(randomVariableInterface.mult(randomVariableInterfaceArray3[n2]));
                }
            }
        }
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            for (n3 = n4; n3 < this.getNumberOfComponents(); ++n3) {
                RandomVariableInterface randomVariableInterface4 = this.covarianceModel.getCovariance(this.getTime(n), n3, n3, randomVariableInterfaceArray);
                randomVariableInterfaceArray4[n3] = randomVariableInterfaceArray4[n3].addProduct(randomVariableInterface4, -0.5);
            }
        }
        return randomVariableInterfaceArray4;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        return this.covarianceModel.getFactorLoading(this.getTime(n), this.getLiborPeriod(n2), randomVariableInterfaceArray);
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int n, RandomVariableInterface randomVariableInterface) {
        RandomVariableInterface randomVariableInterface2 = randomVariableInterface;
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            randomVariableInterface2 = randomVariableInterface2.exp();
        }
        if (!Double.isInfinite(this.liborCap)) {
            randomVariableInterface2 = randomVariableInterface2.cap(this.liborCap);
        }
        return randomVariableInterface2;
    }

    public Driftapproximation getDriftApproximationMethod() {
        return this.driftApproximationMethod;
    }

    @Override
    public RandomVariableInterface getLIBOR(int n, int n2) throws CalculationException {
        return this.getProcessValue(n, n2);
    }

    @Override
    public int getNumberOfComponents() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public int getNumberOfLibors() {
        return this.getNumberOfComponents();
    }

    @Override
    public double getLiborPeriod(int n) {
        if (n >= this.liborPeriodDiscretization.getNumberOfTimes() || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index for LIBOR period discretization out of bounds: " + n + ".");
        }
        return this.liborPeriodDiscretization.getTime(n);
    }

    @Override
    public int getLiborPeriodIndex(double d) {
        return this.liborPeriodDiscretization.getTimeIndex(d);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][][] getIntegratedLIBORCovariance() {
        Object object = this.integratedLIBORCovarianceLazyInitLock;
        synchronized (object) {
            if (this.integratedLIBORCovariance == null) {
                int n;
                int n2;
                TimeDiscretizationInterface timeDiscretizationInterface = this.getLiborPeriodDiscretization();
                TimeDiscretizationInterface timeDiscretizationInterface2 = this.getCovarianceModel().getTimeDiscretization();
                this.integratedLIBORCovariance = new double[timeDiscretizationInterface2.getNumberOfTimeSteps()][timeDiscretizationInterface.getNumberOfTimeSteps()][timeDiscretizationInterface.getNumberOfTimeSteps()];
                for (n2 = 0; n2 < timeDiscretizationInterface2.getNumberOfTimeSteps(); ++n2) {
                    double d = timeDiscretizationInterface2.getTime(n2 + 1) - timeDiscretizationInterface2.getTime(n2);
                    RandomVariableInterface[][] randomVariableInterfaceArrayArray = new RandomVariableInterface[timeDiscretizationInterface.getNumberOfTimeSteps()][];
                    for (n = 0; n < timeDiscretizationInterface.getNumberOfTimeSteps(); ++n) {
                        randomVariableInterfaceArrayArray[n] = this.getCovarianceModel().getFactorLoading(n2, n, (RandomVariableInterface[])null);
                    }
                    for (n = 0; n < timeDiscretizationInterface.getNumberOfTimeSteps(); ++n) {
                        RandomVariableInterface[] randomVariableInterfaceArray = randomVariableInterfaceArrayArray[n];
                        for (int i = n; i < timeDiscretizationInterface.getNumberOfTimeSteps(); ++i) {
                            double d2 = 0.0;
                            if (this.getLiborPeriod(n) > this.getTime(n2)) {
                                RandomVariableInterface[] randomVariableInterfaceArray2 = randomVariableInterfaceArrayArray[i];
                                for (int j = 0; j < this.getNumberOfFactors(); ++j) {
                                    d2 += randomVariableInterfaceArray[j].get(0) * randomVariableInterfaceArray2[j].get(0) * d;
                                }
                            }
                            this.integratedLIBORCovariance[n2][n][i] = d2;
                        }
                    }
                }
                for (n2 = 1; n2 < timeDiscretizationInterface2.getNumberOfTimeSteps(); ++n2) {
                    double[][] dArray = this.integratedLIBORCovariance[n2 - 1];
                    double[][] dArray2 = this.integratedLIBORCovariance[n2];
                    for (int i = 0; i < timeDiscretizationInterface.getNumberOfTimeSteps(); ++i) {
                        for (n = i; n < timeDiscretizationInterface.getNumberOfTimeSteps(); ++n) {
                            dArray2[i][n] = dArray[i][n] + dArray2[i][n];
                            dArray2[n][i] = dArray2[i][n];
                        }
                    }
                }
            }
        }
        return this.integratedLIBORCovariance;
    }

    public Object clone() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("measure", this.measure.name());
            hashMap.put("stateSpace", this.stateSpace.name());
            return new LIBORMarketModel(this.getLiborPeriodDiscretization(), this.getForwardRateCurve(), this.getDiscountCurve(), this.covarianceModel, new CalibrationItem[0], hashMap);
        }
        catch (CalculationException calculationException) {
            return null;
        }
    }

    @Override
    public AnalyticModelInterface getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurveInterface getDiscountCurve() {
        if (this.discountCurve == null) {
            DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(this.getForwardRateCurve());
            this.discountCurve = discountCurveFromForwardCurve;
        }
        return this.discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    public AbstractSwaptionMarketData getSwaptionMarketData() {
        return this.swaptionMarketData;
    }

    @Override
    public AbstractLIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public LIBORMarketModel getCloneWithModifiedCovarianceModel(AbstractLIBORCovarianceModel abstractLIBORCovarianceModel) {
        LIBORMarketModel lIBORMarketModel = (LIBORMarketModel)this.clone();
        lIBORMarketModel.covarianceModel = abstractLIBORCovarianceModel;
        return lIBORMarketModel;
    }

    @Override
    public LIBORMarketModel getCloneWithModifiedData(Map<String, Object> map) throws CalculationException {
        TimeDiscretizationInterface timeDiscretizationInterface = this.liborPeriodDiscretization;
        AnalyticModelInterface analyticModelInterface = this.curveModel;
        ForwardCurveInterface forwardCurveInterface = this.forwardRateCurve;
        DiscountCurveInterface discountCurveInterface = this.discountCurve;
        AbstractLIBORCovarianceModel abstractLIBORCovarianceModel = this.covarianceModel;
        AbstractSwaptionMarketData abstractSwaptionMarketData = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("measure", this.measure.name());
        hashMap.put("stateSpace", this.stateSpace.name());
        if (map.containsKey("liborPeriodDiscretization")) {
            timeDiscretizationInterface = (TimeDiscretizationInterface)map.get("liborPeriodDiscretization");
        }
        if (map.containsKey("forwardRateCurve")) {
            forwardCurveInterface = (ForwardCurveInterface)map.get("forwardRateCurve");
        }
        if (map.containsKey("discountCurve")) {
            discountCurveInterface = (DiscountCurveInterface)map.get("discountCurve");
        }
        if (map.containsKey("forwardRateShift")) {
            throw new RuntimeException("Forward rate shift clone currently disabled.");
        }
        if (map.containsKey("covarianceModel")) {
            abstractLIBORCovarianceModel = (AbstractLIBORCovarianceModel)map.get("covarianceModel");
        }
        if (map.containsKey("swaptionMarketData")) {
            abstractSwaptionMarketData = (AbstractSwaptionMarketData)map.get("swaptionMarketData");
        }
        LIBORMarketModel lIBORMarketModel = new LIBORMarketModel(timeDiscretizationInterface, forwardCurveInterface, discountCurveInterface, abstractLIBORCovarianceModel, abstractSwaptionMarketData, hashMap);
        lIBORMarketModel.curveModel = analyticModelInterface;
        return lIBORMarketModel;
    }

    public String toString() {
        return "LIBORMarketModel [liborPeriodDiscretization=" + this.liborPeriodDiscretization + ", forwardCurveName=" + this.forwardCurveName + ", curveModel=" + this.curveModel + ", forwardRateCurve=" + this.forwardRateCurve + ", discountCurve=" + this.discountCurve + ", covarianceModel=" + this.covarianceModel + ", driftApproximationMethod=" + (Object)((Object)this.driftApproximationMethod) + ", measure=" + (Object)((Object)this.measure) + ", stateSpace=" + (Object)((Object)this.stateSpace) + "]";
    }

    public static class CalibrationItem {
        public final AbstractLIBORMonteCarloProduct calibrationProduct;
        public final double calibrationTargetValue;
        public final double calibrationWeight;

        public CalibrationItem(AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct, double d, double d2) {
            this.calibrationProduct = abstractLIBORMonteCarloProduct;
            this.calibrationTargetValue = d;
            this.calibrationWeight = d2;
        }

        public String toString() {
            return "CalibrationItem [calibrationProduct=" + this.calibrationProduct + ", calibrationTargetValue=" + this.calibrationTargetValue + ", calibrationWeight=" + this.calibrationWeight + "]";
        }
    }

    public static enum StateSpace {
        NORMAL,
        LOGNORMAL;

    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

