/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class HybridAssetLIBORModelMonteCarloSimulation
implements HybridAssetLIBORModelMonteCarloSimulationInterface {
    private LIBORModelMonteCarloSimulationInterface liborSimulation;
    private AssetModelMonteCarloSimulationInterface assetSimulation;
    private DiscountCurveInterface discountCurve;

    public HybridAssetLIBORModelMonteCarloSimulation(LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface, DiscountCurveInterface discountCurveInterface) {
        this.liborSimulation = lIBORModelMonteCarloSimulationInterface;
        this.assetSimulation = assetModelMonteCarloSimulationInterface;
        this.discountCurve = discountCurveInterface;
        if (!lIBORModelMonteCarloSimulationInterface.getTimeDiscretization().equals(assetModelMonteCarloSimulationInterface.getTimeDiscretization())) {
            throw new IllegalArgumentException("The interest rate simulation and the asset simulation need to share the same simulation time discretization.");
        }
    }

    public HybridAssetLIBORModelMonteCarloSimulation(LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) {
        this(lIBORModelMonteCarloSimulationInterface, assetModelMonteCarloSimulationInterface, null);
    }

    @Override
    public int getNumberOfPaths() {
        return this.liborSimulation.getNumberOfPaths();
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.liborSimulation.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.liborSimulation.getNumberOfFactors();
    }

    @Override
    public double getTime(int n) {
        return this.liborSimulation.getTime(n);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborSimulation.getLiborPeriodDiscretization();
    }

    @Override
    public int getTimeIndex(double d) {
        return this.liborSimulation.getTimeIndex(d);
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborSimulation.getNumberOfLibors();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.liborSimulation.getRandomVariableForConstant(d);
    }

    @Override
    public double getLiborPeriod(int n) {
        return this.liborSimulation.getLiborPeriod(n);
    }

    @Override
    public int getLiborPeriodIndex(double d) {
        return this.liborSimulation.getLiborPeriodIndex(d);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int n) throws CalculationException {
        return this.liborSimulation.getMonteCarloWeights(n);
    }

    @Override
    public RandomVariableInterface getLIBOR(int n, int n2) throws CalculationException {
        return this.liborSimulation.getLIBOR(n, n2);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double d) throws CalculationException {
        return this.liborSimulation.getMonteCarloWeights(d);
    }

    @Override
    public RandomVariableInterface getLIBOR(double d, double d2, double d3) throws CalculationException {
        return this.liborSimulation.getLIBOR(d, d2, d3);
    }

    @Override
    public HybridAssetLIBORModelMonteCarloSimulation getCloneWithModifiedData(Map<String, Object> map) throws CalculationException {
        return null;
    }

    @Override
    public RandomVariableInterface[] getLIBORs(int n) throws CalculationException {
        return this.liborSimulation.getLIBORs(n);
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) throws CalculationException {
        RandomVariableInterface randomVariableInterface = this.liborSimulation.getNumeraire(d);
        if (this.discountCurve != null) {
            double d2 = randomVariableInterface.invert().getAverage() / this.discountCurve.getDiscountFactor(d);
            randomVariableInterface = randomVariableInterface.mult(d2);
        }
        return randomVariableInterface;
    }

    @Override
    public RandomVariableInterface getNumeraire(int n) throws CalculationException {
        return this.getNumeraire(this.getTime(n));
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return this.liborSimulation.getBrownianMotion();
    }

    @Override
    public LIBORMarketModelInterface getModel() {
        return this.liborSimulation.getModel();
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.liborSimulation.getProcess();
    }

    @Override
    public AbstractLIBORCovarianceModel getCovarianceModel() {
        return this.liborSimulation.getCovarianceModel();
    }

    @Override
    public HybridAssetLIBORModelMonteCarloSimulation getCloneWithModifiedSeed(int n) {
        return null;
    }

    @Override
    public int getNumberOfAssets() {
        return this.assetSimulation.getNumberOfAssets();
    }

    @Override
    public RandomVariableInterface getAssetValue(int n, int n2) throws CalculationException {
        return this.assetSimulation.getAssetValue(n, n2).mult(this.liborSimulation.getNumeraire(this.getTime(n))).div(this.assetSimulation.getNumeraire(n));
    }

    @Override
    public RandomVariableInterface getAssetValue(double d, int n) throws CalculationException {
        int n2 = this.getTimeIndex(d);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        return this.getAssetValue(n2, n);
    }
}

