/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariableInterface;

public class BermudanOption
extends AbstractAssetMonteCarloProduct {
    private final double[] exerciseDates;
    private final double[] notionals;
    private final double[] strikes;
    private final int orderOfRegressionPolynomial = 4;
    private final boolean intrinsicValueAsBasisFunction = true;
    private ExerciseMethod exerciseMethod = ExerciseMethod.UPPER_BOUND_METHOD;

    public BermudanOption(double[] dArray, double[] dArray2, double[] dArray3) {
        this.exerciseDates = dArray;
        this.notionals = dArray2;
        this.strikes = dArray3;
    }

    public BermudanOption(double[] dArray, double[] dArray2, double[] dArray3, ExerciseMethod exerciseMethod) {
        this.exerciseDates = dArray;
        this.notionals = dArray2;
        this.strikes = dArray3;
        this.exerciseMethod = exerciseMethod;
    }

    @Override
    public RandomVariableInterface getValue(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) throws CalculationException {
        if (this.exerciseMethod == ExerciseMethod.UPPER_BOUND_METHOD) {
            GoldenSectionSearch goldenSectionSearch = new GoldenSectionSearch(-1.0, 1.0);
            while (!goldenSectionSearch.isDone()) {
                double d2 = goldenSectionSearch.getNextPoint();
                double d3 = this.getValues(d, assetModelMonteCarloSimulationInterface, d2).getAverage();
                goldenSectionSearch.setValue(d3);
            }
            return this.getValues(d, assetModelMonteCarloSimulationInterface, goldenSectionSearch.getBestPoint());
        }
        return this.getValues(d, assetModelMonteCarloSimulationInterface, 0.0);
    }

    private RandomVariableInterface getValues(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface, double d2) throws CalculationException {
        RandomVariableInterface randomVariableInterface = assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        RandomVariableInterface randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.exerciseDates[this.exerciseDates.length - 1] + 1.0);
        for (int i = this.exerciseDates.length - 1; i >= 0; --i) {
            double d3 = this.exerciseDates[i];
            double d4 = this.notionals[i];
            double d5 = this.strikes[i];
            RandomVariableInterface randomVariableInterface3 = assetModelMonteCarloSimulationInterface.getAssetValue(d3, 0);
            RandomVariableInterface randomVariableInterface4 = assetModelMonteCarloSimulationInterface.getNumeraire(d3);
            RandomVariableInterface randomVariableInterface5 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(d3);
            RandomVariableInterface randomVariableInterface6 = randomVariableInterface3.sub(d5).mult(d4).div(randomVariableInterface4).mult(randomVariableInterface5);
            MonteCarloConditionalExpectationRegression monteCarloConditionalExpectationRegression = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(randomVariableInterface3.sub(d5).floor(0.0)));
            RandomVariableInterface randomVariableInterface7 = null;
            RandomVariableInterface randomVariableInterface8 = null;
            switch (this.exerciseMethod) {
                case ESTIMATE_COND_EXPECTATION: {
                    RandomVariableInterface randomVariableInterface9 = monteCarloConditionalExpectationRegression.getConditionalExpectation(randomVariableInterface);
                    randomVariableInterface7 = randomVariableInterface6;
                    randomVariableInterface8 = randomVariableInterface9.sub(randomVariableInterface7);
                    break;
                }
                case UPPER_BOUND_METHOD: {
                    RandomVariableInterface randomVariableInterface10 = assetModelMonteCarloSimulationInterface.getAssetValue(this.exerciseDates[this.exerciseDates.length - 1], 0).div(assetModelMonteCarloSimulationInterface.getNumeraire(this.exerciseDates[this.exerciseDates.length - 1]));
                    randomVariableInterface10 = randomVariableInterface10.sub(randomVariableInterface10.getAverage()).mult(d2);
                    randomVariableInterface7 = randomVariableInterface6.sub(randomVariableInterface10);
                    if (i == this.exerciseDates.length - 1) {
                        randomVariableInterface = randomVariableInterface.sub(randomVariableInterface10);
                    }
                    randomVariableInterface8 = randomVariableInterface.sub(randomVariableInterface7);
                }
            }
            randomVariableInterface = randomVariableInterface.barrier(randomVariableInterface8, randomVariableInterface, randomVariableInterface7);
            randomVariableInterface2 = randomVariableInterface2.barrier(randomVariableInterface8, randomVariableInterface2, d3);
        }
        RandomVariableInterface randomVariableInterface11 = assetModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface12 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface = randomVariableInterface.mult(randomVariableInterface11).div(randomVariableInterface12);
        return randomVariableInterface;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(RandomVariableInterface randomVariableInterface) {
        RandomVariableInterface[] randomVariableInterfaceArray = new RandomVariableInterface[5];
        randomVariableInterfaceArray[0] = new RandomVariable(1.0);
        randomVariableInterfaceArray[1] = randomVariableInterface;
        for (int i = 2; i <= 4; ++i) {
            randomVariableInterfaceArray[i] = randomVariableInterface.pow(i);
        }
        return randomVariableInterfaceArray;
    }

    public static enum ExerciseMethod {
        ESTIMATE_COND_EXPECTATION,
        UPPER_BOUND_METHOD;

    }
}

