/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class BasketOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double[] weights;
    private final String[] nameOfUnderliyngs;

    public BasketOption(double d, double d2, double[] dArray) {
        this.maturity = d;
        this.strike = d2;
        this.weights = dArray;
        this.nameOfUnderliyngs = null;
    }

    @Override
    public RandomVariableInterface getValue(double d, AssetModelMonteCarloSimulationInterface assetModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2 = assetModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        for (int i = 0; i < this.weights.length; ++i) {
            randomVariableInterface = assetModelMonteCarloSimulationInterface.getAssetValue(this.maturity, i);
            randomVariableInterface2 = randomVariableInterface2.addProduct(randomVariableInterface, this.weights[i]);
        }
        randomVariableInterface2 = randomVariableInterface2.sub(this.strike).floor(0.0);
        RandomVariableInterface randomVariableInterface3 = assetModelMonteCarloSimulationInterface.getNumeraire(this.maturity);
        randomVariableInterface = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(this.maturity);
        randomVariableInterface2 = randomVariableInterface2.div(randomVariableInterface3).mult(randomVariableInterface);
        RandomVariableInterface randomVariableInterface4 = assetModelMonteCarloSimulationInterface.getNumeraire(d);
        RandomVariableInterface randomVariableInterface5 = assetModelMonteCarloSimulationInterface.getMonteCarloWeights(d);
        randomVariableInterface2 = randomVariableInterface2.mult(randomVariableInterface4).div(randomVariableInterface5);
        return randomVariableInterface2;
    }
}

