/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class Swap
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final SwapLeg legReceiver;
    private final SwapLeg legPayer;

    public Swap(ScheduleInterface scheduleInterface, String string, double d, String string2, ScheduleInterface scheduleInterface2, String string3, double d2, String string4, boolean bl) {
        this.legReceiver = new SwapLeg(scheduleInterface, string, d, string2, bl);
        this.legPayer = new SwapLeg(scheduleInterface2, string3, d2, string4, bl);
    }

    public Swap(ScheduleInterface scheduleInterface, String string, double d, String string2, ScheduleInterface scheduleInterface2, String string3, double d2, String string4) {
        this(scheduleInterface, string, d, string2, scheduleInterface2, string3, d2, string4, true);
    }

    public Swap(ScheduleInterface scheduleInterface, double d, String string, ScheduleInterface scheduleInterface2, String string2, String string3) {
        this(scheduleInterface, null, d, string, scheduleInterface2, string2, 0.0, string3, true);
    }

    @Override
    public double getValue(double d, AnalyticModelInterface analyticModelInterface) {
        double d2 = this.legReceiver.getValue(d, analyticModelInterface);
        double d3 = this.legPayer.getValue(d, analyticModelInterface);
        return d2 - d3;
    }

    public static double getForwardSwapRate(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, ForwardCurveInterface forwardCurveInterface) {
        return Swap.getForwardSwapRate(new RegularSchedule(timeDiscretizationInterface), new RegularSchedule(timeDiscretizationInterface2), forwardCurveInterface);
    }

    public static double getForwardSwapRate(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, ForwardCurveInterface forwardCurveInterface, DiscountCurveInterface discountCurveInterface) {
        AnalyticModel analyticModel = null;
        if (discountCurveInterface != null) {
            analyticModel = new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveInterface});
        }
        return Swap.getForwardSwapRate(new RegularSchedule(timeDiscretizationInterface), new RegularSchedule(timeDiscretizationInterface2), forwardCurveInterface, analyticModel);
    }

    public static double getForwardSwapRate(ScheduleInterface scheduleInterface, ScheduleInterface scheduleInterface2, ForwardCurveInterface forwardCurveInterface) {
        return Swap.getForwardSwapRate(scheduleInterface, scheduleInterface2, forwardCurveInterface, null);
    }

    public static double getForwardSwapRate(ScheduleInterface scheduleInterface, ScheduleInterface scheduleInterface2, ForwardCurveInterface forwardCurveInterface, AnalyticModelInterface analyticModelInterface) {
        DiscountCurveInterface discountCurveInterface;
        DiscountCurveInterface discountCurveInterface2 = discountCurveInterface = analyticModelInterface == null ? null : analyticModelInterface.getDiscountCurve(forwardCurveInterface.getDiscountCurveName());
        if (discountCurveInterface == null) {
            discountCurveInterface = new DiscountCurveFromForwardCurve(forwardCurveInterface.getName());
            analyticModelInterface = new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveInterface});
        }
        double d = scheduleInterface.getFixing(0);
        double d2 = SwapAnnuity.getSwapAnnuity(d, scheduleInterface, discountCurveInterface, analyticModelInterface);
        double d3 = 0.0;
        for (int i = 0; i < scheduleInterface2.getNumberOfPeriods(); ++i) {
            double d4 = scheduleInterface2.getFixing(i);
            double d5 = scheduleInterface2.getPayment(i);
            double d6 = scheduleInterface2.getPeriodLength(i);
            double d7 = forwardCurveInterface.getForward(analyticModelInterface, d4);
            double d8 = discountCurveInterface.getDiscountFactor(analyticModelInterface, d5);
            d3 += d7 * d6 * d8;
        }
        double d9 = d3 / discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
        return d9 / d2;
    }

    public SwapLeg getLegReceiver() {
        return this.legReceiver;
    }

    public SwapLeg getLegPayer() {
        return this.legPayer;
    }

    public String toString() {
        return "Swap [legReceiver=" + this.legReceiver + ", legPayer=" + this.legPayer + "]";
    }
}

