/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Forward
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final double maturity;
    private final double paymentOffset;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;

    public Forward(double d, double d2, String string, double d3, String string2) {
        this.maturity = d;
        this.paymentOffset = d2;
        this.forwardCurveName = string;
        this.spread = d3;
        this.discountCurveName = string2;
    }

    @Override
    public double getValue(double d, AnalyticModelInterface analyticModelInterface) {
        ForwardCurveInterface forwardCurveInterface = analyticModelInterface.getForwardCurve(this.forwardCurveName);
        DiscountCurveInterface discountCurveInterface = analyticModelInterface.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveInterface2 = null;
        if (forwardCurveInterface == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveInterface2 = analyticModelInterface.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        double d2 = this.spread;
        if (forwardCurveInterface != null) {
            d2 += forwardCurveInterface.getForward(analyticModelInterface, this.maturity);
        } else if (discountCurveInterface2 != null) {
            d2 += (discountCurveInterface2.getDiscountFactor(this.maturity) / discountCurveInterface2.getDiscountFactor(this.maturity + this.paymentOffset) - 1.0) / this.paymentOffset;
        }
        double d3 = this.maturity + this.paymentOffset > d ? discountCurveInterface.getDiscountFactor(analyticModelInterface, this.maturity + this.paymentOffset) : 0.0;
        return d2 * d3 / discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
    }
}

