/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.CapletVolatilities;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleInterface;

public class Cap
extends AbstractAnalyticProduct {
    private final ScheduleInterface schedule;
    private final String forwardCurveName;
    private final double strike;
    private final boolean isStrikeMoneyness;
    private final String discountCurveName;
    private final String volatiltiySufaceName;
    private final VolatilitySurfaceInterface.QuotingConvention quotingConvention;
    private transient double cachedATMForward = Double.NaN;
    private transient SoftReference<AnalyticModelInterface> cacheStateModel;
    private transient boolean cacheStateIsFirstPeriodIncluded;

    public Cap(ScheduleInterface scheduleInterface, String string, double d, boolean bl, String string2, String string3, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        this.schedule = scheduleInterface;
        this.forwardCurveName = string;
        this.strike = d;
        this.isStrikeMoneyness = bl;
        this.discountCurveName = string2;
        this.volatiltiySufaceName = string3;
        this.quotingConvention = quotingConvention;
    }

    public Cap(ScheduleInterface scheduleInterface, String string, double d, boolean bl, String string2, String string3) {
        this(scheduleInterface, string, d, bl, string2, string3, VolatilitySurfaceInterface.QuotingConvention.PRICE);
    }

    @Override
    public double getValue(double d, AnalyticModelInterface analyticModelInterface) {
        if (this.quotingConvention == VolatilitySurfaceInterface.QuotingConvention.PRICE) {
            return this.getValueAsPrice(d, analyticModelInterface);
        }
        return this.getImpliedVolatility(d, analyticModelInterface, this.quotingConvention);
    }

    public double getValueAsPrice(double d, AnalyticModelInterface analyticModelInterface) {
        ForwardCurveInterface forwardCurveInterface = analyticModelInterface.getForwardCurve(this.forwardCurveName);
        DiscountCurveInterface discountCurveInterface = analyticModelInterface.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveInterface2 = null;
        if (forwardCurveInterface == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveInterface2 = analyticModelInterface.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        double d2 = 0.0;
        for (int i = 0; i < this.schedule.getNumberOfPeriods(); ++i) {
            double d3;
            VolatilitySurfaceInterface volatilitySurfaceInterface;
            double d4 = this.schedule.getFixing(i);
            double d5 = this.schedule.getPayment(i);
            double d6 = this.schedule.getPeriodLength(i);
            if (d6 == 0.0) continue;
            double d7 = 0.0;
            if (forwardCurveInterface != null) {
                d7 += forwardCurveInterface.getForward(analyticModelInterface, d4);
            } else if (discountCurveInterface2 != null && d4 != d5) {
                d7 += (discountCurveInterface2.getDiscountFactor(d4) / discountCurveInterface2.getDiscountFactor(d5) - 1.0) / (d5 - d4);
            }
            double d8 = d5 > d ? discountCurveInterface.getDiscountFactor(analyticModelInterface, d5) : 0.0;
            double d9 = d8 * d6;
            double d10 = this.strike;
            if (this.isStrikeMoneyness) {
                d10 += this.getATMForward(analyticModelInterface, true);
            }
            if ((volatilitySurfaceInterface = analyticModelInterface.getVolatilitySurface(this.volatiltiySufaceName)) == null) {
                throw new IllegalArgumentException("Volatility surface not found in model: " + this.volatiltiySufaceName);
            }
            if (volatilitySurfaceInterface.getQuotingConvention() == VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL) {
                d3 = volatilitySurfaceInterface.getValue(analyticModelInterface, d4, d10, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
                d2 += AnalyticFormulas.blackScholesGeneralizedOptionValue(d7, d3, d4, d10, d9);
                continue;
            }
            d3 = volatilitySurfaceInterface.getValue(analyticModelInterface, d4, d10, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL);
            d2 += AnalyticFormulas.bachelierOptionValue(d7, d3, d4, d10, d9);
        }
        return d2 / discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
    }

    public double getATMForward(AnalyticModelInterface analyticModelInterface, boolean bl) {
        Object object;
        if (!Double.isNaN(this.cachedATMForward) && this.cacheStateModel.get() == analyticModelInterface && this.cacheStateIsFirstPeriodIncluded == bl) {
            return this.cachedATMForward;
        }
        ScheduleInterface scheduleInterface = this.schedule;
        if (!bl) {
            object = new ArrayList<Period>();
            ((ArrayList)object).addAll(this.schedule.getPeriods());
            if (((ArrayList)object).size() > 1) {
                ((ArrayList)object).remove(0);
            }
            scheduleInterface = new Schedule(this.schedule.getReferenceDate(), (List<Period>)object, this.schedule.getDaycountconvention());
        }
        object = new SwapLeg(scheduleInterface, this.forwardCurveName, 0.0, this.discountCurveName, false);
        SwapLeg swapLeg = new SwapLeg(scheduleInterface, null, 1.0, this.discountCurveName, false);
        this.cachedATMForward = ((AbstractAnalyticProduct)object).getValue(analyticModelInterface) / swapLeg.getValue(analyticModelInterface);
        this.cacheStateModel = new SoftReference<AnalyticModelInterface>(analyticModelInterface);
        this.cacheStateIsFirstPeriodIncluded = bl;
        return this.cachedATMForward;
    }

    public double getImpliedVolatility(double d, AnalyticModelInterface analyticModelInterface, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        double d2;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        for (int i = 0; i < this.schedule.getNumberOfPeriods(); ++i) {
            double d5 = this.schedule.getFixing(i);
            d2 = this.schedule.getPeriodLength(i);
            if (d2 == 0.0) continue;
            double d6 = this.strike;
            if (this.isStrikeMoneyness) {
                d6 += this.getATMForward(analyticModelInterface, true);
            }
            VolatilitySurfaceInterface volatilitySurfaceInterface = analyticModelInterface.getVolatilitySurface(this.volatiltiySufaceName);
            double d7 = volatilitySurfaceInterface.getValue(analyticModelInterface, d5, d6, quotingConvention);
            d3 = Math.min(d7, d3);
            d4 = Math.max(d7, d4);
        }
        double d8 = this.getValueAsPrice(d, analyticModelInterface);
        int n = 100;
        d2 = 0.0;
        GoldenSectionSearch goldenSectionSearch = new GoldenSectionSearch(d3, d4);
        while (goldenSectionSearch.getAccuracy() > d2 && !goldenSectionSearch.isDone() && goldenSectionSearch.getNumberOfIterations() < n) {
            double d9 = goldenSectionSearch.getNextPoint();
            double[] dArray = new double[]{1.0};
            double[] dArray2 = new double[]{0.0};
            double[] dArray3 = new double[]{d9};
            CapletVolatilities capletVolatilities = new CapletVolatilities(analyticModelInterface.getVolatilitySurface(this.volatiltiySufaceName).getName(), analyticModelInterface.getVolatilitySurface(this.volatiltiySufaceName).getReferenceDate(), analyticModelInterface.getForwardCurve(this.forwardCurveName), dArray, dArray2, dArray3, quotingConvention, analyticModelInterface.getDiscountCurve(this.discountCurveName));
            AnalyticModelInterface analyticModelInterface2 = analyticModelInterface.clone();
            analyticModelInterface2 = analyticModelInterface2.addVolatilitySurfaces(capletVolatilities);
            double d10 = this.getValueAsPrice(d, analyticModelInterface2);
            double d11 = d8 - d10;
            goldenSectionSearch.setValue(d11 * d11);
        }
        return goldenSectionSearch.getBestPoint();
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double getStrike() {
        return this.strike;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public String toString() {
        return "Cap [schedule=" + this.schedule + ", forwardCurveName=" + this.forwardCurveName + ", strike=" + this.strike + ", discountCurveName=" + this.discountCurveName + ", volatiltiySufaceName=" + this.volatiltiySufaceName + "]";
    }
}

