/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveNelsonSiegelSvensson;
import net.finmath.marketdata.model.curves.ForwardCurveNelsonSiegelSvensson;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurfaceParametric;
import net.finmath.marketdata.model.volatilities.CapletVolatilitiesParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.Cap;
import net.finmath.optimizer.SolverException;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;
import org.junit.Assert;
import org.junit.Test;

public class VolatilityCalibrationTest {
    static final double errorTolerance = 1.0E-5;

    public static void main(String[] stringArray) throws SolverException, CalculationException {
        VolatilityCalibrationTest volatilityCalibrationTest = new VolatilityCalibrationTest();
        volatilityCalibrationTest.testVolatilityCalibration();
    }

    @Test
    public void testVolatilityCalibration() throws CalculationException, SolverException {
        double d;
        Cloneable cloneable;
        Object object;
        Cloneable cloneable2;
        DiscountCurveNelsonSiegelSvensson discountCurveNelsonSiegelSvensson = new DiscountCurveNelsonSiegelSvensson("EUR", new GregorianCalendar(2014, 6, 15), new double[]{0.02, -0.01, 0.14, -0.1, 4.0, 3.0}, 1.0);
        ForwardCurveNelsonSiegelSvensson forwardCurveNelsonSiegelSvensson = new ForwardCurveNelsonSiegelSvensson("EUR FWD", new GregorianCalendar(2014, 6, 17), "3M", new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendarInterface.DateRollConvention.MODIFIED_FOLLOWING, new DayCountConvention_ACT_360(), discountCurveNelsonSiegelSvensson.getParameter(), 1.0, 0.0);
        String[] stringArray = new String[]{"1Y", "2Y", "3Y", "4Y", "5Y", "6Y", "7Y", "8Y", "9Y", "10Y", "12Y", "15Y", "20Y"};
        Double[] doubleArray = new Double[]{0.72, 0.86, 0.75, 0.69, 0.67, 0.64, 0.58, 0.52, 0.47, 0.44, 0.4, 0.35, 0.32};
        AnalyticModel analyticModel = new AnalyticModel(new CurveInterface[]{discountCurveNelsonSiegelSvensson, forwardCurveNelsonSiegelSvensson});
        System.out.println("Given a disocunt curve:");
        System.out.println(((Object)discountCurveNelsonSiegelSvensson).toString());
        double d2 = 1.0;
        double d3 = forwardCurveNelsonSiegelSvensson.getForward(analyticModel, d2);
        System.out.println("Quaterly forward with fixing in " + d2 + " calculated from that discount curve is " + d3);
        double d4 = 0.25753424657534246;
        double d5 = d4 * 365.0 / 360.0;
        double d6 = (discountCurveNelsonSiegelSvensson.getDiscountFactor(analyticModel, d2) / discountCurveNelsonSiegelSvensson.getDiscountFactor(analyticModel, d2 + d4) - 1.0) / d5;
        System.out.println("Quaterly forward with fixing in " + d2 + " calculated from that discount curve is " + d6);
        Assert.assertTrue((Math.abs(d3 - d6) < 1.0E-5 ? 1 : 0) != 0);
        double d7 = 0.5;
        double d8 = 1.0;
        double d9 = 0.5;
        double d10 = 0.2;
        CapletVolatilitiesParametric capletVolatilitiesParametric = new CapletVolatilitiesParametric("Caplet", null, d7, d8, d9, d10);
        Vector<Cap> vector = new Vector<Cap>();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2014, 6, 15);
        DayCountConvention_ACT_365 dayCountConvention_ACT_365 = new DayCountConvention_ACT_365();
        ScheduleGenerator.DaycountConvention daycountConvention = ScheduleGenerator.DaycountConvention.ACT_360;
        for (int i = 0; i < stringArray.length; ++i) {
            cloneable2 = gregorianCalendar;
            Calendar calendar = BusinessdayCalendar.createDateFromDateAndOffsetCode(gregorianCalendar, stringArray[i]);
            double d11 = doubleArray[i];
            Cap cap = new Cap(ScheduleGenerator.createScheduleFromConventions(gregorianCalendar, (Calendar)cloneable2, calendar, ScheduleGenerator.Frequency.SEMIANNUAL, daycountConvention, ScheduleGenerator.ShortPeriodConvention.FIRST, BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingWeekends(), 0, 0), forwardCurveNelsonSiegelSvensson.getName(), 0.0, true, discountCurveNelsonSiegelSvensson.getName(), capletVolatilitiesParametric.getName(), VolatilitySurfaceInterface.QuotingConvention.PRICE);
            CapletVolatilitiesParametric capletVolatilitiesParametric2 = new CapletVolatilitiesParametric("Caplet", null, 0.0, 0.0, 0.0, d11);
            object = analyticModel.clone().addVolatilitySurfaces(capletVolatilitiesParametric2);
            double d12 = cap.getValue(0.0, (AnalyticModelInterface)object);
            vector.add(cap);
            arrayList.add(new Double(d12));
        }
        Vector<AnalyticProductInterface> vector2 = new Vector<AnalyticProductInterface>();
        cloneable2 = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            GregorianCalendar gregorianCalendar2 = gregorianCalendar;
            cloneable = BusinessdayCalendar.createDateFromDateAndOffsetCode(gregorianCalendar, stringArray[i]);
            double d13 = doubleArray[i];
            object = new Cap(ScheduleGenerator.createScheduleFromConventions(gregorianCalendar, gregorianCalendar2, (Calendar)cloneable, ScheduleGenerator.Frequency.SEMIANNUAL, daycountConvention, ScheduleGenerator.ShortPeriodConvention.FIRST, BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingWeekends(), 0, 0), forwardCurveNelsonSiegelSvensson.getName(), 0.0, true, discountCurveNelsonSiegelSvensson.getName(), capletVolatilitiesParametric.getName(), VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
            CapletVolatilitiesParametric capletVolatilitiesParametric3 = new CapletVolatilitiesParametric("Caplet", null, 0.0, 0.0, 0.0, d13);
            AnalyticModelInterface analyticModelInterface = analyticModel.clone().addVolatilitySurfaces(capletVolatilitiesParametric3);
            d = ((Cap)object).getValue(0.0, analyticModelInterface);
            vector2.add((AnalyticProductInterface)object);
            ((ArrayList)cloneable2).add(new Double(d));
        }
        AbstractVolatilitySurfaceParametric abstractVolatilitySurfaceParametric = capletVolatilitiesParametric.getCloneCalibrated(analyticModel, vector2, (List<Double>)((Object)cloneable2), null);
        double[] dArray = abstractVolatilitySurfaceParametric.getParameter();
        cloneable = analyticModel.clone();
        cloneable = cloneable.addVolatilitySurfaces(abstractVolatilitySurfaceParametric);
        double d14 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            double d15 = (Double)arrayList.get(i);
            System.out.print(d15);
            d = ((AnalyticProductInterface)vector.get(i)).getValue(0.0, (AnalyticModelInterface)cloneable);
            System.out.print("\t" + d);
            CapletVolatilitiesParametric capletVolatilitiesParametric4 = new CapletVolatilitiesParametric("Caplet", null, 0.0, 0.0, 0.0, d15);
            AnalyticModelInterface analyticModelInterface = analyticModel.clone().addVolatilitySurfaces(capletVolatilitiesParametric4);
            double d16 = ((AnalyticProductInterface)vector.get(i)).getValue(0.0, analyticModelInterface);
            System.out.print("\t" + d16);
            System.out.println("\t" + (d - d16));
            d14 += (d - d16) * (d - d16);
        }
        d14 = Math.sqrt(d14 / (double)vector.size());
        System.out.println("RMS :" + d14);
        Assert.assertTrue((d14 < 0.1 ? 1 : 0) != 0);
        System.out.println(Arrays.toString(dArray));
        System.out.println("__________________________________________________________________________________________\n");
    }
}

