/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.ParameterTransformation;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.optimizer.SolverException;

public abstract class AbstractVolatilitySurfaceParametric
extends AbstractVolatilitySurface
implements ParameterObjectInterface {
    public AbstractVolatilitySurfaceParametric(String string, Calendar calendar) {
        super(string, calendar);
    }

    @Override
    public abstract AbstractVolatilitySurfaceParametric getCloneForParameter(double[] var1) throws CloneNotSupportedException;

    public AbstractVolatilitySurfaceParametric getCloneCalibrated(AnalyticModelInterface analyticModelInterface, Vector<AnalyticProductInterface> vector, List<Double> list, Map<String, Object> map) throws CalculationException, SolverException {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        Integer n = (Integer)map.get("maxIterations");
        Double d = (Double)map.get("accuracy");
        Double d2 = (Double)map.get("evaluationTime");
        int n2 = n != null ? n : 400;
        double d3 = d != null ? d : 1.0E-8;
        double d4 = d2 != null ? d2 : 0.0;
        AnalyticModelInterface analyticModelInterface2 = analyticModelInterface.addVolatilitySurfaces(this);
        ParameterTransformation parameterTransformation = new ParameterTransformation(){

            @Override
            public double[] getSolverParameter(double[] dArray) {
                double[] dArray2 = (double[])dArray.clone();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray2[i] = Math.log(dArray[i]);
                }
                return dArray2;
            }

            @Override
            public double[] getParameter(double[] dArray) {
                double[] dArray2 = (double[])dArray.clone();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray2[i] = Math.exp(dArray[i]);
                }
                return dArray2;
            }
        };
        Solver solver = new Solver(analyticModelInterface2, vector, list, parameterTransformation, d4, d3);
        HashSet<ParameterObjectInterface> hashSet = new HashSet<ParameterObjectInterface>();
        hashSet.add(this);
        AnalyticModelInterface analyticModelInterface3 = solver.getCalibratedModel(hashSet);
        double d5 = solver.getAccuracy();
        double d6 = solver.getIterations();
        return (AbstractVolatilitySurfaceParametric)analyticModelInterface3.getVolatilitySurface(this.getName());
    }
}

