/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.interpolation.RationalFunctionInterpolation;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;

public class Curve
extends AbstractCurve
implements Serializable,
Cloneable {
    private ArrayList<Point> points = new ArrayList();
    private ArrayList<Point> pointsBeingParameters = new ArrayList();
    private InterpolationMethod interpolationMethod = InterpolationMethod.CUBIC_SPLINE;
    private ExtrapolationMethod extrapolationMethod = ExtrapolationMethod.CONSTANT;
    private InterpolationEntity interpolationEntity = InterpolationEntity.LOG_OF_VALUE;
    private RationalFunctionInterpolation rationalFunctionInterpolation = null;
    private final Object rationalFunctionInterpolationLazyInitLock = new Object();
    private SoftReference<Map<Double, Double>> curveCacheReference = null;
    private static final long serialVersionUID = -4126228588123963885L;
    static NumberFormat formatterReal = NumberFormat.getInstance(Locale.US);

    public Curve(String string, Calendar calendar, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod, InterpolationEntity interpolationEntity, double[] dArray, double[] dArray2) {
        super(string, calendar);
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Length of times not equal to length of values.");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.addPoint(dArray[i], dArray2[i], false);
        }
    }

    protected Curve(String string, Calendar calendar, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod, InterpolationEntity interpolationEntity) {
        super(string, calendar);
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
    }

    private Curve(String string, Calendar calendar) {
        super(string, calendar);
    }

    @Override
    public double getValue(double d) {
        return this.getValue(null, d);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        Double d2;
        Map<Double, Double> map;
        Map<Double, Double> map2 = map = this.curveCacheReference != null ? this.curveCacheReference.get() : null;
        if (map == null) {
            map = new ConcurrentHashMap<Double, Double>();
            this.curveCacheReference = new SoftReference<Map<Double, Double>>(map);
        }
        if ((d2 = map.get(d)) != null) {
            return d2;
        }
        double d3 = this.valueFromInterpolationEntity(this.getInterpolationEntityValue(d), d);
        map.put(d, d3);
        return d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getInterpolationEntityValue(double d) {
        Object object = this.rationalFunctionInterpolationLazyInitLock;
        synchronized (object) {
            if (this.rationalFunctionInterpolation == null) {
                double[] dArray = new double[this.points.size()];
                double[] dArray2 = new double[this.points.size()];
                for (int i = 0; i < this.points.size(); ++i) {
                    dArray[i] = this.points.get((int)i).time;
                    dArray2[i] = this.points.get((int)i).value;
                }
                this.rationalFunctionInterpolation = new RationalFunctionInterpolation(dArray, dArray2, RationalFunctionInterpolation.InterpolationMethod.valueOf(this.interpolationMethod.toString()), RationalFunctionInterpolation.ExtrapolationMethod.valueOf(this.extrapolationMethod.toString()));
            }
        }
        return this.rationalFunctionInterpolation.getValue(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoint(double d, double d2, boolean bl) {
        Object object = this.rationalFunctionInterpolationLazyInitLock;
        synchronized (object) {
            if (this.interpolationEntity == InterpolationEntity.LOG_OF_VALUE_PER_TIME && d == 0.0) {
                if (d2 == 1.0 && !bl) {
                    return;
                }
                throw new IllegalArgumentException("The interpolation method LOG_OF_VALUE_PER_TIME does not allow to add a value at time = 0 other than 1.0 (received " + d2 + ").");
            }
            double d3 = this.interpolationEntityFromValue(d2, d);
            int n = this.getTimeIndex(d);
            if (n >= 0) {
                if (this.points.get((int)n).value == d3) {
                    return;
                }
                if (bl) {
                    return;
                }
                throw new RuntimeException("Trying to add a value for a time for which another value already exists.");
            }
            Point point = new Point(d, d3, bl);
            this.points.add(-n - 1, point);
            if (bl) {
                int n2 = this.getParameterIndex(d);
                if (n2 >= 0) {
                    new RuntimeException("Curve inconsistent.");
                }
                this.pointsBeingParameters.add(-n2 - 1, point);
            }
            this.rationalFunctionInterpolation = null;
            this.curveCacheReference = null;
        }
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public ExtrapolationMethod getExtrapolationMethod() {
        return this.extrapolationMethod;
    }

    public InterpolationEntity getInterpolationEntity() {
        return this.interpolationEntity;
    }

    protected int getTimeIndex(double d) {
        Point point = new Point(d, Double.NaN, false);
        return Collections.binarySearch(this.points, point);
    }

    protected int getParameterIndex(double d) {
        Point point = new Point(d, Double.NaN, false);
        return Collections.binarySearch(this.pointsBeingParameters, point);
    }

    @Override
    public double[] getParameter() {
        double[] dArray = new double[this.pointsBeingParameters.size()];
        for (int i = 0; i < this.pointsBeingParameters.size(); ++i) {
            dArray[i] = this.valueFromInterpolationEntity(this.pointsBeingParameters.get((int)i).value, this.pointsBeingParameters.get((int)i).time);
        }
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        throw new UnsupportedOperationException("This class is immutable. Use getCloneForParameter(double[]) instead.");
    }

    private void setParameterPrivate(double[] dArray) {
        for (int i = 0; i < this.pointsBeingParameters.size(); ++i) {
            this.pointsBeingParameters.get((int)i).value = this.interpolationEntityFromValue(dArray[i], this.pointsBeingParameters.get((int)i).time);
        }
        this.rationalFunctionInterpolation = null;
        this.curveCacheReference = null;
    }

    @Override
    public String toString() {
        String string = super.toString() + "\n";
        for (Point point : this.points) {
            string = string + point.time + "\t" + this.valueFromInterpolationEntity(point.value, point.time) + "\n";
        }
        return string;
    }

    private double interpolationEntityFromValue(double d, double d2) {
        switch (this.interpolationEntity) {
            default: {
                return d;
            }
            case LOG_OF_VALUE: {
                return Math.log(Math.max(d, 0.0));
            }
            case LOG_OF_VALUE_PER_TIME: 
        }
        if (d2 == 0.0) {
            throw new IllegalArgumentException("The interpolation method LOG_OF_VALUE_PER_TIME does not allow to add a value at time = 0.");
        }
        return Math.log(Math.max(d, 0.0)) / d2;
    }

    private double valueFromInterpolationEntity(double d, double d2) {
        switch (this.interpolationEntity) {
            default: {
                return d;
            }
            case LOG_OF_VALUE: {
                return Math.exp(d);
            }
            case LOG_OF_VALUE_PER_TIME: 
        }
        return Math.exp(d * d2);
    }

    @Override
    public Curve clone() throws CloneNotSupportedException {
        Curve curve = (Curve)super.clone();
        curve.points = new ArrayList();
        curve.pointsBeingParameters = new ArrayList();
        curve.rationalFunctionInterpolation = null;
        curve.curveCacheReference = null;
        for (Point point : this.points) {
            Point point2 = (Point)point.clone();
            curve.points.add(point2);
            if (!point.isParameter) continue;
            curve.pointsBeingParameters.add(point2);
        }
        return curve;
    }

    @Override
    public CurveInterface getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        if (Arrays.equals(dArray, this.getParameter())) {
            return this;
        }
        Curve curve = this.clone();
        curve.setParameterPrivate(dArray);
        return curve;
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        CurveBuilder curveBuilder = new CurveBuilder(this);
        return curveBuilder;
    }

    public static class CurveBuilder
    implements CurveBuilderInterface {
        private Curve curve = null;

        public CurveBuilder() {
            this.curve = new Curve(null, null);
        }

        public CurveBuilder(String string, Calendar calendar) {
            this.curve = new Curve(string, calendar);
        }

        public CurveBuilder(Curve curve) throws CloneNotSupportedException {
            this.curve = curve.clone();
        }

        @Override
        public CurveInterface build() throws CloneNotSupportedException {
            Curve curve = this.curve;
            this.curve = null;
            return curve;
        }

        public CurveBuilderInterface setInterpolationMethod(InterpolationMethod interpolationMethod) {
            this.curve.interpolationMethod = interpolationMethod;
            return this;
        }

        public CurveBuilderInterface setExtrapolationMethod(ExtrapolationMethod extrapolationMethod) {
            this.curve.extrapolationMethod = extrapolationMethod;
            return this;
        }

        public CurveBuilderInterface setInterpolationEntity(InterpolationEntity interpolationEntity) {
            this.curve.interpolationEntity = interpolationEntity;
            return this;
        }

        @Override
        public CurveBuilderInterface addPoint(double d, double d2, boolean bl) {
            this.curve.addPoint(d, d2, bl);
            return this;
        }
    }

    private static class Point
    implements Comparable<Point>,
    Serializable {
        private static final long serialVersionUID = 8857387999991917430L;
        public double time;
        public double value;
        public boolean isParameter;

        public Point(double d, double d2, boolean bl) {
            this.time = d;
            this.value = d2;
            this.isParameter = bl;
        }

        @Override
        public int compareTo(Point point) {
            if (this.time < point.time) {
                return -1;
            }
            if (this.time > point.time) {
                return 1;
            }
            return 0;
        }

        public Object clone() {
            return new Point(this.time, this.value, this.isParameter);
        }
    }

    public static enum InterpolationEntity {
        VALUE,
        LOG_OF_VALUE,
        LOG_OF_VALUE_PER_TIME;

    }

    public static enum ExtrapolationMethod {
        DEFAULT,
        CONSTANT,
        LINEAR;

    }

    public static enum InterpolationMethod {
        PIECEWISE_CONSTANT,
        PIECEWISE_CONSTANT_LEFTPOINT,
        PIECEWISE_CONSTANT_RIGHTPOINT,
        LINEAR,
        CUBIC_SPLINE,
        AKIMA,
        AKIMA_CONTINUOUS,
        HARMONIC_SPLINE,
        HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING;

    }
}

