/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import net.finmath.compatibility.java.util.function.DoubleUnaryOperator;
import net.finmath.integration.AbstractRealIntegral;
import net.finmath.integration.SimpsonRealIntegrator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpsonRealIntegratorTest {
    private AbstractRealIntegral integral;

    @Before
    public void setUp() {
        this.integral = new SimpsonRealIntegrator(1.0, 5.0, 100, true);
    }

    @Test
    public void testCos() {
        DoubleUnaryOperator doubleUnaryOperator = new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double d) {
                return Math.cos(d);
            }
        };
        DoubleUnaryOperator doubleUnaryOperator2 = new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double d) {
                return Math.sin(d);
            }
        };
        double d = this.integral.integrate(doubleUnaryOperator);
        double d2 = doubleUnaryOperator2.applyAsDouble(this.integral.getUpperBound()) - doubleUnaryOperator2.applyAsDouble(this.integral.getLowerBound());
        double d3 = d - d2;
        System.out.println("Result: " + d + ". \tError: " + d3);
        Assert.assertEquals((String)"Integreation error.", (double)0.0, (double)d3, (double)1.0E-7);
    }

    @Test
    public void testCubic() {
        DoubleUnaryOperator doubleUnaryOperator = new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double d) {
                return 2.0 * d * d - d;
            }
        };
        DoubleUnaryOperator doubleUnaryOperator2 = new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double d) {
                return 2.0 * d * d * d / 3.0 - d * d / 2.0;
            }
        };
        double d = this.integral.integrate(doubleUnaryOperator);
        double d2 = doubleUnaryOperator2.applyAsDouble(this.integral.getUpperBound()) - doubleUnaryOperator2.applyAsDouble(this.integral.getLowerBound());
        double d3 = d - d2;
        System.out.println("Result: " + d + ". \tError: " + d3);
        Assert.assertEquals((String)"Integreation error.", (double)0.0, (double)d3, (double)1.0E-13);
    }
}

