/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import net.finmath.compatibility.java.util.function.DoubleUnaryOperator;
import net.finmath.integration.AbstractRealIntegral;

public class SimpsonRealIntegrator
extends AbstractRealIntegral {
    private int numberOfEvaluationPoints;
    private boolean useParallelEvaluation = false;

    public SimpsonRealIntegrator(double d, double d2, int n, boolean bl) {
        super(d, d2);
        if (n < 3) {
            throw new IllegalArgumentException("Invalid numberOfEvaluationPoints.");
        }
        this.numberOfEvaluationPoints = n;
        this.useParallelEvaluation = bl;
    }

    public SimpsonRealIntegrator(double d, double d2, int n) {
        this(d, d2, n, false);
    }

    @Override
    public double integrate(DoubleUnaryOperator doubleUnaryOperator) {
        double d = this.getLowerBound();
        double d2 = this.getUpperBound();
        double d3 = d2 - d;
        int n = (int)((double)(this.numberOfEvaluationPoints - 1) / 2.0);
        double d4 = d3 / (double)n;
        double d5 = 0.5 * d4;
        double d6 = 0.0;
        for (int i = 1; i < n; ++i) {
            d6 += 2.0 * doubleUnaryOperator.applyAsDouble(d + (double)i * d4 + d5) + doubleUnaryOperator.applyAsDouble(d + (double)i * d4);
        }
        return (doubleUnaryOperator.applyAsDouble(d) + doubleUnaryOperator.applyAsDouble(d2) + 2.0 * (d6 += 2.0 * doubleUnaryOperator.applyAsDouble(d + d5))) / 6.0 * d4;
    }
}

