/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import java.util.Calendar;
import java.util.Date;
import net.finmath.functions.NormalDistribution;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.stochastic.RandomVariableInterface;
import org.apache.commons.math3.analysis.UnivariateFunction;

public class AnalyticFormulas {
    private AnalyticFormulas() {
    }

    public static double blackScholesGeneralizedOptionValue(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            return (d - d4) * d5 + AnalyticFormulas.blackScholesGeneralizedOptionValue(-d, d2, d3, -d4, d5);
        }
        if (d == 0.0 || d4 <= 0.0 || d2 <= 0.0 || d3 <= 0.0) {
            return Math.max(d - d4, 0.0) * d5;
        }
        double d6 = (Math.log(d / d4) + 0.5 * d2 * d2 * d3) / (d2 * Math.sqrt(d3));
        double d7 = d6 - d2 * Math.sqrt(d3);
        double d8 = (d * NormalDistribution.cumulativeDistribution(d6) - d4 * NormalDistribution.cumulativeDistribution(d7)) * d5;
        return d8;
    }

    public static RandomVariableInterface blackScholesGeneralizedOptionValue(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, double d, double d2, RandomVariableInterface randomVariableInterface3) {
        if (d < 0.0) {
            return randomVariableInterface.mult(0.0);
        }
        RandomVariableInterface randomVariableInterface4 = randomVariableInterface.div(d2).log().add(randomVariableInterface2.squared().mult(0.5 * d)).div(randomVariableInterface2).div(Math.sqrt(d));
        RandomVariableInterface randomVariableInterface5 = randomVariableInterface4.sub(randomVariableInterface2.mult(Math.sqrt(d)));
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            public double value(double d) {
                return NormalDistribution.cumulativeDistribution(d);
            }
        };
        RandomVariableInterface randomVariableInterface6 = randomVariableInterface4.apply(univariateFunction).mult(randomVariableInterface).sub(randomVariableInterface5.apply(univariateFunction).mult(d2)).mult(randomVariableInterface3);
        return randomVariableInterface6;
    }

    public static double blackScholesOptionValue(double d, double d2, double d3, double d4, double d5) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(d * Math.exp(d2 * d4), d3, d4, d5, Math.exp(-d2 * d4));
    }

    public static double blackScholesATMOptionValue(double d, double d2, double d3, double d4) {
        if (d2 < 0.0) {
            return 0.0;
        }
        double d5 = 0.5 * d * Math.sqrt(d2);
        double d6 = -d5;
        double d7 = (NormalDistribution.cumulativeDistribution(d5) - NormalDistribution.cumulativeDistribution(d6)) * d3 * d4;
        return d7;
    }

    public static double blackScholesOptionDelta(double d, double d2, double d3, double d4, double d5) {
        if (d4 < 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            return 1.0 - AnalyticFormulas.blackScholesOptionDelta(-d, d2, d3, d4, -d5);
        }
        if (d == 0.0) {
            if (d5 < 0.0) {
                return 1.0;
            }
            if (d5 > 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        if (d5 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
            return 1.0;
        }
        double d6 = (Math.log(d / d5) + (d2 + 0.5 * d3 * d3) * d4) / (d3 * Math.sqrt(d4));
        double d7 = NormalDistribution.cumulativeDistribution(d6);
        return d7;
    }

    public static RandomVariableInterface blackScholesOptionDelta(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, RandomVariableInterface randomVariableInterface3, double d, double d2) {
        if (d < 0.0) {
            return randomVariableInterface.mult(0.0);
        }
        RandomVariableInterface randomVariableInterface4 = randomVariableInterface.div(d2).log().add(randomVariableInterface3.squared().mult(0.5).add(randomVariableInterface2).mult(d)).div(randomVariableInterface3).div(Math.sqrt(d));
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            public double value(double d) {
                return NormalDistribution.cumulativeDistribution(d);
            }
        };
        RandomVariableInterface randomVariableInterface5 = randomVariableInterface4.apply(univariateFunction);
        return randomVariableInterface5;
    }

    public static RandomVariableInterface blackScholesOptionDelta(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, RandomVariableInterface randomVariableInterface3, double d, RandomVariableInterface randomVariableInterface4) {
        if (d < 0.0) {
            return randomVariableInterface.mult(0.0);
        }
        RandomVariableInterface randomVariableInterface5 = randomVariableInterface.div(randomVariableInterface4).log().add(randomVariableInterface3.squared().mult(0.5).add(randomVariableInterface2).mult(d)).div(randomVariableInterface3).div(Math.sqrt(d));
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            public double value(double d) {
                return NormalDistribution.cumulativeDistribution(d);
            }
        };
        RandomVariableInterface randomVariableInterface6 = randomVariableInterface5.apply(univariateFunction);
        return randomVariableInterface6;
    }

    public static double blackScholesOptionGamma(double d, double d2, double d3, double d4, double d5) {
        if (d5 <= 0.0 || d4 <= 0.0) {
            return 0.0;
        }
        double d6 = (Math.log(d / d5) + (d2 + 0.5 * d3 * d3) * d4) / (d3 * Math.sqrt(d4));
        double d7 = Math.exp(-0.5 * d6 * d6) / (Math.sqrt(Math.PI * 2 * d4) * d * d3);
        return d7;
    }

    public static RandomVariableInterface blackScholesOptionGamma(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, RandomVariableInterface randomVariableInterface3, double d, double d2) {
        if (d2 <= 0.0 || d <= 0.0) {
            return randomVariableInterface.mult(0.0);
        }
        RandomVariableInterface randomVariableInterface4 = randomVariableInterface.div(d2).log().add(randomVariableInterface3.squared().mult(0.5).add(randomVariableInterface2).mult(d)).div(randomVariableInterface3).div(Math.sqrt(d));
        RandomVariableInterface randomVariableInterface5 = randomVariableInterface4.squared().mult(-0.5).exp().div(randomVariableInterface.mult(randomVariableInterface3).mult(Math.sqrt(Math.PI * 2 * d)));
        return randomVariableInterface5;
    }

    public static double blackScholesOptionVega(double d, double d2, double d3, double d4, double d5) {
        if (d5 <= 0.0 || d4 <= 0.0) {
            return 0.0;
        }
        double d6 = (Math.log(d / d5) + (d2 + 0.5 * d3 * d3) * d4) / (d3 * Math.sqrt(d4));
        double d7 = Math.exp(-0.5 * d6 * d6) / Math.sqrt(Math.PI * 2) * d * Math.sqrt(d4);
        return d7;
    }

    public static double blackScholesOptionRho(double d, double d2, double d3, double d4, double d5) {
        if (d5 <= 0.0 || d4 <= 0.0) {
            return 0.0;
        }
        double d6 = (Math.log(d / d5) + (d2 - 0.5 * d3 * d3) * d4) / (d3 * Math.sqrt(d4));
        double d7 = d5 * d4 * Math.exp(-d2 * d4) * NormalDistribution.cumulativeDistribution(d6);
        return d7;
    }

    public static double blackScholesOptionImpliedVolatility(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        int n = 500;
        double d8 = 1.0E-15;
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d9 = NormalDistribution.inverseCumulativeDistribution((d5 / d4 + d3) / (d + d3)) / Math.sqrt(d2);
        double d10 = d9 + Math.sqrt(Math.max(d9 * d9 - (d7 = 2.0 * Math.abs(Math.log(d / d3)) / d2), 0.0));
        if (Math.abs(d10 - (d6 = d9 + Math.sqrt(d9 * d9 + d7))) < d8) {
            return (d10 + d6) / 2.0;
        }
        NewtonsMethod newtonsMethod = new NewtonsMethod(0.5 * (d10 + d6));
        while (newtonsMethod.getAccuracy() > d8 && !newtonsMethod.isDone() && newtonsMethod.getNumberOfIterations() < n) {
            double d11 = newtonsMethod.getNextPoint();
            double d12 = (Math.log(d / d3) + 0.5 * d11 * d11 * d2) / (d11 * Math.sqrt(d2));
            double d13 = d12 - d11 * Math.sqrt(d2);
            double d14 = (d * NormalDistribution.cumulativeDistribution(d12) - d3 * NormalDistribution.cumulativeDistribution(d13)) * d4;
            double d15 = d * Math.sqrt(d2) * Math.exp(-0.5 * d12 * d12) / Math.sqrt(Math.PI * 2) * d4;
            double d16 = d14 - d5;
            newtonsMethod.setValueAndDerivative(d16, d15);
        }
        return newtonsMethod.getBestPoint();
    }

    public static double blackScholesDigitalOptionValue(double d, double d2, double d3, double d4, double d5) {
        if (d5 <= 0.0) {
            return 1.0;
        }
        double d6 = (Math.log(d / d5) + (d2 + 0.5 * d3 * d3) * d4) / (d3 * Math.sqrt(d4));
        double d7 = d6 - d3 * Math.sqrt(d4);
        double d8 = Math.exp(-d2 * d4) * NormalDistribution.cumulativeDistribution(d7);
        return d8;
    }

    public static double blackScholesDigitalOptionDelta(double d, double d2, double d3, double d4, double d5) {
        if (d5 <= 0.0 || d4 <= 0.0) {
            return 0.0;
        }
        double d6 = (Math.log(d / d5) + (d2 + 0.5 * d3 * d3) * d4) / (d3 * Math.sqrt(d4));
        double d7 = d6 - d3 * Math.sqrt(d4);
        double d8 = Math.exp(-0.5 * d7 * d7) / (Math.sqrt(Math.PI * 2 * d4) * d * d3);
        return d8;
    }

    public static double blackModelCapletValue(double d, double d2, double d3, double d4, double d5, double d6) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(d, d2, d3, d4, d5 * d6);
    }

    public static double blackModelDgitialCapletValue(double d, double d2, double d3, double d4, double d5, double d6) {
        return AnalyticFormulas.blackScholesDigitalOptionValue(d, 0.0, d2, d5, d6) * d3 * d4;
    }

    public static double blackModelSwaptionValue(double d, double d2, double d3, double d4, double d5) {
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(d, d2, d3, d4, d5);
    }

    public static double margrabeExchangeOptionValue(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(d3 * d3 + d4 * d4 - 2.0 * d3 * d4 * d5);
        return AnalyticFormulas.blackScholesGeneralizedOptionValue(d, d7, d6, d2, 1.0);
    }

    public static double bachelierOptionValue(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            return 0.0;
        }
        double d6 = (d - d4) / (d2 * Math.sqrt(d3));
        double d7 = ((d - d4) * NormalDistribution.cumulativeDistribution(d6) + d2 * Math.sqrt(d3) * NormalDistribution.density(d6)) * d5;
        return d7;
    }

    public static RandomVariableInterface bachelierOptionValue(RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2, double d, double d2, RandomVariableInterface randomVariableInterface3) {
        if (d < 0.0) {
            return randomVariableInterface.mult(0.0);
        }
        RandomVariableInterface randomVariableInterface4 = randomVariableInterface2.mult(Math.sqrt(d));
        RandomVariableInterface randomVariableInterface5 = randomVariableInterface.sub(d2).div(randomVariableInterface4);
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            public double value(double d) {
                return NormalDistribution.cumulativeDistribution(d);
            }
        };
        UnivariateFunction univariateFunction2 = new UnivariateFunction(){

            public double value(double d) {
                return NormalDistribution.density(d);
            }
        };
        RandomVariableInterface randomVariableInterface6 = randomVariableInterface5.apply(univariateFunction).mult(randomVariableInterface.sub(d2)).add(randomVariableInterface5.apply(univariateFunction2).mult(randomVariableInterface4)).mult(randomVariableInterface3);
        return randomVariableInterface6;
    }

    public static double bachelierOptionImpliedVolatility(double d, double d2, double d3, double d4, double d5) {
        int n = 100;
        double d6 = 0.0;
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d7 = 0.0;
        double d8 = (d5 + Math.abs(d - d3)) / Math.sqrt(d2) / d4;
        d8 /= Math.min(1.0, NormalDistribution.density((d - d3) / (d8 * Math.sqrt(d2))));
        GoldenSectionSearch goldenSectionSearch = new GoldenSectionSearch(d7, d8);
        while (goldenSectionSearch.getAccuracy() > d6 && !goldenSectionSearch.isDone() && goldenSectionSearch.getNumberOfIterations() < n) {
            double d9 = goldenSectionSearch.getNextPoint();
            double d10 = AnalyticFormulas.bachelierOptionValue(d, d9, d2, d3, d4);
            double d11 = d10 - d5;
            goldenSectionSearch.setValue(d11 * d11);
        }
        return goldenSectionSearch.getBestPoint();
    }

    public static double huntKennedyCMSOptionValue(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = 1.0 / d5;
        double d9 = (d6 / d3 - d8) / d;
        double d10 = Math.exp(d2 * d2 * d4);
        double d11 = AnalyticFormulas.blackModelSwaptionValue(d, d2, d4, d7, d3);
        double d12 = AnalyticFormulas.blackModelSwaptionValue(d * d10, d2, d4, d7, d3);
        return d8 * d11 + d9 * d * d12;
    }

    public static double huntKennedyCMSFloorValue(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = AnalyticFormulas.huntKennedyCMSOptionValue(d, d2, d3, d4, d5, d6, d7);
        return d8 + d7 * d6;
    }

    public static double huntKennedyCMSAdjustedRate(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 1.0 / d5;
        double d8 = (d6 / d3 - d7) / d;
        double d9 = Math.exp(d2 * d2 * d4);
        double d10 = d;
        double d11 = d * d9;
        return (d7 * d10 + d8 * d * d11) * d3 / d6;
    }

    public static double price(Date date, Date date2, double d, double d2, double d3, int n) {
        double d4 = 0.0;
        if (date2.after(date)) {
            d4 += d3;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        while (calendar.after(date)) {
            d4 += d;
            d4 /= 1.0 + d2 / (double)n;
            calendar.add(2, -12 / n);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(2, 12 / n);
        double d5 = (calendar.getTimeInMillis() - date.getTime()) / (calendar2.getTimeInMillis() - calendar.getTimeInMillis());
        d4 *= Math.pow(1.0 + d2 / (double)n, d5);
        return d4 -= d * d5;
    }

    public static double price(double d, double d2, double d3, double d4, int n) {
        double d5;
        double d6 = 0.0;
        if (d > 0.0) {
            d6 += d4;
        }
        for (d5 = d; d5 > 0.0; d5 -= 1.0 / (double)n) {
            d6 += d2;
            d6 /= 1.0 + d3 / (double)n;
        }
        double d7 = 0.0 - d5;
        d6 *= Math.pow(1.0 + d3 / (double)n, d7);
        return d6 -= d2 * d7;
    }
}

