/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import net.finmath.fouriermethod.CharacteristicFunctionInterface;
import net.finmath.fouriermethod.models.ProcessCharacteristicFunctionInterface;
import org.apache.commons.math3.complex.Complex;

public class BlackScholesModel
implements ProcessCharacteristicFunctionInterface {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;

    public BlackScholesModel(double d, double d2, double d3) {
        this.initialValue = d;
        this.riskFreeRate = d2;
        this.volatility = d3;
    }

    @Override
    public CharacteristicFunctionInterface apply(final double d) {
        return new CharacteristicFunctionInterface(){

            @Override
            public Complex apply(Complex complex) {
                Complex complex2 = complex.multiply(Complex.I);
                return complex2.multiply(complex2.multiply(0.5 * BlackScholesModel.this.volatility * BlackScholesModel.this.volatility * d).add(Math.log(BlackScholesModel.this.initialValue) - 0.5 * BlackScholesModel.this.volatility * BlackScholesModel.this.volatility * d + BlackScholesModel.this.riskFreeRate * d)).add(-BlackScholesModel.this.riskFreeRate * d).exp();
            }
        };
    }
}

