/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.line;

import java.util.ArrayList;
import java.util.Collection;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.curve.ContinuousCurve3D;
import math.geom3d.curve.Curve3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.transform.AffineTransform3D;

public class LineSegment3D
implements ContinuousCurve3D {
    protected double x1 = 0.0;
    protected double y1 = 0.0;
    protected double z1 = 0.0;
    protected double x2 = 1.0;
    protected double y2 = 0.0;
    protected double z2 = 0.0;

    public LineSegment3D(Point3D p1, Point3D p2) {
        this.x1 = p1.getX();
        this.y1 = p1.getY();
        this.z1 = p1.getZ();
        this.x2 = p2.getX();
        this.y2 = p2.getY();
        this.z2 = p2.getZ();
    }

    public StraightLine3D supportingLine() {
        return new StraightLine3D(this.x1, this.y1, this.z1, this.x2 - this.x1, this.y2 - this.y1, this.z2 - this.z1);
    }

    public Collection<LineSegment3D> continuousCurves() {
        ArrayList<LineSegment3D> array = new ArrayList<LineSegment3D>(1);
        array.add(this);
        return array;
    }

    @Override
    public Point3D firstPoint() {
        return new Point3D(this.x1, this.y1, this.z1);
    }

    @Override
    public Point3D lastPoint() {
        return new Point3D(this.x2, this.y2, this.z2);
    }

    @Override
    public Point3D point(double t) {
        t = Math.max(Math.min(t, 1.0), 0.0);
        return new Point3D(this.x1 + (this.x2 - this.x1) * t, this.y1 + (this.y2 - this.y1) * t, this.z1 + (this.z2 - this.z1) * t);
    }

    @Override
    public double position(Point3D point) {
        double t = this.supportingLine().position(point);
        if (t > 1.0) {
            return Double.NaN;
        }
        if (t < 0.0) {
            return Double.NaN;
        }
        return t;
    }

    @Override
    public Curve3D reverseCurve() {
        return new StraightLine3D(this.lastPoint(), this.firstPoint());
    }

    @Override
    public Collection<Point3D> singularPoints() {
        ArrayList<Point3D> points = new ArrayList<Point3D>(2);
        points.add(this.firstPoint());
        points.add(this.lastPoint());
        return points;
    }

    @Override
    public LineSegment3D subCurve(double t0, double t1) {
        t0 = Math.max(t0, 0.0);
        t1 = Math.min(t1, 1.0);
        return new LineSegment3D(this.point(t0), this.point(t1));
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return 1.0;
    }

    @Override
    public double project(Point3D point) {
        double t = this.supportingLine().project(point);
        return Math.min(Math.max(t, 0.0), 1.0);
    }

    @Override
    public Curve3D transform(AffineTransform3D trans) {
        return new LineSegment3D(new Point3D(this.x1, this.y1, this.z1).transform(trans), new Point3D(this.x2, this.y2, this.z2).transform(trans));
    }

    @Override
    public Shape3D clip(Box3D box) {
        return null;
    }

    @Override
    public boolean contains(Point3D point) {
        StraightLine3D line = this.supportingLine();
        if (!line.contains(point)) {
            return false;
        }
        double t = line.position(point);
        if (t < -1.0E-12) {
            return false;
        }
        return !(t > 1.000000000001);
    }

    @Override
    public Box3D boundingBox() {
        return new Box3D(this.x1, this.x2, this.y1, this.y2, this.z1, this.z2);
    }

    @Override
    public double distance(Point3D point) {
        double t = this.project(point);
        return this.point(t).distance(point);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

