/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.point;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import math.geom2d.Point2D;

public class PointSets2D {
    public static <T extends Point2D> boolean hasMultipleVertices(List<T> points) {
        return PointSets2D.hasMultipleVertices(points, false);
    }

    public static <T extends Point2D> boolean hasMultipleVertices(List<T> points, boolean closed) {
        Iterator<T> iter = points.iterator();
        Point2D previous = null;
        previous = closed ? (Point2D)points.get(points.size() - 1) : (Point2D)iter.next();
        while (iter.hasNext()) {
            Point2D current = (Point2D)iter.next();
            if (Point2D.distance(current, previous) < 1.0E-12) {
                return true;
            }
            previous = current;
        }
        return false;
    }

    public static <T extends Point2D> int countMultipleVertices(List<T> points) {
        return PointSets2D.countMultipleVertices(points, false);
    }

    public static <T extends Point2D> int countMultipleVertices(List<T> points, boolean closed) {
        int count = 0;
        Iterator<T> iter = points.iterator();
        Point2D previous = null;
        previous = closed ? (Point2D)points.get(points.size() - 1) : (Point2D)iter.next();
        while (iter.hasNext()) {
            Point2D current = (Point2D)iter.next();
            if (Point2D.distance(current, previous) < 1.0E-12) {
                ++count;
            }
            previous = current;
        }
        return count;
    }

    public static <T extends Point2D> List<T> filterMultipleVertices(List<T> vertices) {
        return PointSets2D.filterMultipleVertices(vertices, false);
    }

    public static <T extends Point2D> List<T> filterMultipleVertices(List<T> vertices, boolean closed) {
        int size = vertices.size();
        int nMulti = PointSets2D.countMultipleVertices(vertices, closed);
        ArrayList<Point2D> result = new ArrayList<Point2D>(size - nMulti);
        if (size == 0) {
            return result;
        }
        Iterator<T> iter = vertices.iterator();
        Point2D previous = null;
        if (closed) {
            previous = (Point2D)vertices.get(size - 1);
        } else {
            previous = (Point2D)iter.next();
            result.add(previous);
        }
        while (iter.hasNext()) {
            Point2D current = (Point2D)iter.next();
            if (Point2D.distance(current, previous) > 1.0E-12) {
                result.add(current);
            }
            previous = current;
        }
        return result;
    }
}

