/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.Vector2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.Ray2D;
import math.utils.EqualUtils;

public class InvertedRay2D
extends AbstractLine2D
implements Cloneable {
    @Deprecated
    public static InvertedRay2D create(Point2D target, Vector2D direction) {
        return new InvertedRay2D(target, direction);
    }

    public InvertedRay2D() {
        this(0.0, 0.0, 1.0, 0.0);
    }

    public InvertedRay2D(Point2D point1, Point2D point2) {
        this(point1.x(), point1.y(), point2.x() - point1.x(), point2.y() - point1.y());
    }

    public InvertedRay2D(double x1, double y1, double dx, double dy) {
        super(x1, y1, dx, dy);
    }

    public InvertedRay2D(Point2D point, double dx, double dy) {
        this(point.x(), point.y(), dx, dy);
    }

    public InvertedRay2D(Point2D point, Vector2D vector) {
        this(point.x(), point.y(), vector.x(), vector.y());
    }

    public InvertedRay2D(Point2D point, double angle) {
        this(point.x(), point.y(), Math.cos(angle), Math.sin(angle));
    }

    public InvertedRay2D(double x, double y, double angle) {
        this(x, y, Math.cos(angle), Math.sin(angle));
    }

    public InvertedRay2D(LinearShape2D line) {
        super(line.origin(), line.direction());
    }

    @Override
    public InvertedRay2D parallel(double d) {
        double dd = Math.hypot(this.dx, this.dy);
        return new InvertedRay2D(this.x0 + this.dy * d / dd, this.y0 - this.dx * d / dd, this.dx, this.dy);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        throw new UnboundedShape2DException(this);
    }

    public GeneralPath getGeneralPath() {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Point2D point(double t) {
        t = Math.min(t, 0.0);
        return new Point2D(this.x0 + t * this.dx, this.y0 + t * this.dy);
    }

    @Override
    public double t0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Ray2D reverse() {
        return new Ray2D(this.x0, this.y0, -this.dx, -this.dy);
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        if (!this.supportContains(x, y)) {
            return false;
        }
        double t = this.positionOnLine(x, y);
        return t < 1.0E-12;
    }

    @Override
    public Box2D boundingBox() {
        double t = Double.NEGATIVE_INFINITY;
        Point2D p0 = new Point2D(this.x0, this.y0);
        Point2D p1 = new Point2D(t * this.dx, t * this.dy);
        return new Box2D(p0, p1);
    }

    @Override
    public InvertedRay2D transform(AffineTransform2D trans) {
        double[] tab = trans.coefficients();
        double x1 = this.x0 * tab[0] + this.y0 * tab[1] + tab[2];
        double y1 = this.x0 * tab[3] + this.y0 * tab[4] + tab[5];
        return new InvertedRay2D(x1, y1, this.dx * tab[0] + this.dy * tab[1], this.dx * tab[3] + this.dy * tab[4]);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvertedRay2D)) {
            return false;
        }
        InvertedRay2D ray = (InvertedRay2D)obj;
        if (Math.abs(this.x0 - ray.x0) > eps) {
            return false;
        }
        if (Math.abs(this.y0 - ray.y0) > eps) {
            return false;
        }
        if (Math.abs(this.dx - ray.dx) > eps) {
            return false;
        }
        return !(Math.abs(this.dy - ray.dy) > eps);
    }

    public String toString() {
        return new String("InvertedRay2D(" + this.x0 + "," + this.y0 + "," + this.dx + "," + this.dy + ")");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvertedRay2D)) {
            return false;
        }
        InvertedRay2D that = (InvertedRay2D)obj;
        if (!EqualUtils.areEqual(this.x0, that.x0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.y0, that.y0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.dx, that.dx)) {
            return false;
        }
        return EqualUtils.areEqual(this.dy, that.dy);
    }

    @Override
    @Deprecated
    public InvertedRay2D clone() {
        return new InvertedRay2D(this.x0, this.y0, this.dx, this.dy);
    }
}

