/*
 * Decompiled with CFR 0.152.
 */
package jhpro.tseries;

public class Peak
implements Comparable {
    private double position;
    private double area;
    private double width;
    private double perr;
    private double aerr;
    private double werr;

    public Peak(double position, double area, double width) {
        this(position, 0.0, area, 0.0, width, 0.0);
    }

    public Peak(double p, double pe, double a, double ae, double w, double we) {
        this.setPosition(p, pe);
        this.setArea(a, ae);
        this.setWidth(w, we);
    }

    public double getPosition() {
        return this.position;
    }

    public double getArea() {
        return this.area;
    }

    public double getWidth() {
        return this.width;
    }

    public double getPositionError() {
        return this.perr;
    }

    public double getAreaError() {
        return this.aerr;
    }

    public double getWidthError() {
        return this.werr;
    }

    public void setPosition(double p) {
        this.setPosition(p, 0.0);
    }

    public void setPosition(double p, double e) {
        this.position = p;
        this.perr = e;
    }

    public void setArea(double a) {
        this.setArea(a, 0.0);
    }

    public void setArea(double a, double e) {
        this.area = a;
        this.aerr = e;
    }

    public void setWidth(double w) {
        this.setWidth(w, 0.0);
    }

    public void setWidth(double w, double e) {
        this.width = w;
        this.werr = e;
    }

    public String toString() {
        String rval = "Peak\n";
        rval = rval + "  Position = " + this.position + " +/- " + this.perr + "\n";
        rval = rval + "  Area = " + this.area + " +/- " + this.aerr + "\n";
        rval = rval + "  FWHM = " + this.width + " +/- " + this.werr + "\n";
        return rval;
    }

    public int compareTo(Object p1) {
        if (this.getPosition() < ((Peak)p1).getPosition()) {
            return -1;
        }
        if (this.getPosition() > ((Peak)p1).getPosition()) {
            return 1;
        }
        return 0;
    }
}

