/*
 * Decompiled with CFR 0.152.
 */
package jhpro.tseries;

import jhplot.F1D;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.utils.SHisto;
import jhpro.stat.StatUtils;
import jhpro.tseries.GaussianFilter;
import jhpro.tseries.HStatData;
import jhpro.tseries.PeakFinder;

public class HStatAnalysis {
    private HStatData hdata;

    public HStatAnalysis(HStatData hdata) {
        this.hdata = hdata;
    }

    public P0D autoCorrelation(int column, int windowlength) {
        double[] s = this.hdata.getColumn(column);
        double[] d = StatUtils.autoCorrelate(s, windowlength, 0);
        return new P0D(this.hdata.getDescription(), d);
    }

    public P0D crossCorrelation(int column1, int column2, int N, int startLag, int endLag) {
        double[] x = this.hdata.getColumn(column1);
        double[] y = this.hdata.getColumn(column2);
        double[] d = StatUtils.crossCorrelation(x, y, N, startLag, endLag);
        return new P0D(this.hdata.getDescription(), d);
    }

    public P0D filterGaussian(int column, double width) {
        double[] x = this.hdata.getColumn(column);
        GaussianFilter g = new GaussianFilter(x, width);
        double[] y = g.getFilteredSpectrum();
        return new P0D(this.hdata.getDescription(), y);
    }

    public P0D peakFinder(int column, double sensitivity, double width) {
        double[] x = this.hdata.getColumn(column);
        PeakFinder pp = new PeakFinder("Peaks", x, sensitivity, width);
        double[] y = pp.getCentroids();
        return new P0D("Centroids", y);
    }

    public void transformColumn(int column, String function) {
        F1D f = new F1D(function);
        double[] x = f.eval(this.hdata.getData().getCol(column));
        for (int j = 0; j < this.hdata.getData().rows(); ++j) {
            this.hdata.getData().setValAt(x[j], j, column);
        }
    }

    public void smoothColumn(int column, boolean isWeighted, int k) {
        SHisto sh = new SHisto(this.hdata.getData().rows(), 0.0, this.hdata.getData().rows(), 1);
        double[] hh = this.hdata.getData().getCol(column);
        sh.setBins(hh);
        sh = sh.getSmoothed(isWeighted, k);
        for (int j = 0; j < this.hdata.getData().rows(); ++j) {
            this.hdata.getData().setValAt(sh.getBinsFirstBand(j), j, column);
        }
    }

    public H1D getH1D(int column, int nbins, double min, double max) {
        H1D h1 = new H1D(this.hdata.getDescription(), nbins, min, max);
        double[] hh = this.hdata.getData().getCol(column);
        h1.fill(hh);
        return h1;
    }
}

