/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class StatUtils {
    private static Random _random;

    public static double[] autoCorrelate(double[] signal, int windowlength, int windowshift) {
        int signallenth = signal.length;
        if (signallenth < windowlength + windowshift) {
            return null;
        }
        double[] autocorrelation = new double[windowlength];
        for (int lag = 0; lag < windowlength; ++lag) {
            for (int n = 0; n < windowshift; ++n) {
                int n2 = lag;
                autocorrelation[n2] = autocorrelation[n2] + signal[n] * signal[n + lag];
            }
        }
        return autocorrelation;
    }

    public static double avg(double[] v) {
        return (float)(StatUtils.sum(v) / (double)v.length);
    }

    public static double sum(float[] v) {
        double aggr = 0.0;
        for (int j = 0; j < v.length; ++j) {
            aggr += (double)v[j];
        }
        return aggr;
    }

    public static double sum(float[][] m) {
        double aggr = 0.0;
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                aggr += (double)m[j][i];
            }
        }
        return aggr;
    }

    public static double sum(float[] v, float[] mask) {
        double agr = 0.0;
        for (int j = 0; j < v.length; ++j) {
            if (mask[j] == 0.0f) continue;
            agr += (double)v[j];
        }
        return agr;
    }

    public static double sum(double[] v) {
        double aggr = 0.0;
        for (int j = 0; j < v.length; ++j) {
            aggr += v[j];
        }
        return aggr;
    }

    public static double stdev(double[] v) {
        float stdev = (float)FastMath.sqrt((double)StatUtils.var(v));
        return stdev;
    }

    public static double correl(double[] a, double[] b) {
        int iN = FastMath.min((int)a.length, (int)b.length);
        double avga = StatUtils.avg(a);
        double avgb = StatUtils.avg(b);
        double agr = 0.0;
        double vara = 0.0;
        double varb = 0.0;
        for (int i = 0; i < iN; ++i) {
            agr += (a[i] - avga) * (b[i] - avgb);
            vara += FastMath.pow((double)(a[i] - avga), (int)2);
            varb += FastMath.pow((double)(b[i] - avgb), (int)2);
        }
        double r = vara == 0.0 || varb == 0.0 ? 0.0 : agr / FastMath.sqrt((double)(vara * varb));
        if (Double.isNaN(r)) {
            System.out.println("NAN->" + agr + " " + vara + " " + varb);
        }
        return (float)r;
    }

    public static double var(double[] v) {
        double avg = StatUtils.avg(v);
        double var = 0.0;
        double eps = 0.0;
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            double d = v[j] - avg;
            eps += d;
            var += d * d;
            ++n;
        }
        var = (var - eps * eps / (double)n) / (double)(n - 1);
        return var;
    }

    public static float[] residuals(float[] a, float[] b) throws IllegalArgumentException {
        float[] res = new float[FastMath.min((int)a.length, (int)b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = b[i] - a[i];
        }
        return res;
    }

    public static double[] autocov(double[] data, int maxk) {
        double[] ac = new double[maxk];
        data = StatUtils.zeromean(data);
        data = StatUtils.linearcorrect(data);
        double mu = StatUtils.avg(data);
        for (int k = 0; k < maxk; ++k) {
            for (int t = 0; t < data.length - k; ++t) {
                int n = k;
                ac[n] = ac[n] + (data[t] - mu) * (data[t + k] - mu);
            }
            int n = k;
            ac[n] = ac[n] / (double)(data.length - k);
        }
        return ac;
    }

    protected static double[] linearcorrect(double[] data) {
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxy = 0.0;
        double sumxx = 0.0;
        double sumyy = 0.0;
        for (int k = 0; k < data.length; ++k) {
            sumx += (double)k;
            sumy += data[k];
            sumxx += (double)(k * k);
            sumyy += data[k] * data[k];
            sumxy += data[k] * (double)k;
        }
        double Sxx = sumxx - sumx * sumx / (double)data.length;
        double yy = sumyy - sumy * sumy / (double)data.length;
        double Sxy = sumxy - sumx * sumy / (double)data.length;
        double b = Sxy / Sxx;
        double a = (sumy - b * sumx) / (double)data.length;
        for (int k = 0; k < data.length; ++k) {
            data[k] = data[k] - b * (double)k;
        }
        return data;
    }

    public static double[] autocorr(double[] data, int maxk) {
        double[] acov = StatUtils.autocov(data, maxk);
        double[] acorr = new double[acov.length];
        for (int k = 0; k < acov.length; ++k) {
            acorr[k] = acov[k] / acov[0];
        }
        return acorr;
    }

    public static double[] zeromean(double[] v) {
        double[] n = new double[v.length];
        double avg = StatUtils.sum(v) / (double)v.length;
        for (int j = 0; j < v.length; ++j) {
            n[j] = v[j] - avg;
        }
        return n;
    }

    public static final double[] crossCorrelation(double[] x, double[] y, int N, int startLag, int endLag) {
        int outputLength = endLag - startLag + 1;
        double[] returnValue = new double[outputLength];
        for (int lag = startLag; lag <= endLag; ++lag) {
            int start = FastMath.max((int)0, (int)(-lag));
            int limit = FastMath.min((int)x.length, (int)N);
            limit = FastMath.min((int)limit, (int)(y.length - lag));
            double sum = 0.0;
            for (int i = start; i < limit; ++i) {
                sum += x[i] * y[i + lag];
            }
            returnValue[lag - startLag] = sum;
        }
        return returnValue;
    }

    public static double crossCorrelationAt(double[] x, double[] y, int N, int lag) {
        int start = FastMath.max((int)0, (int)(-lag));
        int limit = FastMath.min((int)x.length, (int)N);
        limit = FastMath.min((int)limit, (int)(y.length - lag));
        double sum = 0.0;
        for (int i = start; i < limit; ++i) {
            sum += x[i] * y[i + lag];
        }
        return sum;
    }

    public static final double[] randomBernoulli(double p, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            returnValue[i] = _random.nextDouble() < p ? 1.0 : 0.0;
        }
        return returnValue;
    }

    public static final double[] randomExponential(double lambda, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            double r;
            while ((r = _random.nextDouble()) == 0.0) {
            }
            returnValue[i] = -FastMath.log((double)r) / lambda;
        }
        return returnValue;
    }

    public static final double[] randomGaussian(double mean, double standardDeviation, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            returnValue[i] = mean + _random.nextGaussian() * standardDeviation;
        }
        return returnValue;
    }

    public static final double[] randomPoisson(double mean, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            double p;
            double j = 0.0;
            double f = p = FastMath.exp((double)(-mean));
            double u = _random.nextDouble();
            while (f <= u) {
                f += (p *= mean / (j + 1.0));
                j += 1.0;
            }
            returnValue[i] = j;
        }
        return returnValue;
    }

    public static double[] randomUniform(double a, double b, int N) {
        double range = b - a;
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            returnValue[i] = _random.nextDouble() * range + a;
        }
        return returnValue;
    }
}

