/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import jhplot.P1D;
import jhplot.gui.HelpBrowser;

public class MomentsFac {
    private int oder = 0;
    private double[] IL;
    private double[] IE;
    private int nev = 0;

    public MomentsFac(int order) {
        this.oder = order;
        this.IL = new double[this.oder];
        this.IE = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            this.IL[i] = 0.0;
            this.IE[i] = 0.0;
        }
    }

    public void process(int n) {
        ++this.nev;
        for (int i = 0; i < this.oder; ++i) {
            int h = n;
            for (int j = 0; j < i; ++j) {
                h *= n - 1 - j;
            }
            this.IL[i] = this.IL[i] + (double)h;
            this.IE[i] = this.IE[i] + (double)(h * h);
        }
    }

    public double[] getValues() {
        double[] IM = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            IM[i] = this.IL[i] / (double)(this.nev - 1);
        }
        return IM;
    }

    public double[] getErrors() {
        double[] IEE = new double[this.oder];
        for (int i = 0; i < this.oder; ++i) {
            double X1 = this.IL[i] / (double)(this.nev - 1);
            double X2 = this.IE[i] / (double)(this.nev - 1);
            double VAR = X2 - X1 * X1;
            IEE[i] = 0.0;
            if (!(VAR > 0.0)) continue;
            IEE[i] = Math.sqrt(VAR / (double)(this.nev - 1));
        }
        return IEE;
    }

    public P1D getResults() {
        P1D tmp = new P1D("Factorial Moments");
        double[] val = this.getValues();
        double[] err = this.getErrors();
        for (int i = 0; i < this.oder; ++i) {
            tmp.add(i + 1, val[i], err[i]);
        }
        return tmp;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

