/*
 * Decompiled with CFR 0.152.
 */
package jhpro.sregression;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import jhplot.PND;
import jhplot.gui.HelpBrowser;
import jhpro.sregression.ApplicationData;
import jhpro.sregression.FormulaFitnessFunction;
import jhpro.sregression.SymProblem;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPProblem;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.ADF;
import org.jgap.gp.function.Abs;
import org.jgap.gp.function.Add;
import org.jgap.gp.function.Add3;
import org.jgap.gp.function.Add4;
import org.jgap.gp.function.And;
import org.jgap.gp.function.ArcCosine;
import org.jgap.gp.function.ArcSine;
import org.jgap.gp.function.ArcTangent;
import org.jgap.gp.function.Ceil;
import org.jgap.gp.function.Cosine;
import org.jgap.gp.function.Divide;
import org.jgap.gp.function.Equals;
import org.jgap.gp.function.Exp;
import org.jgap.gp.function.Floor;
import org.jgap.gp.function.ForLoop;
import org.jgap.gp.function.ForXLoop;
import org.jgap.gp.function.GreaterThan;
import org.jgap.gp.function.If;
import org.jgap.gp.function.IfDyn;
import org.jgap.gp.function.IfElse;
import org.jgap.gp.function.Increment;
import org.jgap.gp.function.LesserThan;
import org.jgap.gp.function.Log;
import org.jgap.gp.function.Loop;
import org.jgap.gp.function.Max;
import org.jgap.gp.function.Min;
import org.jgap.gp.function.Modulo;
import org.jgap.gp.function.Multiply;
import org.jgap.gp.function.Multiply3;
import org.jgap.gp.function.Not;
import org.jgap.gp.function.Or;
import org.jgap.gp.function.Pop;
import org.jgap.gp.function.Pow;
import org.jgap.gp.function.Push;
import org.jgap.gp.function.Round;
import org.jgap.gp.function.Sine;
import org.jgap.gp.function.StoreTerminal;
import org.jgap.gp.function.SubProgram;
import org.jgap.gp.function.Subtract;
import org.jgap.gp.function.Tangent;
import org.jgap.gp.function.Tupel;
import org.jgap.gp.function.Xor;
import org.jgap.gp.impl.DeltaGPFitnessEvaluator;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.gp.impl.TournamentSelector;
import org.jgap.gp.terminal.Constant;
import org.jgap.gp.terminal.Terminal;
import org.jgap.gp.terminal.Variable;
import org.jgap.symbolic.AndD;
import org.jgap.symbolic.Cube;
import org.jgap.symbolic.DifferentD;
import org.jgap.symbolic.DivideIntD;
import org.jgap.symbolic.DivideProtected;
import org.jgap.symbolic.EqualsD;
import org.jgap.symbolic.ForLoopD;
import org.jgap.symbolic.Gamma;
import org.jgap.symbolic.Gaussian;
import org.jgap.symbolic.GreaterThanD;
import org.jgap.symbolic.GreaterThanOrEqualD;
import org.jgap.symbolic.Hill;
import org.jgap.symbolic.Id;
import org.jgap.symbolic.IfElseD;
import org.jgap.symbolic.IfLessThanOrEqualD;
import org.jgap.symbolic.IfLessThanOrEqualZeroD;
import org.jgap.symbolic.LesserThanD;
import org.jgap.symbolic.LesserThanOrEqualD;
import org.jgap.symbolic.Logistic;
import org.jgap.symbolic.LoopD;
import org.jgap.symbolic.ModuloD;
import org.jgap.symbolic.ModuloReplaceD;
import org.jgap.symbolic.NotD;
import org.jgap.symbolic.OrD;
import org.jgap.symbolic.RoundD;
import org.jgap.symbolic.Sigmoid;
import org.jgap.symbolic.Sign;
import org.jgap.symbolic.Sqrt;
import org.jgap.symbolic.Square;
import org.jgap.symbolic.Step;
import org.jgap.symbolic.XorD;
import org.jgap.util.NumberKit;
import org.jgap.util.SystemKit;

public class SymRegression {
    protected static int numInputVariables;
    protected static Variable[] variables;
    protected static String[] variableNames;
    protected static Integer outputVariable;
    protected int[] ignoreVariables;
    protected static ArrayList constants;
    protected static int numRows;
    protected static double[][] data;
    protected boolean foundPerfect = false;
    protected int minInitDepth = 2;
    protected int maxInitDepth = 4;
    protected int populationSize = 1000;
    protected int maxCrossoverDepth = 8;
    protected int programCreationMaxTries = 5;
    protected int numEvolutions = 1800;
    protected static boolean verboseOutput;
    protected static int maxNodes;
    protected double functionProb = 0.9;
    protected float reproductionProb = 0.1f;
    protected float mutationProb = 0.1f;
    protected float crossoverProb = 0.9f;
    protected float dynamizeArityProb = 0.08f;
    protected double newChromsPercent = 0.3;
    protected int tournamentSelectorSize = 0;
    protected boolean noCommandGeneCloning = true;
    protected boolean strictProgramCreation = false;
    protected boolean useProgramCache = true;
    protected static double lowerRange;
    protected static double upperRange;
    protected static boolean terminalWholeNumbers;
    protected String returnType = "DoubleClass";
    protected String presentation = "";
    protected static int adfArity;
    protected static String adfType;
    protected static boolean useADF;
    protected static String[] functions;
    protected static String[] adfFunctions;
    protected static double scaleError;
    protected long startTime;
    protected long endTime;
    protected String bestSolution = "";
    protected double stopCriteriaFitness = -1.0;
    protected boolean showPopulation = false;
    protected boolean showSimiliar = false;
    protected String similiarSortMethod = "occurrence";
    protected boolean showProgression = false;
    protected boolean showAllGenerations = false;
    protected static boolean showResults;
    protected int resultPrecision = 5;
    protected double samplePCT = 0.0;
    protected static double hitsCriteria;
    protected double validationPCT = 0.0;
    protected double[][] validationSet;
    protected double[][] testData;
    protected static int modReplace;
    protected boolean makeTimeSeries = false;
    protected boolean makeTimeSeriesWithIndex = false;
    private GPProblem problem;
    private GPGenotype gp;
    private GPConfiguration config;
    private ArrayList<String> configstring = new ArrayList();
    protected static String errorMethod;
    protected static boolean noTerminals;
    protected static int minNodes;
    protected static double minNodesPenalty;
    protected static boolean alldifferentVariables;
    protected static double alldifferentVariablesPenalty;
    private ArrayList<double[]> theData;
    private ArrayList<double[]> theValidationSet;
    private ArrayList<double[]> theTestData;

    public SymRegression() {
        this.theData = new ArrayList();
        this.theValidationSet = new ArrayList();
        this.theTestData = new ArrayList();
    }

    public SymRegression(String inputfile) {
        this.theData = new ArrayList();
        this.theValidationSet = new ArrayList();
        this.theTestData = new ArrayList();
        this.readFile(inputfile);
        Configuration.reset();
        this.processIni();
    }

    public SymRegression(ArrayList<double[]> xdata, ArrayList<String> configuration) {
        this.theData = xdata;
        this.theValidationSet = new ArrayList();
        this.theTestData = new ArrayList();
        for (int j = 0; j < configuration.size(); ++j) {
            this.collectConfigValues(j + 1, configuration.get(j));
        }
        this.makeRest();
        Configuration.reset();
        this.processIni();
    }

    public SymRegression(PND xdata, ArrayList<String> configuration) {
        this.theData = xdata.getArrayList();
        this.theValidationSet = new ArrayList();
        this.theTestData = new ArrayList();
        for (int j = 0; j < configuration.size(); ++j) {
            this.collectConfigValues(j + 1, configuration.get(j));
        }
        this.makeRest();
        Configuration.reset();
        this.processIni();
    }

    public SymRegression(PND xdata, String[] configuration) {
        this.theData = xdata.getArrayList();
        this.theValidationSet = new ArrayList();
        this.theTestData = new ArrayList();
        for (int j = 0; j < configuration.length; ++j) {
            this.collectConfigValues(j + 1, configuration[j]);
        }
        this.makeRest();
        Configuration.reset();
        this.processIni();
    }

    public SymRegression(PND xdata, PND valid, PND test, String[] configuration) {
        this.theData = xdata.getArrayList();
        this.theValidationSet = valid.getArrayList();
        this.theTestData = test.getArrayList();
        for (int j = 0; j < configuration.length; ++j) {
            this.collectConfigValues(j + 1, configuration[j]);
        }
        this.makeRest();
        Configuration.reset();
        this.processIni();
    }

    private void processIni() {
        System.out.println("Presentation: " + this.presentation);
        if (outputVariable == null) {
            outputVariable = numInputVariables;
        }
        if (variableNames == null) {
            variableNames = new String[numInputVariables + 1];
            for (int i = 0; i < numInputVariables + 1; ++i) {
                SymRegression.variableNames[i] = "V" + (i + 1);
            }
        }
        System.out.println("output_variable: " + variableNames[outputVariable] + " (index: " + outputVariable + ")");
        this.config = null;
        try {
            this.config = new GPConfiguration();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.config.setGPFitnessEvaluator(new DeltaGPFitnessEvaluator());
        this.config.setMaxInitDepth(this.maxInitDepth);
        try {
            this.config.setPopulationSize(this.populationSize);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        if (this.tournamentSelectorSize > 0) {
            this.config.setSelectionMethod(new TournamentSelector(this.tournamentSelectorSize));
        }
        this.config.setMaxCrossoverDepth(this.maxCrossoverDepth);
        try {
            this.config.setFitnessFunction(new FormulaFitnessFunction());
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.config.setStrictProgramCreation(this.strictProgramCreation);
        this.config.setNoCommandGeneCloning(this.noCommandGeneCloning);
        this.config.setUseProgramCache(this.useProgramCache);
        this.config.setFunctionProb(this.functionProb);
        this.config.setReproductionProb(this.reproductionProb);
        this.config.setCrossoverProb(this.crossoverProb);
        this.config.setMutationProb(this.mutationProb);
        this.config.setDynamizeArityProb(this.dynamizeArityProb);
        this.config.setNewChromsPercent(this.newChromsPercent);
        this.config.setMinInitDepth(this.minInitDepth);
        this.config.setProgramCreationMaxTries(this.programCreationMaxTries);
    }

    public void run() {
        this.problem = null;
        this.gp = null;
        try {
            this.problem = new SymProblem(this.config);
            this.gp = this.problem.create();
            this.gp.setVerboseOutput(false);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.startTime = System.currentTimeMillis();
        System.out.println("Creating initial population");
        IGPProgram fittest = null;
        double bestFit = -1.0;
        String bestProgram = "";
        int bestGen = 0;
        HashMap<String, Integer> similiar = null;
        if (this.showSimiliar) {
            similiar = new HashMap<String, Integer>();
        }
        int numEvolutions2 = this.numEvolutions;
        if (this.stopCriteriaFitness >= 0.0) {
            numEvolutions2 = Integer.MAX_VALUE;
        }
        int gen = 0;
        for (gen = 0; gen < numEvolutions2; ++gen) {
            this.gp.evolve();
            this.gp.calcFitness();
            GPPopulation pop = this.gp.getGPPopulation();
            IGPProgram thisFittest = pop.determineFittestProgram();
            ProgramChromosome chrom = thisFittest.getChromosome(0);
            String program = chrom.toStringNorm(0);
            double fitness = thisFittest.getFitnessValue();
            if (this.showSimiliar || this.showPopulation || this.showAllGenerations) {
                if (this.showPopulation || this.showAllGenerations) {
                    System.out.println("Generation " + gen);
                }
                pop.sortByFitness();
                for (IGPProgram p : pop.getGPPrograms()) {
                    double fit = p.getFitnessValue();
                    if (this.showSimiliar && fit <= bestFit) {
                        String prog = p.toStringNorm(0);
                        if (!similiar.containsKey(prog)) {
                            similiar.put(prog, 1);
                        } else {
                            similiar.put(prog, (Integer)similiar.get(prog) + 1);
                        }
                    }
                    if (!this.showPopulation) continue;
                    String prg = p.toStringNorm(0);
                    int sz = p.size();
                    System.out.println("\tprogram: " + prg + " fitness: " + fit);
                }
            }
            if (bestFit < 0.0 || fitness < bestFit || this.showAllGenerations) {
                if (bestFit < 0.0 || fitness < bestFit) {
                    bestGen = gen;
                    bestFit = fitness;
                    bestProgram = program;
                    fittest = thisFittest;
                    if (this.showSimiliar) {
                        similiar.clear();
                        similiar.put(thisFittest.toStringNorm(0), 1);
                    }
                }
                this.myOutputSolution(fittest, gen);
            } else if (this.showProgression) {
                String genStr = "" + (gen - 1);
                for (int i = 0; i <= genStr.length(); ++i) {
                    System.out.print("\b");
                }
                System.out.print("" + gen);
            }
            if (!(this.stopCriteriaFitness >= 0.0) || !(fitness <= this.stopCriteriaFitness)) continue;
            System.out.print("\nFitness stopping criteria (" + this.stopCriteriaFitness + ") reached with fitness " + fitness + " at generation " + gen + "\n");
            break;
        }
        System.out.println("\nAll time best (from generation " + bestGen + ")");
        this.myOutputSolution(fittest, gen);
        this.endTime = System.currentTimeMillis();
        long elapsedTime = this.endTime - this.startTime;
        String elapsed = String.format("%5.2f", Float.valueOf((float)(this.endTime - this.startTime) / 1000.0f));
        System.out.println("\nTotal time " + elapsed + "s");
        if (this.showSimiliar) {
            System.out.println("\nAll solutions with the best fitness (" + bestFit + "):");
            System.out.println("Sort method: " + this.similiarSortMethod);
            ArrayList sorted = new ArrayList(similiar.keySet());
            final HashMap<String, Integer> sim = similiar;
            Collections.sort(sorted, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if ("length".equals(SymRegression.this.similiarSortMethod)) {
                        return s1.length() - s2.length();
                    }
                    return (Integer)sim.get(s2) - (Integer)sim.get(s1);
                }
            });
            for (String p : sorted) {
                System.out.println(p + " [" + similiar.get(p) + "]");
            }
            System.out.println("It was " + similiar.size() + " different solutions with fitness " + bestFit);
        }
        if (this.testData != null && this.testData.length > 0) {
            System.out.println("\nTesting the fittest program with user defined test data: ");
            int testDataSize = this.testData.length;
            for (int i = 0; i < testDataSize; ++i) {
                for (int j = 0; j < this.testData[i].length; ++j) {
                    if (j == outputVariable) continue;
                    System.out.print(this.testData[i][j] + " ");
                }
                Double testResult = this.evalData(fittest, this.testData[i]);
                System.out.println("   Result: " + testResult);
            }
        }
        if (this.validationSet != null && this.validationSet.length > 0) {
            System.out.println("\nTesting the fittest program with the validation set: ");
            int validationDataSize = this.validationSet.length;
            for (int i = 0; i < this.validationSet[0].length; ++i) {
                double[] val = new double[validationDataSize];
                for (int j = 0; j < validationDataSize; ++j) {
                    val[j] = this.validationSet[j][i];
                    System.out.print(val[j] + " ");
                }
                double testResult = this.evalData(fittest, val);
                double diff = Math.abs(testResult - val[outputVariable]);
                System.out.println("   Result: " + testResult + " should be " + val[outputVariable] + " diff: " + diff);
            }
        }
    }

    private void collectConfigValues(int lineCount, String str) {
        if ((str = str.trim()).contains(":")) {
            this.configstring.add(str);
            String[] row = str.split(":\\s*");
            if ("return_type".equals(row[0])) {
                this.returnType = row[1];
            } else if ("presentation".equals(row[0])) {
                this.presentation = row[1];
            } else if ("num_input_variables".equals(row[0])) {
                numInputVariables = Integer.parseInt(row[1]);
            } else if ("num_rows".equals(row[0])) {
                System.out.println("num_rows is not used anymore; it is calculated by the program.");
            } else if ("terminal_range".equals(row[0])) {
                String[] ranges = row[1].split("\\s+");
                lowerRange = Double.parseDouble(ranges[0]);
                upperRange = Double.parseDouble(ranges[1]);
            } else if ("terminal_wholenumbers".equals(row[0])) {
                terminalWholeNumbers = Boolean.parseBoolean(row[1]);
            } else if ("max_init_depth".equals(row[0])) {
                this.maxInitDepth = Integer.parseInt(row[1]);
            } else if ("min_init_depth".equals(row[0])) {
                this.minInitDepth = Integer.parseInt(row[1]);
            } else if ("program_creation_max_tries".equals(row[0])) {
                this.programCreationMaxTries = Integer.parseInt(row[1]);
            } else if ("population_size".equals(row[0])) {
                this.populationSize = Integer.parseInt(row[1]);
            } else if ("max_crossover_depth".equals(row[0])) {
                this.maxCrossoverDepth = Integer.parseInt(row[1]);
            } else if ("function_prob".equals(row[0])) {
                this.functionProb = Double.parseDouble(row[1]);
            } else if ("reproduction_prob".equals(row[0])) {
                this.reproductionProb = Float.parseFloat(row[1]);
            } else if ("mutation_prob".equals(row[0])) {
                this.mutationProb = Float.parseFloat(row[1]);
            } else if ("crossover_prob".equals(row[0])) {
                this.crossoverProb = Float.parseFloat(row[1]);
            } else if ("dynamize_arity_prob".equals(row[0])) {
                this.dynamizeArityProb = Float.parseFloat(row[1]);
            } else if ("new_chroms_percent".equals(row[0])) {
                this.newChromsPercent = Double.parseDouble(row[1]);
            } else if ("num_evolutions".equals(row[0])) {
                this.numEvolutions = Integer.parseInt(row[1]);
            } else if ("max_nodes".equals(row[0])) {
                maxNodes = Integer.parseInt(row[1]);
            } else if ("functions".equals(row[0])) {
                functions = row[1].split("[\\s,]+");
            } else if ("adf_functions".equals(row[0])) {
                adfFunctions = row[1].split("[\\s,]+");
            } else if ("variable_names".equals(row[0])) {
                variableNames = row[1].split("[\\s,]+");
            } else if ("output_variable".equals(row[0])) {
                outputVariable = Integer.parseInt(row[1]);
            } else if ("ignore_variables".equals(row[0])) {
                String[] ignoreVariablesS = row[1].split("[\\s,]+");
                this.ignoreVariables = new int[ignoreVariablesS.length];
                for (int i = 0; i < ignoreVariablesS.length; ++i) {
                    this.ignoreVariables[i] = Integer.parseInt(ignoreVariablesS[i]);
                }
            } else if ("constant".equals(row[0])) {
                Double constant = Double.parseDouble(row[1]);
                constants.add(constant);
            } else if ("adf_arity".equals(row[0])) {
                adfArity = Integer.parseInt(row[1]);
                System.out.println("ADF arity " + adfArity);
                if (adfArity > 0) {
                    useADF = true;
                }
            } else if ("adf_type".equals(row[0])) {
                adfType = row[1];
            } else if ("tournament_selector_size".equals(row[0])) {
                this.tournamentSelectorSize = Integer.parseInt(row[1]);
            } else if ("scale_error".equals(row[0])) {
                scaleError = Double.parseDouble(row[1]);
            } else if ("stop_criteria_fitness".equals(row[0])) {
                this.stopCriteriaFitness = Double.parseDouble(row[1]);
            } else if ("show_population".equals(row[0])) {
                this.showPopulation = Boolean.parseBoolean(row[1]);
            } else if ("show_similiar".equals(row[0]) || "show_similar".equals(row[0])) {
                this.showSimiliar = Boolean.parseBoolean(row[1]);
            } else if ("similiar_sort_method".equals(row[0]) || "similar_sort_method".equals(row[0])) {
                this.similiarSortMethod = row[1];
                if (!"length".equals(this.similiarSortMethod) && !"occurrence".equals(this.similiarSortMethod)) {
                    System.out.println("Unknown similiar_sort_method: " + this.similiarSortMethod);
                    return;
                }
            } else if ("show_progression".equals(row[0])) {
                this.showProgression = Boolean.parseBoolean(row[1]);
            } else if ("sample_pct".equals(row[0])) {
                this.samplePCT = Float.parseFloat(row[1]);
            } else if ("validation_pct".equals(row[0])) {
                this.validationPCT = Float.parseFloat(row[1]);
            } else if ("hits_criteria".equals(row[0])) {
                hitsCriteria = Double.parseDouble(row[1]);
                errorMethod = "hitsCriteria";
            } else if ("show_all_generations".equals(row[0])) {
                this.showAllGenerations = Boolean.parseBoolean(row[1]);
            } else if ("strict_program_creation".equals(row[0])) {
                this.strictProgramCreation = Boolean.parseBoolean(row[1]);
            } else if ("no_command_gene_cloning".equals(row[0])) {
                this.noCommandGeneCloning = Boolean.parseBoolean(row[1]);
            } else if ("use_program_cache".equals(row[0])) {
                this.useProgramCache = Boolean.parseBoolean(row[1]);
            } else if ("mod_replace".equals(row[0])) {
                modReplace = Integer.parseInt(row[1]);
            } else if ("show_results".equals(row[0])) {
                showResults = Boolean.parseBoolean(row[1]);
            } else if ("result_precision".equals(row[0])) {
                this.resultPrecision = Integer.parseInt(row[1]);
            } else if ("error_method".equals(row[0])) {
                errorMethod = row[1];
                if (!("maxError".equals(errorMethod) || "minError".equals(errorMethod) || "medianError".equals(errorMethod) || "meanError".equals(errorMethod) || "totalError".equals(errorMethod))) {
                    System.out.println("Unknown errorMethod: " + errorMethod);
                    return;
                }
            } else if ("no_terminals".equals(row[0])) {
                noTerminals = Boolean.parseBoolean(row[1]);
            } else if ("make_time_series".equals(row[0])) {
                this.makeTimeSeries = Boolean.parseBoolean(row[1]);
            } else if ("make_time_series_with_index".equals(row[0])) {
                this.makeTimeSeriesWithIndex = Boolean.parseBoolean(row[1]);
            } else if ("min_nodes".equals(row[0])) {
                String[] opt = row[1].split("[\\s,]+");
                minNodes = Integer.parseInt(opt[0]);
                if (minNodes > maxNodes) {
                    System.out.println("minNodes (" + minNodes + ") >  maxNodes (" + maxNodes + ") which is weird. Cannot continue. ");
                    return;
                }
                minNodesPenalty = Integer.parseInt(opt[1]);
            } else if ("alldifferent_variables".equals(row[0])) {
                String[] opt = row[1].split("[\\s,]+");
                alldifferentVariables = Boolean.parseBoolean(opt[0]);
                alldifferentVariablesPenalty = Double.parseDouble(opt[1]);
            } else {
                System.out.println("Unknown keyword: " + row[0] + " on line " + lineCount);
                return;
            }
        }
    }

    public void readFile(String file) {
        file = file.trim();
        BufferedReader inr = null;
        if (file.startsWith("http:") || file.startsWith("ftp:")) {
            try {
                URL url = new URL(file);
                URLConnection urlConn = url.openConnection();
                InputStreamReader inStream = new InputStreamReader(urlConn.getInputStream());
                inr = new BufferedReader(inStream);
            }
            catch (MalformedURLException e) {
                System.err.println("Please check the URL:" + e.toString());
                return;
            }
            catch (IOException e1) {
                System.err.println("Can't read  from the Internet: " + e1.toString());
                return;
            }
        }
        try {
            inr = new BufferedReader(new FileReader(file));
        }
        catch (IOException e1) {
            System.err.println("Can't read : " + e1.toString());
            return;
        }
        try {
            String str;
            int lineCount = 0;
            boolean gotData = false;
            while ((str = inr.readLine()) != null) {
                ++lineCount;
                if ((str = str.trim()).startsWith("#") || str.startsWith("%") || str.length() == 0) continue;
                if ("data".equals(str)) {
                    gotData = true;
                    continue;
                }
                if (gotData) {
                    Random randomGenerator;
                    float rand;
                    String[] dataRowStr = str.split("[\\s,]+");
                    int len = dataRowStr.length;
                    double[] dataRow = new double[len];
                    boolean isTestData = false;
                    for (int i = 0; i < len; ++i) {
                        if ("?".equals(dataRowStr[i])) {
                            isTestData = true;
                            dataRow[i] = -1.0;
                            continue;
                        }
                        dataRow[i] = Double.parseDouble(dataRowStr[i]);
                    }
                    boolean inData = true;
                    if (isTestData) {
                        inData = false;
                        this.theTestData.add(dataRow);
                    }
                    if (!isTestData && this.samplePCT > 0.0 && (double)(rand = (randomGenerator = new Random()).nextFloat()) > this.samplePCT) {
                        inData = false;
                    }
                    if (!isTestData && this.validationPCT > 0.0 && (double)(rand = (randomGenerator = new Random()).nextFloat()) < this.validationPCT) {
                        inData = false;
                        this.theValidationSet.add(dataRow);
                    }
                    if (!inData) continue;
                    this.theData.add(dataRow);
                    continue;
                }
                this.collectConfigValues(lineCount, str);
            }
            inr.close();
            this.makeRest();
        }
        catch (IOException e1) {
            System.err.println("Cannot process the file " + e1.toString());
            return;
        }
    }

    private void makeRest() {
        int j;
        double[] this_row;
        int i;
        int r_v;
        int i2;
        if (this.makeTimeSeries || this.makeTimeSeriesWithIndex) {
            ArrayList<double[]> theDataNew = new ArrayList<double[]>();
            double[] dat = this.theData.get(0);
            int numElements = dat.length;
            System.out.println("Making timeseries, #elements: " + numElements);
            int cols = numInputVariables + 1;
            if (this.makeTimeSeriesWithIndex) {
                ++cols;
            }
            for (i2 = 0; i2 < numElements - cols; ++i2) {
                double[] tmp = new double[cols];
                int jStart = 0;
                if (this.makeTimeSeriesWithIndex) {
                    System.out.print(i2 + 1 + " ");
                    tmp[0] = (double)i2 + 1.0;
                    jStart = 1;
                }
                for (int j2 = jStart; j2 < cols; ++j2) {
                    System.out.print(dat[i2 + j2] + " ");
                    tmp[j2] = dat[i2 + j2];
                }
                System.out.println();
                theDataNew.add(tmp);
            }
            this.theData = theDataNew;
        }
        int r = this.theData.size();
        int c = this.theData.get(0).length;
        int numIgnore = 0;
        if (this.ignoreVariables != null) {
            numIgnore = this.ignoreVariables.length;
        }
        double[][] dataTmp = new double[r][c];
        for (i2 = 0; i2 < r; ++i2) {
            double[] this_row2 = this.theData.get(i2);
            for (int j3 = 0; j3 < c; ++j3) {
                dataTmp[i2][j3] = this_row2[j3];
            }
        }
        data = this.transposeMatrix(dataTmp);
        numRows = data[0].length;
        System.out.println("It was " + numRows + " data rows");
        if (this.validationPCT > 0.0 && this.theValidationSet != null && this.theValidationSet.size() > 0) {
            r_v = this.theValidationSet.size();
            int c_v = this.theValidationSet.get(0).length;
            double[][] dataTmp_v = new double[r_v][c_v];
            for (i = 0; i < r_v; ++i) {
                this_row = this.theValidationSet.get(i);
                for (j = 0; j < c_v; ++j) {
                    dataTmp_v[i][j] = this_row[j];
                }
            }
            this.validationSet = this.transposeMatrix(dataTmp_v);
            System.out.println("It was " + this.validationSet[0].length + " data rows in the validation data set");
        }
        if (this.theTestData.size() > 0) {
            r_v = this.theTestData.size();
            int c_v = this.theTestData.get(0).length;
            double[][] dataTmp_v = new double[r_v][c_v];
            for (i = 0; i < r_v; ++i) {
                this_row = this.theTestData.get(i);
                for (j = 0; j < c_v; ++j) {
                    dataTmp_v[i][j] = this_row[j];
                }
            }
            this.testData = dataTmp_v;
            System.out.println("It was " + this.testData.length + " data rows in the user defined data set");
        }
    }

    protected double[][] transposeMatrix(double[][] dataTmp) {
        int r = dataTmp.length;
        int c = dataTmp[0].length;
        double[][] t = new double[c][r];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                t[j][i] = dataTmp[i][j];
            }
        }
        return t;
    }

    static CommandGene[] makeCommands(GPConfiguration conf, String[] functions, Double lowerRange, Double upperRange, String type) {
        ArrayList<CommandGene> commandsList = new ArrayList<CommandGene>();
        int len = functions.length;
        boolean isADF = "ADF".equals(type);
        try {
            int i;
            for (i = 0; i < len; ++i) {
                if ("Multiply".equals(functions[i])) {
                    commandsList.add(new Multiply(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Multiply(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Multiply3".equals(functions[i])) {
                    commandsList.add(new Multiply3(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Multiply3(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Add".equals(functions[i])) {
                    commandsList.add(new Add(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Add(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Divide".equals(functions[i])) {
                    commandsList.add(new Divide(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Divide(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("DivideIntD".equals(functions[i])) {
                    commandsList.add(new DivideIntD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("DivideProtected".equals(functions[i])) {
                    commandsList.add(new DivideProtected(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Add3".equals(functions[i])) {
                    commandsList.add(new Add3(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Add3(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Add4".equals(functions[i])) {
                    commandsList.add(new Add4(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Add4(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Subtract".equals(functions[i])) {
                    commandsList.add(new Subtract(conf, CommandGene.DoubleClass));
                    if (!useADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Subtract(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Sine".equals(functions[i])) {
                    commandsList.add(new Sine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ArcSine".equals(functions[i])) {
                    commandsList.add(new ArcSine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Tangent".equals(functions[i])) {
                    commandsList.add(new Tangent(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ArcTangent".equals(functions[i])) {
                    commandsList.add(new ArcTangent(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Cosine".equals(functions[i])) {
                    commandsList.add(new Cosine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ArcCosine".equals(functions[i])) {
                    commandsList.add(new ArcCosine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Exp".equals(functions[i])) {
                    commandsList.add(new Exp(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Log".equals(functions[i])) {
                    commandsList.add(new Log(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Abs".equals(functions[i])) {
                    commandsList.add(new Abs(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Pow".equals(functions[i])) {
                    commandsList.add(new Pow(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Round".equals(functions[i])) {
                    commandsList.add(new Round(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("RoundD".equals(functions[i])) {
                    commandsList.add(new RoundD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Ceil".equals(functions[i])) {
                    commandsList.add(new Ceil(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Floor".equals(functions[i])) {
                    commandsList.add(new Floor(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Modulo".equals(functions[i])) {
                    commandsList.add(new Modulo(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Modulo(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("ModuloD".equals(functions[i])) {
                    commandsList.add(new ModuloD(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new ModuloD(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("ModuloReplaceD".equals(functions[i])) {
                    commandsList.add(new ModuloReplaceD(conf, CommandGene.DoubleClass, modReplace));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new ModuloReplaceD(conf, CommandGene.BooleanClass, modReplace));
                    continue;
                }
                if ("Max".equals(functions[i])) {
                    commandsList.add(new Max(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Max(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Min".equals(functions[i])) {
                    commandsList.add(new Min(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Min(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Sqrt".equals(functions[i])) {
                    commandsList.add(new Sqrt(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Square".equals(functions[i])) {
                    commandsList.add(new Square(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Cube".equals(functions[i])) {
                    commandsList.add(new Cube(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Logistic".equals(functions[i])) {
                    commandsList.add(new Logistic(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Gaussian".equals(functions[i])) {
                    commandsList.add(new Gaussian(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Sigmoid".equals(functions[i])) {
                    commandsList.add(new Sigmoid(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Gamma".equals(functions[i])) {
                    commandsList.add(new Gamma(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Step".equals(functions[i])) {
                    commandsList.add(new Step(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Sign".equals(functions[i])) {
                    commandsList.add(new Sign(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Hill".equals(functions[i])) {
                    commandsList.add(new Hill(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("LesserThan".equals(functions[i])) {
                    commandsList.add(new LesserThan(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("LesserThanD".equals(functions[i])) {
                    commandsList.add(new LesserThanD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("LesserThanOrEqualD".equals(functions[i])) {
                    commandsList.add(new LesserThanOrEqualD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("GreaterThan".equals(functions[i])) {
                    commandsList.add(new GreaterThan(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("GreaterThanD".equals(functions[i])) {
                    commandsList.add(new GreaterThanD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("GreaterThanOrEqualD".equals(functions[i])) {
                    commandsList.add(new GreaterThanOrEqualD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("DifferentD".equals(functions[i])) {
                    commandsList.add(new DifferentD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("If".equals(functions[i])) {
                    commandsList.add(new If(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new If(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("IfElse".equals(functions[i])) {
                    commandsList.add(new IfElse(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new IfElse(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("IfElseD".equals(functions[i])) {
                    commandsList.add(new IfElseD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("IfLessThanOrEqualD".equals(functions[i])) {
                    commandsList.add(new IfLessThanOrEqualD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("IfLessThanOrEqualZeroD".equals(functions[i])) {
                    commandsList.add(new IfLessThanOrEqualZeroD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("IfDyn".equals(functions[i])) {
                    commandsList.add(new IfDyn(conf, CommandGene.DoubleClass, 1, 1, 5));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new IfDyn(conf, CommandGene.DoubleClass, 1, 1, 5));
                    continue;
                }
                if ("Loop".equals(functions[i])) {
                    commandsList.add(new Loop(conf, CommandGene.DoubleClass, 3));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Loop(conf, CommandGene.BooleanClass, 3));
                    continue;
                }
                if ("LoopD".equals(functions[i])) {
                    commandsList.add(new LoopD(conf, CommandGene.DoubleClass, numInputVariables));
                    continue;
                }
                if ("Equals".equals(functions[i])) {
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Equals(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("EqualsD".equals(functions[i])) {
                    commandsList.add(new EqualsD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ForXLoop".equals(functions[i])) {
                    commandsList.add(new ForXLoop(conf, CommandGene.IntegerClass));
                    if (isADF && "boolean".equals(adfType)) {
                        commandsList.add(new ForXLoop(conf, CommandGene.BooleanClass));
                        continue;
                    }
                    if (!useADF || !"integer".equals(adfType)) continue;
                    commandsList.add(new ForXLoop(conf, CommandGene.IntegerClass));
                    continue;
                }
                if ("ForLoop".equals(functions[i])) {
                    commandsList.add(new ForLoop(conf, CommandGene.DoubleClass, 1, numInputVariables));
                    if (isADF && "boolean".equals(adfType)) {
                        commandsList.add(new ForLoop(conf, CommandGene.BooleanClass, 10));
                        continue;
                    }
                    if (!isADF || !"integer".equals(adfType)) continue;
                    commandsList.add(new ForLoop(conf, CommandGene.IntegerClass, 10));
                    continue;
                }
                if ("ForLoopD".equals(functions[i])) {
                    commandsList.add(new ForLoopD(conf, CommandGene.DoubleClass, numInputVariables * 2));
                    continue;
                }
                if ("Increment".equals(functions[i])) {
                    commandsList.add(new Increment(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Increment(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Argument".equals(functions[i])) continue;
                if ("StoreTerminal".equals(functions[i])) {
                    commandsList.add(new StoreTerminal(conf, "dmem0", CommandGene.DoubleClass));
                    commandsList.add(new StoreTerminal(conf, "dmem1", CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new StoreTerminal(conf, "bmem0", CommandGene.DoubleClass));
                    commandsList.add(new StoreTerminal(conf, "bmem1", CommandGene.DoubleClass));
                    continue;
                }
                if ("Pop".equals(functions[i])) {
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Pop(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Push".equals(functions[i])) {
                    commandsList.add(new Push(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("And".equals(functions[i])) {
                    commandsList.add(new And(conf));
                    continue;
                }
                if ("Or".equals(functions[i])) {
                    commandsList.add(new Or(conf));
                    continue;
                }
                if ("Xor".equals(functions[i])) {
                    commandsList.add(new Xor(conf));
                    continue;
                }
                if ("Not".equals(functions[i])) {
                    commandsList.add(new Not(conf));
                    continue;
                }
                if ("AndD".equals(functions[i])) {
                    commandsList.add(new AndD(conf));
                    continue;
                }
                if ("OrD".equals(functions[i])) {
                    commandsList.add(new OrD(conf));
                    continue;
                }
                if ("XorD".equals(functions[i])) {
                    commandsList.add(new XorD(conf));
                    continue;
                }
                if ("NotD".equals(functions[i])) {
                    commandsList.add(new NotD(conf));
                    continue;
                }
                if ("Id".equals(functions[i])) {
                    commandsList.add(new Id(conf));
                    continue;
                }
                if ("SubProgram".equals(functions[i])) {
                    if (isADF && "boolean".equals(adfType)) {
                        commandsList.add(new SubProgram(conf, new Class[]{CommandGene.BooleanClass, CommandGene.BooleanClass}));
                        commandsList.add(new SubProgram(conf, new Class[]{CommandGene.BooleanClass, CommandGene.BooleanClass, CommandGene.BooleanClass}));
                    }
                    commandsList.add(new SubProgram(conf, new Class[]{CommandGene.DoubleClass, CommandGene.DoubleClass}));
                    commandsList.add(new SubProgram(conf, new Class[]{CommandGene.DoubleClass, CommandGene.DoubleClass, CommandGene.DoubleClass}));
                    continue;
                }
                if ("Tupel".equals(functions[i])) {
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Tupel(conf, new Class[]{CommandGene.BooleanClass, CommandGene.BooleanClass}));
                    continue;
                }
                System.out.println("Unkown function: " + functions[i]);
                System.exit(1);
            }
            if (!noTerminals) {
                commandsList.add(new Terminal(conf, CommandGene.DoubleClass, lowerRange, upperRange, terminalWholeNumbers));
            }
            if (useADF && !"ADF".equals(type)) {
                commandsList.add(new ADF(conf, 1, adfArity));
            }
            if (constants != null) {
                for (i = 0; i < constants.size(); ++i) {
                    double constant = (Double)constants.get(i);
                    commandsList.add(new Constant(conf, CommandGene.DoubleClass, constant));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        CommandGene[] commands = new CommandGene[commandsList.size()];
        commandsList.toArray(commands);
        return commands;
    }

    private void myOutputSolution(IGPProgram a_best, int gen) {
        double[] results;
        String freeMB = SystemKit.niceMemory(SystemKit.getFreeMemoryMB());
        long now = System.currentTimeMillis();
        String elapsedNow = String.format("%5.2f", Float.valueOf((float)(now - this.startTime) / 1000.0f));
        if (this.showProgression) {
            System.out.println();
        }
        System.out.println("\nEvolving generation " + gen + "/" + this.numEvolutions + "(time from start: " + elapsedNow + "s)");
        if (a_best == null) {
            System.out.println("No best solution (null)");
            return;
        }
        double bestValue = a_best.getFitnessValue();
        if (Double.isInfinite(bestValue)) {
            System.out.println("No best solution (infinite)");
            return;
        }
        System.out.print("Best solution fitness: " + NumberKit.niceDecimalNumber(bestValue, 2) + " (error method: " + errorMethod + ")");
        if (this.validationPCT > 0.0 && this.validationSet != null) {
            double validationFitness = this.validateData(a_best);
            System.out.print("    (validation fitness: " + validationFitness + ")");
        }
        System.out.println();
        this.bestSolution = a_best.toStringNorm(0);
        System.out.println("Best solution: " + this.bestSolution);
        String depths = "";
        int size = a_best.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                depths = depths + " / ";
            }
            depths = depths + a_best.getChromosome(i).getDepth(0);
        }
        if (size == 1) {
            System.out.print("Depth of chrom: " + depths);
        } else {
            System.out.print("Depths of chroms: " + depths);
        }
        ProgramChromosome chrom = a_best.getChromosome(0);
        int numFunctions = chrom.numFunctions();
        int numTerminals = chrom.numTerminals();
        int numTerms = numFunctions + numTerminals;
        System.out.println(". Number of functions+terminals: " + numTerms + " (" + numFunctions + " functions, " + numTerminals + " terminals)");
        ApplicationData appData = (ApplicationData)a_best.getApplicationData();
        System.out.println("Correlation coefficient: " + appData.getCorrelation());
        System.out.println("minError: " + appData.getMinError() + " meanError: " + appData.getMeanError() + " medianError: " + appData.getMedianError() + " maxError: " + appData.getMaxError() + " totalError: " + appData.getTotalError());
        if (hitsCriteria >= 0.0) {
            int numHits = appData.getNumHits();
            String hitsPct = String.format("%5.2f", (double)numHits / (double)numRows);
            System.out.println("Number of hits (<= " + hitsCriteria + "): " + numHits + " (of " + numRows + " = " + hitsPct + ")");
        }
        if (showResults && (results = appData.getResults()) != null) {
            System.out.println("Results for this program:");
            double sumAbsDiff = 0.0;
            double sumDiff = 0.0;
            String formatStr = "%5." + this.resultPrecision + "f";
            int thisNumHits = 0;
            for (int i = 0; i < results.length; ++i) {
                double d = data[outputVariable][i];
                double r = results[i];
                double diff = d - r;
                double absDiff = Math.abs(diff);
                String hitsStr = "";
                if (hitsCriteria >= 0.0 && absDiff > hitsCriteria) {
                    hitsStr = " > " + hitsCriteria + "!";
                } else {
                    ++thisNumHits;
                }
                System.out.println("(" + i + ") " + d + ": " + String.format(formatStr, r) + " (diff: " + String.format(formatStr, diff) + ")" + hitsStr);
                sumDiff += diff;
                sumAbsDiff += absDiff;
            }
            String numHitsStr = hitsCriteria >= 0.0 ? " #hits: " + thisNumHits + " (of " + numRows : "";
            System.out.println("total diff: " + sumAbsDiff + " (no abs diff: " + sumDiff + numHitsStr + ")\n");
        }
    }

    protected static final double correlation(double[] data2, double[] y2, int n) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += data2[i];
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (data2[i] - av1) * (data2[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (data2[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    protected double validateData(IGPProgram ind) {
        double error = 0.0;
        double[] errors = new double[this.validationSet[0].length];
        Object[] noargs = new Object[]{};
        if (this.validationSet != null && this.validationSet.length > 0) {
            for (int j = 0; j < this.validationSet[0].length; ++j) {
                int variableIndex = 0;
                for (int i = 0; i < numInputVariables + 1; ++i) {
                    if (i == outputVariable) continue;
                    variables[variableIndex].set(this.validationSet[i][j]);
                    ++variableIndex;
                }
                try {
                    double err;
                    double result = ind.execute_double(0, noargs);
                    errors[j] = err = Math.abs(result - this.validationSet[outputVariable][j]);
                    if (!Double.isInfinite(error += err) && !Double.isNaN(error)) continue;
                    return Double.MAX_VALUE;
                }
                catch (ArithmeticException ex) {
                    System.out.println(ind);
                    throw ex;
                }
            }
        }
        double[] err = SymRegression.calcAllErrors(error, errors);
        return err[0];
    }

    protected static double[] calcAllErrors(double error, double[] errors) {
        double totalError = error;
        double[] minMaxErrors = SymRegression.getMinMax(errors);
        double minError = minMaxErrors[0];
        double maxError = minMaxErrors[1];
        double medianError = minMaxErrors[2];
        double meanError = error / (double)errors.length;
        if ("meanError".equals(errorMethod)) {
            error = meanError;
        } else if ("minError".equals(errorMethod)) {
            error = minError;
        } else if ("maxError".equals(errorMethod)) {
            error = maxError;
        } else if ("medianError".equals(errorMethod)) {
            error = medianError;
        }
        double[] err = new double[]{error, totalError, minError, maxError, meanError, medianError};
        return err;
    }

    protected double evalData(IGPProgram ind, double[] data) {
        Double result = 0.0;
        Object[] noargs = new Object[]{};
        int variableIndex = 0;
        for (int i = 0; i < numInputVariables + 1; ++i) {
            if (i == outputVariable) continue;
            variables[variableIndex].set(data[i]);
            ++variableIndex;
        }
        try {
            result = ind.execute_double(0, noargs);
        }
        catch (ArithmeticException ex) {
            System.out.println(ind);
            throw ex;
        }
        return result;
    }

    protected static double[] getMinMax(double[] arr) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i] < min) {
                min = arr[i];
            }
            if (!(arr[i] > max)) continue;
            max = arr[i];
        }
        double median = Double.MIN_VALUE;
        int len2 = len / 2;
        median = len == 1 ? arr[0] : (len == 2 ? (arr[0] + arr[1]) / 2.0 : (len % 2 == 1 ? arr[len2] : (arr[len2] + arr[len2 + 1]) / 2.0));
        return new double[]{min, max, median};
    }

    public void createTree(String imagename) {
        try {
            this.problem.showTree(this.gp.getAllTimeBest(), imagename);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getBestSolution() {
        return this.bestSolution;
    }

    public GPConfiguration getConfig() {
        return this.config;
    }

    public GPProblem getProblem() {
        return this.problem;
    }

    public ArrayList<double[]> getData() {
        return this.theData;
    }

    public ArrayList<double[]> getTestData() {
        return this.theTestData;
    }

    public ArrayList<double[]> getValidationData() {
        return this.theValidationSet;
    }

    public PND getValidationPND() {
        PND pn = new PND("Validation data");
        for (int j = 0; j < this.theValidationSet.size(); ++j) {
            double[] d = this.theValidationSet.get(j);
            pn.add(d);
        }
        return pn;
    }

    public PND getTestPND() {
        PND pn = new PND("Test data");
        for (int j = 0; j < this.theTestData.size(); ++j) {
            double[] d = this.theTestData.get(j);
            pn.add(d);
        }
        return pn;
    }

    public PND getDataPND() {
        PND pn = new PND("Data");
        for (int j = 0; j < this.theData.size(); ++j) {
            double[] d = this.theData.get(j);
            pn.add(d);
        }
        return pn;
    }

    public ArrayList<String> getConfigArray() {
        return this.configstring;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    static {
        constants = new ArrayList();
        verboseOutput = true;
        maxNodes = 21;
        lowerRange = -10.0;
        upperRange = -10.0;
        terminalWholeNumbers = true;
        adfArity = 0;
        adfType = "double";
        useADF = false;
        functions = new String[]{"Multiply", "Divide", "Add", "Subtract"};
        adfFunctions = new String[]{"Multiply3", "Divide", "Add3", "Subtract"};
        scaleError = -1.0;
        showResults = false;
        hitsCriteria = -1.0;
        modReplace = 0;
        errorMethod = "totalError";
        noTerminals = false;
        minNodes = -1;
        minNodesPenalty = 0.0;
        alldifferentVariables = false;
        alldifferentVariablesPenalty = 0.0;
    }
}

