/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import jhpro.nnet.jknnl.LearningDataModel;
import jhpro.nnet.jknnl.LearningFactorFunctionalModel;
import jhpro.nnet.jknnl.MetricModel;
import jhpro.nnet.jknnl.NetworkModel;
import jhpro.nnet.jknnl.TiredNeuronModel;
import jhpro.nnet.jknnl.WTALearningFunction;

public class WTALearningFunctionWithTired
extends WTALearningFunction {
    public WTALearningFunctionWithTired(NetworkModel networkModel, int maxIteration, MetricModel metrics, LearningDataModel learningData, LearningFactorFunctionalModel functionalModel) {
        super(networkModel, maxIteration, metrics, learningData, functionalModel);
    }

    @Override
    public int getBestNeuron(double[] vector) {
        int bestNeuron = super.getBestNeuron(vector);
        int networkSize = this.networkModel.getNumbersOfNeurons();
        for (int i = 0; i < networkSize; ++i) {
            TiredNeuronModel tempNeuron = (TiredNeuronModel)this.networkModel.getNeuron(i);
            int tiredness = tempNeuron.getTiredness();
            tempNeuron.setTiredness(++tiredness);
        }
        return bestNeuron;
    }

    @Override
    protected void changeNeuronWeight(int neuronNumber, double[] vector, int iteration) {
        super.changeNeuronWeight(neuronNumber, vector, iteration);
        TiredNeuronModel tempNeuron = (TiredNeuronModel)this.networkModel.getNeuron(neuronNumber);
        int tiredness = tempNeuron.getTiredness();
        tempNeuron.setTiredness(tiredness - 2);
    }
}

