/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.io.Serializable;
import jhpro.nnet.InputValue;

public class WeightMatrix
implements Serializable {
    float[][] weight;
    float[] bias;
    int size;

    public WeightMatrix(int i, int j, boolean flag) {
        this.weight = new float[i][j];
        this.bias = new float[j];
        for (int k = 0; k < j; ++k) {
            this.bias[k] = 1.0f;
        }
        this.size = i * j;
        if (flag) {
            this.size += j;
        }
    }

    public void init() {
        for (int i = 0; i < this.weight.length; ++i) {
            for (int j = 0; j < this.weight[0].length; ++j) {
                this.weight[i][j] = (float)Math.random() * 2.0f - 1.0f;
            }
        }
        for (int k = 0; k < this.weight[0].length; ++k) {
            this.bias[k] = (float)Math.random() * 2.0f - 1.0f;
        }
    }

    public void init(float[][] af) {
        for (int i = 0; i < this.weight.length; ++i) {
            for (int j = 0; j < this.weight[0].length; ++j) {
                this.weight[i][j] = af[i][j];
            }
        }
    }

    public void init(InputValue[] ainputvalue, int i) {
        switch (i) {
            case 1: {
                for (int j = 0; j < this.weight[0].length; ++j) {
                    this.weight[0][j] = (float)ainputvalue[j].getX();
                }
                return;
            }
            case 2: {
                for (int k = 0; k < this.weight[0].length; ++k) {
                    this.weight[0][k] = (float)ainputvalue[k].getX();
                    this.weight[1][k] = (float)ainputvalue[k].getY();
                }
                return;
            }
            case 3: {
                for (int l = 0; l < this.weight[0].length; ++l) {
                    this.weight[0][l] = (float)ainputvalue[l].getX();
                    this.weight[1][l] = (float)ainputvalue[l].getY();
                    this.weight[2][l] = (float)ainputvalue[l].getZ();
                }
                return;
            }
        }
    }

    public void changeWeights(float[] af, float[] af1, double d) {
        for (int i = 0; i < this.weight.length; ++i) {
            if (af[i] == 0.0f) continue;
            for (int j = 0; j < this.weight[0].length; ++j) {
                if (af1[j] == 1.0f || af1[j] == 0.0f) continue;
                float f = this.weight[i][j];
                this.weight[i][j] = 0.0f;
                this.weight[i][j] = f + af[i] * af1[j] * (1.0f - af1[j]) * (float)d;
            }
        }
        for (int k = 0; k < this.bias.length; ++k) {
            if (af1[k] == 1.0f || af1[k] == 0.0f) continue;
            float f1 = this.bias[k];
            this.bias[k] = 0.0f;
            this.bias[k] = f1 + af1[k] * (1.0f - af1[k]) * (float)d;
        }
    }

    public void changeWeightsKFM(float[] af, float[] af1, double d) {
        for (int i = 0; i < this.weight.length; ++i) {
            for (int j = 0; j < this.weight[0].length; ++j) {
                if (af[i] == this.weight[i][j] || af1[j] == 0.0f) continue;
                float f = this.weight[i][j];
                this.weight[i][j] = 0.0f;
                this.weight[i][j] = f + af1[j] * (af[i] - f) * (float)d;
            }
        }
    }

    public float[] getInputWeights(int i) {
        float[] af = new float[this.weight.length + 1];
        for (int j = 0; j < this.weight.length; ++j) {
            af[j] = this.weight[j][i];
        }
        af[this.weight.length] = this.bias[i];
        return af;
    }

    public float[] getOutputWeights(int i) {
        float[] af = new float[this.weight[0].length];
        for (int j = 0; j < this.weight[0].length; ++j) {
            af[j] = this.weight[i][j];
        }
        return af;
    }

    public int size() {
        return this.size;
    }

    public float[][] getWeights() {
        return this.weight;
    }

    public float[] getBiases() {
        return this.bias;
    }
}

