/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import jhpro.nnet.InputMatrix;
import jhpro.nnet.KohonenFeatureMap;
import jhpro.nnet.ParametersFrame;
import jhpro.nnet.Point3D;
import jhpro.nnet.ThreeD;

public class Example
extends Applet
implements Runnable {
    final Color sandColor = new Color(192, 192, 192);
    final Color boxColor = new Color(160, 160, 160);
    final Font statusFont = new Font("Helvetica", 0, 12);
    final Font statusTextFont = new Font("Helvetica", 1, 12);
    final Font headingFont = new Font("Helvetica", 1, 14);
    Thread kfmThread;
    KohonenFeatureMap kfm;
    ParametersFrame parametersFrame;
    InputMatrix im;
    Canvas drawCanvas;
    Panel statusPanel;
    Panel buttonsPanel;
    ThreeD td;
    Label[] statusLabel;
    Button startButton;
    Button stopButton;
    Button resetButton;
    Button parametersButton;
    Button infoButton;
    Button exitButton;
    Image offscreen;
    Dimension d;
    int xSize;
    int ySize;
    int zSize;
    int mapSizeX;
    int mapSizeY;
    int inputSize;
    int inputDimension;
    int[] inputX;
    int[] inputY;
    int[] inputZ;
    int maxCycle;
    int displayStep;
    double stopArea;
    Point3D[] boundingBox;
    Point3D[] inputs;
    Point3D[] weights;
    Point[] boundingBoxDraw;
    Point[] inputsDraw;
    Point[] weightsDraw;
    boolean itLearns;

    @Override
    public void init() {
        if (this.parametersFrame == null) {
            this.parametersFrame = new ParametersFrame(600, 10);
        }
        if (this.kfmThread == null) {
            this.kfmThread = new Thread((Runnable)this, "kfmThread");
            this.kfmThread.setPriority(10);
        }
        this.setup();
    }

    public void setup() {
        this.setLayout(new BorderLayout());
        this.drawCanvas = new Canvas();
        this.statusPanel = new Panel();
        this.statusPanel.setFont(this.statusFont);
        this.statusPanel.setBackground(Color.lightGray);
        this.statusPanel.setLayout(new GridLayout(4, 4, 4, 0));
        this.statusLabel = new Label[8];
        for (int i = 0; i < 8; ++i) {
            this.statusLabel[i] = new Label("", 0);
            this.statusLabel[i].setFont(this.statusTextFont);
        }
        this.statusPanel.add(new Label("input values:", 2));
        this.statusPanel.add(this.statusLabel[0]);
        this.statusPanel.add(new Label("learning cycle:", 2));
        this.statusPanel.add(this.statusLabel[1]);
        this.statusPanel.add(new Label("input layer:", 2));
        this.statusPanel.add(this.statusLabel[2]);
        this.statusPanel.add(new Label("learning rate:", 2));
        this.statusPanel.add(this.statusLabel[3]);
        this.statusPanel.add(new Label("map size:", 2));
        this.statusPanel.add(this.statusLabel[4]);
        this.statusPanel.add(new Label("activation area:", 2));
        this.statusPanel.add(this.statusLabel[5]);
        this.statusPanel.add(new Label("weights:", 2));
        this.statusPanel.add(this.statusLabel[6]);
        this.statusPanel.add(new Label("elapsed time:", 2));
        this.statusPanel.add(this.statusLabel[7]);
        this.buttonsPanel = new Panel();
        this.buttonsPanel.setFont(this.statusFont);
        this.buttonsPanel.setLayout(new GridLayout(1, 6, 2, 4));
        this.startButton = new Button("Start learning");
        this.stopButton = new Button("Stop learning");
        this.resetButton = new Button("Reset");
        this.parametersButton = new Button("Parameters");
        this.exitButton = new Button("Exit");
        this.buttonsPanel.add(this.startButton);
        this.buttonsPanel.add(this.stopButton);
        this.buttonsPanel.add(this.resetButton);
        this.buttonsPanel.add(this.parametersButton);
        this.buttonsPanel.add(this.exitButton);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.lightGray);
        panel.add("South", this.buttonsPanel);
        panel.add("Center", this.statusPanel);
        this.add("South", panel);
        this.add("Center", this.drawCanvas);
        this.show();
        this.itLearns = false;
        this.startButton.enable();
        this.stopButton.disable();
    }

    @Override
    public void start() {
        if (this.itLearns) {
            if (this.kfmThread == null) {
                this.kfmThread = new Thread((Runnable)this, "kfmThread");
                this.kfmThread.setPriority(10);
            }
            this.kfmThread.start();
            this.kfm.resetTime();
            return;
        }
        this.setNetParameters();
    }

    @Override
    public void stop() {
        if (this.kfmThread != null) {
            this.kfmThread.stop();
            this.kfmThread = null;
        }
    }

    @Override
    public void destroy() {
        if (this.parametersFrame != null) {
            this.parametersFrame.dispose();
            this.parametersFrame = null;
        }
        if (this.kfmThread != null) {
            this.kfmThread.stop();
            this.kfmThread = null;
        }
    }

    public void setNetParameters() {
        this.d = this.drawCanvas.size();
        this.offscreen = this.drawCanvas.createImage(this.d.width + 1, this.d.height + 1);
        this.kfm = new KohonenFeatureMap();
        this.boundingBox = new Point3D[8];
        this.boundingBoxDraw = new Point[8];
        this.inputSize = this.parametersFrame.getInputValues();
        this.im = new InputMatrix(this.inputSize, 3);
        this.inputX = new int[this.inputSize];
        this.inputY = new int[this.inputSize];
        this.inputZ = new int[this.inputSize];
        this.inputs = new Point3D[this.inputSize];
        this.inputsDraw = new Point[this.inputSize];
        this.inputDimension = this.parametersFrame.getDim();
        this.xSize = this.parametersFrame.getRangeX();
        this.ySize = this.parametersFrame.getRangeY();
        this.zSize = this.parametersFrame.getRangeZ();
        this.td = new ThreeD(this.d.width + 1, this.d.height + 1, this.xSize, this.ySize, this.zSize);
        this.mapSizeX = this.parametersFrame.getMapSizeX();
        this.mapSizeY = this.parametersFrame.getMapSizeY();
        this.weights = new Point3D[this.mapSizeX * this.mapSizeY];
        this.weightsDraw = new Point[this.mapSizeX * this.mapSizeY];
        if (this.mapSizeY == 0) {
            this.kfm.createMapLayer(this.mapSizeX, this.mapSizeX);
        } else {
            this.kfm.createMapLayer(this.mapSizeX, this.mapSizeY);
        }
        this.kfm.setInitLearningRate(this.parametersFrame.getInitRate());
        this.kfm.setInitActivationArea(this.parametersFrame.getInitArea());
        this.maxCycle = this.parametersFrame.getStopCycle();
        this.kfm.setMaxLearningCycles(this.maxCycle);
        this.stopArea = this.parametersFrame.getStopArea();
        this.kfm.setStopArea(this.stopArea);
        this.displayStep = this.parametersFrame.getDisplayStep();
        this.kfm.setDisplayStep(this.displayStep);
        for (int i = 0; i < this.inputSize; ++i) {
            this.inputX[i] = (int)(Math.random() * (double)(this.xSize << 1) - (double)this.xSize);
            this.inputY[i] = (int)(Math.random() * (double)(this.ySize << 1) - (double)this.ySize);
            this.inputZ[i] = (int)(Math.random() * (double)(this.zSize << 1) - (double)this.zSize);
            this.inputs[i] = new Point3D(this.inputX[i], this.inputY[i], this.inputZ[i]);
        }
        this.im.setInputValues(this.inputX, this.inputY, this.inputZ);
        this.kfm.connectLayers(this.im);
        this.statusLabel[0].setText(String.valueOf(this.inputs.length));
        this.statusLabel[2].setText(String.valueOf(this.inputDimension + "  neurons"));
        this.statusLabel[4].setText(this.mapSizeX + "x" + this.mapSizeY + "  neurons");
        this.statusLabel[6].setText(String.valueOf(this.mapSizeX * this.mapSizeY * this.inputDimension));
        this.boundingBox[0] = new Point3D(this.xSize, this.ySize, this.zSize);
        this.boundingBox[1] = new Point3D(this.xSize, this.ySize, -this.zSize);
        this.boundingBox[2] = new Point3D(-this.xSize, this.ySize, this.zSize);
        this.boundingBox[3] = new Point3D(-this.xSize, this.ySize, -this.zSize);
        this.boundingBox[4] = new Point3D(this.xSize, -this.ySize, this.zSize);
        this.boundingBox[5] = new Point3D(this.xSize, -this.ySize, -this.zSize);
        this.boundingBox[6] = new Point3D(-this.xSize, -this.ySize, this.zSize);
        this.boundingBox[7] = new Point3D(-this.xSize, -this.ySize, -this.zSize);
        this.td.setAngles(0, 0, 0);
        this.td.setAngleSteps(0, 0, 0);
        this.setWeights(this.kfm.getWeightValues());
        this.updateStatus(this.kfm.getLearningCycle(), this.kfm.getLearningRate(), this.kfm.getActivationArea(), this.kfm.getElapsedTime());
        this.draw();
        this.td.setAngleSteps(this.parametersFrame.getSpeedX(), this.parametersFrame.getSpeedY(), this.parametersFrame.getSpeedZ());
    }

    @Override
    public void run() {
        while (Thread.currentThread() == this.kfmThread) {
            while (!this.kfm.finishedLearning()) {
                this.kfm.learn();
                if (!this.kfm.displayNow()) continue;
                try {
                    this.setWeights(this.kfm.getWeightValues());
                    this.draw();
                    this.updateStatus(this.kfm.getLearningCycle(), this.kfm.getLearningRate(), this.kfm.getActivationArea(), this.kfm.getElapsedTime());
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.startButton.disable();
            this.stopButton.disable();
            this.updateStatus(this.kfm.getLearningCycle(), this.kfm.getLearningRate(), this.kfm.getActivationArea(), this.kfm.getElapsedTime());
            double d1 = this.kfm.getActivationArea();
            while (d1 > 0.0) {
                try {
                    this.draw();
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void updateStatus(int i, double d1, double d2, String s) {
        this.setFont(this.statusTextFont);
        this.statusLabel[1].setText(String.valueOf(i));
        this.statusLabel[3].setText(String.valueOf(d1));
        this.statusLabel[5].setText(String.valueOf(d2));
        this.statusLabel[7].setText(s + "  sec");
    }

    public void setWeights(float[][] af) {
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = new Point3D((int)af[0][i], (int)af[1][i], (int)af[2][i]);
        }
    }

    public final synchronized void draw() {
        this.td.changeAngles();
        this.boundingBoxDraw = this.td.rotate3Dto2D(this.boundingBox);
        this.inputsDraw = this.td.rotate3Dto2D(this.inputs);
        this.weightsDraw = this.td.rotate3Dto2D(this.weights);
        Graphics g = this.offscreen.getGraphics();
        g.setColor(this.sandColor);
        g.fillRect(0, 0, this.d.width + 1, this.d.height + 1);
        g.setColor(Color.blue);
        for (int i = 0; i < this.inputsDraw.length; ++i) {
            g.fillRect(this.inputsDraw[i].x - 2, this.inputsDraw[i].y - 2, 4, 4);
        }
        g.setColor(this.boxColor);
        for (int j = 0; j < 7; j += 2) {
            g.drawLine(this.boundingBoxDraw[j].x, this.boundingBoxDraw[j].y, this.boundingBoxDraw[j + 1].x, this.boundingBoxDraw[j + 1].y);
        }
        for (int k = 0; k < 4; ++k) {
            g.drawLine(this.boundingBoxDraw[k].x, this.boundingBoxDraw[k].y, this.boundingBoxDraw[k + 4].x, this.boundingBoxDraw[k + 4].y);
        }
        g.drawLine(this.boundingBoxDraw[0].x, this.boundingBoxDraw[0].y, this.boundingBoxDraw[2].x, this.boundingBoxDraw[2].y);
        g.drawLine(this.boundingBoxDraw[1].x, this.boundingBoxDraw[1].y, this.boundingBoxDraw[3].x, this.boundingBoxDraw[3].y);
        g.drawLine(this.boundingBoxDraw[4].x, this.boundingBoxDraw[4].y, this.boundingBoxDraw[6].x, this.boundingBoxDraw[6].y);
        g.drawLine(this.boundingBoxDraw[5].x, this.boundingBoxDraw[5].y, this.boundingBoxDraw[7].x, this.boundingBoxDraw[7].y);
        g.setColor(Color.darkGray);
        for (int l = 1; l < this.weightsDraw.length; ++l) {
            if (l % this.mapSizeY == 0) continue;
            g.drawLine(this.weightsDraw[l - 1].x, this.weightsDraw[l - 1].y, this.weightsDraw[l].x, this.weightsDraw[l].y);
        }
        for (int i1 = 0; i1 < this.mapSizeY; ++i1) {
            for (int j1 = 1; j1 < this.mapSizeX; ++j1) {
                int k1 = (j1 - 1) * this.mapSizeY + i1;
                int l1 = j1 * this.mapSizeY + i1;
                g.drawLine(this.weightsDraw[k1].x, this.weightsDraw[k1].y, this.weightsDraw[l1].x, this.weightsDraw[l1].y);
            }
        }
        g = this.drawCanvas.getGraphics();
        g.drawImage(this.offscreen, 0, 0, this.drawCanvas);
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            if (this.parametersFrame != null) {
                this.parametersFrame.dispose();
                this.parametersFrame = null;
            }
            this.stop();
            System.exit(0);
        }
        return super.handleEvent(event);
    }

    @Override
    public boolean action(Event event, Object obj) {
        if (event.target == this.startButton) {
            this.itLearns = true;
            this.startButton.disable();
            this.stopButton.enable();
            this.start();
            return false;
        }
        if (event.target == this.resetButton) {
            this.itLearns = false;
            if (this.kfmThread != null) {
                this.kfmThread.stop();
                this.kfmThread = null;
            }
            this.startButton.enable();
            this.stopButton.disable();
            this.setNetParameters();
            return false;
        }
        if (event.target == this.stopButton) {
            this.startButton.disable();
            this.stopButton.disable();
            this.maxCycle = this.kfm.getLearningCycle();
            return false;
        }
        if (event.target == this.parametersButton) {
            if (this.parametersFrame == null) {
                this.parametersFrame = new ParametersFrame(600, 10);
            } else if (!this.parametersFrame.isShowing()) {
                this.parametersFrame.show();
            }
            return false;
        }
        if (event.target == this.exitButton) {
            this.parametersFrame.dispose();
            this.parametersFrame = null;
            if (this.kfmThread != null) {
                this.kfmThread.stop();
                this.kfmThread = null;
            }
            this.stop();
            System.exit(0);
        }
        if (event.id == 201) {
            if (this.parametersFrame != null) {
                this.parametersFrame.dispose();
                this.parametersFrame = null;
            }
            this.stop();
            System.exit(0);
        }
        return false;
    }

    @Override
    public String getAppletInfo() {
        String s = "";
        s = s + "\nName:  3D Kohonen Feature Map";
        s = s + "\n\nDescription:\nThis applet demonstrates a Kohonen Feature Map Neural Net";
        s = s + "\nwith a 2- or 3-dimensional input neuron layer.";
        s = s + "\nIt uses specific classes for neural net components which I";
        s = s + "\nimplemented for my diploma at the Fachhochschule Regensburg.";
        s = s + "\n\nAuthor:  Jochen Froehlich  ( jochen.froehlich@stud.fh-regensburg.de )";
        s = s + "\n\nLast modified:  18-Nov-1996";
        s = s + "\n\nCopyright 1996 by Jochen Froehlich";
        s = s + "\nAll rights reserved";
        return s;
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] as = new String[][]{{"", "", ""}};
        return as;
    }
}

