/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jhpro.nnet.NeuralNet;
import jhpro.nnet.NeuronLayer;
import jhpro.nnet.Pattern;
import jhpro.nnet.WeightMatrix;

public class BackpropagationNet
extends NeuralNet {
    Vector neuronLayerVector;
    NeuronLayer[] neuronLayerArray;
    WeightMatrix[] weightMatrixArray;
    Pattern[] inputPatternArray;
    Pattern[] targetPatternArray;
    String[] outputPatternArray;
    double minimumError;
    double error;
    double accuracy;
    float[][] layerOutputError;
    String[][] conversionTable;
    int lastLayer;
    int lastMatrix;
    int lastPattern;
    int multiplier;

    public BackpropagationNet() {
        this.learningCycle = 0;
        this.maxLearningCycles = -1;
        this.minimumError = 5.0E-4;
        this.learningRate = 0.25;
        this.error = 1000.0;
        this.multiplier = 0;
        this.accuracy = 0.2;
        this.neuronLayerVector = new Vector();
        this.stopLearning = false;
        this.resetTime();
    }

    public void addNeuronLayer(int i) {
        this.neuronLayerVector.addElement(new NeuronLayer(i * this.multiplier));
    }

    public void connectLayers() {
        this.weightMatrixArray = new WeightMatrix[this.neuronLayerVector.size() - 1];
        this.neuronLayerArray = new NeuronLayer[this.neuronLayerVector.size()];
        int i = 0;
        Enumeration enumeration = this.neuronLayerVector.elements();
        while (enumeration.hasMoreElements()) {
            this.neuronLayerArray[i++] = (NeuronLayer)enumeration.nextElement();
        }
        this.neuronLayerVector = null;
        for (int j = 0; j < this.weightMatrixArray.length; ++j) {
            this.weightMatrixArray[j] = new WeightMatrix(this.neuronLayerArray[j].size(), this.neuronLayerArray[j + 1].size(), true);
            this.weightMatrixArray[j].init();
        }
        this.lastLayer = this.neuronLayerArray.length - 1;
        this.lastMatrix = this.weightMatrixArray.length - 1;
    }

    public void setMinimumError(double d) {
        this.minimumError = d;
    }

    public double getMinimumError() {
        return this.minimumError;
    }

    public void setAccuracy(double d) {
        this.accuracy = d;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public float[][] getWeightValues(int i) {
        return this.weightMatrixArray[i].getWeights();
    }

    public float[] getNeuronOutputs(int i) {
        return this.neuronLayerArray[i].getOutput();
    }

    public int getNumberOfLayers() {
        return this.neuronLayerArray.length;
    }

    public int getNumberOfNeurons(int i) {
        return this.neuronLayerArray[i].size();
    }

    public int getNumberOfWeights() {
        int i = 0;
        for (int j = 0; j <= this.lastMatrix; ++j) {
            i += this.weightMatrixArray[j].size();
        }
        return i;
    }

    public int getNumberOfWeights(int i) {
        return this.weightMatrixArray[i].size();
    }

    public int getNumberOfPatterns() {
        return this.inputPatternArray.length;
    }

    public String getInputPattern(int i) {
        return this.inputPatternArray[i].getPatternString();
    }

    public String getTargetPattern(int i) {
        return this.targetPatternArray[i].getPatternString();
    }

    public String getOutputPattern(int i) {
        String s = new String();
        String s1 = new String();
        float f = 0.0f;
        for (int j = 0; j < this.layerOutputError[0].length; ++j) {
            float f1 = this.targetPatternArray[i].getValue(j) - this.layerOutputError[i][j];
            s1 = s1 + ((double)f1 >= this.accuracy / 10.0 ? "1" : "0");
        }
        s = "";
        for (int k = 0; k < s1.length(); k += this.multiplier) {
            s = s + this.getAsciiValue(s1.substring(k, k + this.multiplier));
        }
        return s;
    }

    public float getPatternError(int i) {
        float f = 0.0f;
        for (int j = 0; j < this.layerOutputError[0].length; ++j) {
            f += Math.abs(this.layerOutputError[i][j]);
        }
        return f;
    }

    public double getError() {
        return this.error;
    }

    public void learn() {
        if (this.error > this.minimumError && (this.learningCycle < this.maxLearningCycles || this.maxLearningCycles == -1)) {
            ++this.learningCycle;
            for (int i = 0; i <= this.lastPattern; ++i) {
                this.neuronLayerArray[0].setInput(this.inputPatternArray[i]);
                for (int j = 1; j <= this.lastLayer; ++j) {
                    this.neuronLayerArray[j].computeInput(this.neuronLayerArray[j - 1], this.weightMatrixArray[j - 1]);
                    this.neuronLayerArray[j].computeOutput();
                }
                this.neuronLayerArray[this.lastLayer].computeLayerError(this.targetPatternArray[i]);
                this.layerOutputError[i] = this.neuronLayerArray[this.lastLayer].getLayerError();
                for (int k = this.lastMatrix; k >= 0; --k) {
                    this.weightMatrixArray[k].changeWeights(this.neuronLayerArray[k].getOutput(), this.neuronLayerArray[k + 1].getLayerError(), this.learningRate);
                    if (k <= 0) continue;
                    this.neuronLayerArray[k].computeLayerError(this.neuronLayerArray[k + 1], this.weightMatrixArray[k]);
                }
            }
            double d = 0.0;
            for (int l = 0; l < this.layerOutputError.length; ++l) {
                for (int i1 = 0; i1 < this.layerOutputError[0].length; ++i1) {
                    d += this.square(this.layerOutputError[l][i1]);
                }
            }
            this.error = Math.abs(d * 0.5);
            return;
        }
        this.stopLearning = true;
    }

    public String recall(String s) {
        Pattern pattern = new Pattern(s, this.conversionTable);
        float[] af = new float[this.targetPatternArray[0].size()];
        this.neuronLayerArray[0].setInput(pattern);
        for (int i = 1; i <= this.lastLayer; ++i) {
            this.neuronLayerArray[i].computeInput(this.neuronLayerArray[i - 1], this.weightMatrixArray[i - 1]);
            this.neuronLayerArray[i].computeOutput();
        }
        af = this.neuronLayerArray[this.lastLayer].getOutput();
        String s2 = "";
        String s1 = "";
        for (int j = 0; j < af.length; ++j) {
            s1 = s1 + ((double)af[j] >= this.accuracy ? "1" : "0");
        }
        for (int k = 0; k < s1.length(); k += this.multiplier) {
            s2 = s2 + this.getAsciiValue(s1.substring(k, k + this.multiplier));
        }
        return s2;
    }

    public synchronized void readConversionFile(String s) {
        Object obj = null;
        try {
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(s));
            int i = Integer.parseInt(datainputstream.readLine());
            this.conversionTable = new String[i][2];
            for (int j = 0; j < i; ++j) {
                String s1 = datainputstream.readLine();
                this.conversionTable[j][0] = String.valueOf(s1.charAt(0));
                this.conversionTable[j][1] = s1.substring(1);
            }
            this.multiplier = this.conversionTable[0][1].length();
            return;
        }
        catch (FileNotFoundException _ex) {
            this.error(105);
            return;
        }
        catch (IOException _ex) {
            this.error(104);
            return;
        }
    }

    public String getAsciiValue(String s) {
        int i = 0;
        int j = this.conversionTable.length;
        boolean flag = false;
        boolean flag1 = false;
        while (i < j) {
            int k = i + j >> 1;
            int l = s.compareTo(this.conversionTable[k][1]);
            if (l == 0) {
                return this.conversionTable[k][0];
            }
            if (l > 0) {
                i = k;
                continue;
            }
            j = k;
        }
        return "*";
    }

    public synchronized void readPatternFile(String s) {
        Object obj = null;
        try {
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(s));
            try {
                int k;
                int i = Integer.parseInt(datainputstream.readLine());
                int j = Integer.parseInt(datainputstream.readLine());
                if (j * this.multiplier != this.neuronLayerArray[0].size()) {
                    this.error(106);
                }
                if ((k = Integer.parseInt(datainputstream.readLine())) * this.multiplier != this.neuronLayerArray[this.lastLayer].size()) {
                    this.error(107);
                }
                this.inputPatternArray = new Pattern[i];
                this.targetPatternArray = new Pattern[i];
                this.outputPatternArray = new String[i];
                this.lastPattern = this.inputPatternArray.length - 1;
                this.layerOutputError = new float[this.lastPattern + 1][this.neuronLayerArray[this.lastLayer].size()];
                for (int l = 0; l < i; ++l) {
                    String s1 = datainputstream.readLine();
                    if (s1 == null) {
                        this.error(102);
                        continue;
                    }
                    if (s1.length() != j + k + 1) {
                        this.error(100);
                        continue;
                    }
                    this.inputPatternArray[l] = new Pattern(s1.substring(0, j), this.conversionTable);
                    this.targetPatternArray[l] = new Pattern(s1.substring(j + 1), this.conversionTable);
                    this.outputPatternArray[l] = new String();
                }
                return;
            }
            catch (EOFException _ex) {
                this.error(102);
                return;
            }
        }
        catch (FileNotFoundException _ex) {
            this.error(105);
            return;
        }
        catch (IOException _ex) {
            this.error(104);
            return;
        }
    }
}

